/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import org.esa.smos.dgg.SmosDgg;
import org.esa.smos.gui.export.GridPointFilter;

public class RegionFilter
implements GridPointFilter {
    private final GridPointFilter filter;

    public RegionFilter(Shape region) {
        RectangularShape rectangularShape;
        this.filter = region instanceof RectangularShape ? ((rectangularShape = (RectangularShape)region).isEmpty() ? this.createPointFilter(new Point2D.Double(rectangularShape.getX(), rectangularShape.getY())) : RegionFilter.createAreaFilter(region)) : RegionFilter.createAreaFilter(region);
    }

    @Override
    public boolean accept(int id, CompoundData gridPointData) throws IOException {
        return this.filter.accept(id, gridPointData);
    }

    private GridPointFilter createPointFilter(Point2D point) {
        try {
            SmosDgg.getInstance().getImageToMapTransform().inverseTransform(point, point);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        int x = (int)point.getX();
        int y = (int)point.getY();
        MultiLevelImage mli = SmosDgg.getInstance().getMultiLevelImage();
        final int seqnum = mli.getData(new Rectangle(x, y, 1, 1)).getSample(x, y, 0);
        return new GridPointFilter(){

            @Override
            public boolean accept(int id, CompoundData gridPointData) throws IOException {
                return SmosDgg.gridPointIdToSeqnum((int)id) == seqnum;
            }
        };
    }

    private static GridPointFilter createAreaFilter(final Shape area) {
        return new GridPointFilter(){

            @Override
            public boolean accept(int id, CompoundData gridPointData) throws IOException {
                double lat = gridPointData.getDouble("Latitude");
                double lon = gridPointData.getDouble("Longitude");
                if (lon > 180.0) {
                    lon -= 360.0;
                }
                return area.contains(lon, lat);
            }
        };
    }
}

