/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.io.File;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.gpf.annotations.Parameter;

public class GridPointExportParameter {
    @Parameter(alias="useSelectedProduct")
    private boolean useSelectedProduct;
    @Parameter(alias="sourceDirectory")
    private File sourceDirectory;
    @Parameter(alias="openFileDialog")
    private boolean openFileDialog;
    @Parameter(alias="recursive", defaultValue="false")
    private boolean recursive;
    @Parameter(alias="roiType", defaultValue="2", valueSet={"0", "1", "2"})
    private int roiType;
    @Parameter(alias="geometry")
    private VectorDataNode geometryNode;
    @Parameter(alias="northBound", defaultValue="90.0", interval="[-90.0, 90.0]")
    private double north;
    @Parameter(alias="southBound", defaultValue="-90.0", interval="[-90.0, 90.0]")
    private double south;
    @Parameter(alias="eastBound", defaultValue="180.0", interval="[-180.0, 180.0]")
    private double east;
    @Parameter(alias="westBound", defaultValue="-180.0", interval="[-180.0, 180.0]")
    private double west;
    @Parameter(alias="targetFileOrDir", notNull=true, notEmpty=true)
    private File targetFile;
    @Parameter(alias="exportFormat", defaultValue="CSV", valueSet={"CSV", "Earth Explorer subsets"})
    private String exportFormat;

    public void setUseSelectedProduct(boolean useSelectedProduct) {
        this.useSelectedProduct = useSelectedProduct;
    }

    public boolean isUseSelectedProduct() {
        return this.useSelectedProduct;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setOpenFileDialog(boolean openFileDialog) {
        this.openFileDialog = openFileDialog;
    }

    public boolean isOpenFileDialog() {
        return this.openFileDialog;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRoiType(int roiType) {
        this.roiType = roiType;
    }

    public int getRoiType() {
        return this.roiType;
    }

    public VectorDataNode getGeometryNode() {
        return this.geometryNode;
    }

    public void setGeometryNode(VectorDataNode geometryNode) {
        this.geometryNode = geometryNode;
    }

    public void setNorth(double north) {
        this.north = north;
    }

    public double getNorth() {
        return this.north;
    }

    public void setSouth(double south) {
        this.south = south;
    }

    public double getSouth() {
        return this.south;
    }

    public void setEast(double east) {
        this.east = east;
    }

    public double getEast() {
        return this.east;
    }

    public void setWest(double west) {
        this.west = west;
    }

    public double getWest() {
        return this.west;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setExportFormat(String exportFormat) {
        this.exportFormat = exportFormat;
    }

    public String getExportFormat() {
        return this.exportFormat;
    }

    public GridPointExportParameter getClone() {
        GridPointExportParameter clone = new GridPointExportParameter();
        clone.setUseSelectedProduct(this.useSelectedProduct);
        clone.setSourceDirectory(new File(this.sourceDirectory.getPath()));
        clone.setOpenFileDialog(this.openFileDialog);
        clone.setRecursive(this.recursive);
        clone.setRoiType(this.roiType);
        clone.setGeometryNode(this.geometryNode);
        clone.setNorth(this.north);
        clone.setSouth(this.south);
        clone.setEast(this.east);
        clone.setWest(this.west);
        clone.setTargetFile(new File(this.targetFile.getPath()));
        clone.setExportFormat(this.exportFormat);
        return clone;
    }
}

