/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.esa.smos.dataio.smos.ProductFile;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.SmosProductReader;
import org.esa.smos.gui.ChooserFactory;
import org.esa.smos.gui.DefaultChooserFactory;
import org.esa.smos.gui.ProductChangeAwareDialog;
import org.esa.smos.gui.export.GridPointExportParameter;
import org.esa.smos.gui.export.GridPointExportSwingWorker;
import org.esa.smos.gui.swing.GuiHelper;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.FileChooserFactory;

class GridPointExportDialog
extends ProductChangeAwareDialog {
    static final String ALIAS_RECURSIVE = "recursive";
    static final String ALIAS_TARGET_FILE = "targetFileOrDir";
    static final String ALIAS_EXPORT_FORMAT = "exportFormat";
    static final String NAME_CSV = "CSV";
    static final String NAME_EEF = "Earth Explorer subsets";
    private final AppContext appContext;
    private final PropertyContainer propertyContainer;
    private final BindingContext bindingContext;
    private ProductChangeAwareDialog.GeometryListener geometryListener;
    private final GridPointExportParameter gridPointExportParameter = new GridPointExportParameter();

    GridPointExportDialog(AppContext appContext, String helpId) {
        super(appContext.getApplicationWindow(), "Export SMOS Grid Points", 145, helpId);
        this.appContext = appContext;
        this.propertyContainer = PropertyContainer.createObjectBacked((Object)this.gridPointExportParameter, (PropertyDescriptorFactory)new ParameterDescriptorFactory());
        try {
            this.initPropertyContainer();
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
        this.bindingContext = new BindingContext((PropertySet)this.propertyContainer);
        this.bindingContext.bindEnabledState("geometry", true, "roiType", (Object)0);
        GuiHelper.bindLonLatPanelToRoiType(2, this.bindingContext);
        this.createUI();
        ProductManager productManager = appContext.getProductManager();
        productManager.addListener((ProductManager.Listener)new ProductChangeAwareDialog.ProductManagerListener(this));
        this.geometryListener = new ProductChangeAwareDialog.GeometryListener(this);
        SelectionSupport selectionSupport = SnapApp.getDefault().getSelectionSupport(Product.class);
        selectionSupport.addHandler((SelectionSupport.Handler)this);
    }

    protected void onOK() {
        File sourceDirectory = (File)this.propertyContainer.getValue("sourceDirectory");
        File targetFile = (File)this.propertyContainer.getValue(ALIAS_TARGET_FILE);
        GuiHelper.setDefaultSourceDirectory(sourceDirectory, this.appContext);
        this.setDefaultTargetFile(targetFile);
        if (targetFile.exists() && targetFile.isFile()) {
            String message = MessageFormat.format("The selected target file\n''{0}''\nalready exists.\n\nDo you want to overwrite the target file?", targetFile.getPath());
            int answer = JOptionPane.showConfirmDialog(this.getJDialog(), message, this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
        }
        GridPointExportSwingWorker swingWorker = new GridPointExportSwingWorker(this.appContext, this.gridPointExportParameter.getClone());
        GuiHelper.setDefaultSourceDirectory(this.gridPointExportParameter.getSourceDirectory(), this.appContext);
        File exportedFile = this.gridPointExportParameter.getTargetFile();
        if (exportedFile != null) {
            GuiHelper.setDefaultTargetDirectory(exportedFile.getParentFile(), this.appContext);
        }
        swingWorker.execute();
    }

    protected boolean verifyUserInput() {
        int roiType = (Integer)this.propertyContainer.getValue("roiType");
        if (roiType == 2) {
            double west;
            double south;
            double north = (Double)this.propertyContainer.getValue("northBound");
            if (north <= (south = ((Double)this.propertyContainer.getValue("southBound")).doubleValue())) {
                this.showErrorDialog("The southern latitude must be less than the northern latitude.");
                return false;
            }
            double east = (Double)this.propertyContainer.getValue("eastBound");
            if (east <= (west = ((Double)this.propertyContainer.getValue("westBound")).doubleValue())) {
                this.showErrorDialog("The western longitude must be less than the eastern longitude.");
                return false;
            }
        }
        File targetFile = (File)this.propertyContainer.getValue(ALIAS_TARGET_FILE);
        String exportFormat = (String)this.propertyContainer.getValue(ALIAS_EXPORT_FORMAT);
        if (NAME_CSV.equals(exportFormat)) {
            if (targetFile.exists() && !targetFile.isFile()) {
                this.showErrorDialog("The target file must be a normal file, not a directory.");
                return false;
            }
        } else if (targetFile.exists() && !targetFile.isDirectory()) {
            this.showErrorDialog("The target file must be a directory, not a normal file.");
            return false;
        }
        return true;
    }

    private void initPropertyContainer() throws ValidationException {
        this.propertyContainer.setDefaultValues();
        File defaultSourceDirectory = GuiHelper.getDefaultSourceDirectory(this.appContext);
        this.propertyContainer.setValue("sourceDirectory", (Object)defaultSourceDirectory);
        File targetFile = this.getDefaultTargetFile();
        this.propertyContainer.setValue(ALIAS_TARGET_FILE, (Object)targetFile);
        this.updateSelectedProductAndGeometries();
        if (targetFile.isDirectory()) {
            this.propertyContainer.setValue(ALIAS_EXPORT_FORMAT, (Object)NAME_EEF);
        }
        this.propertyContainer.addPropertyChangeListener(ALIAS_EXPORT_FORMAT, (PropertyChangeListener)new ExportFormatChangeListener());
    }

    private void updateSelectedProductAndGeometries() throws ValidationException {
        Product selectedProduct = this.getSelectedSmosProduct();
        if (selectedProduct != null) {
            List<VectorDataNode> geometryNodeList = GuiHelper.getGeometryNodes(selectedProduct);
            if (!geometryNodeList.isEmpty()) {
                GuiHelper.bindGeometryNodes(geometryNodeList, (PropertySet)this.propertyContainer);
            } else {
                this.removeGeometries();
                if (selectedProduct.getPinGroup().getNodeCount() != 0) {
                    this.propertyContainer.setValue("roiType", (Object)1);
                }
            }
        }
        this.propertyContainer.setValue("useSelectedProduct", (Object)(selectedProduct != null ? 1 : 0));
        this.setSelectedProductButtonEnabled(selectedProduct != null);
    }

    private void removeProductAndGeometries(Product product) throws ValidationException {
        Product selectedSmosProduct = this.getSelectedSmosProduct();
        if (selectedSmosProduct == null) {
            this.propertyContainer.setValue("useSelectedProduct", (Object)false);
            this.setSelectedProductButtonEnabled(false);
            List<VectorDataNode> geometryNodeList = GuiHelper.getGeometryNodes(product);
            if (!geometryNodeList.isEmpty()) {
                this.removeGeometries();
            }
        }
    }

    private void setSelectedProductButtonEnabled(boolean enabled) {
        JComponent[] components;
        if (this.bindingContext == null) {
            return;
        }
        Binding binding = this.bindingContext.getBinding("useSelectedProduct");
        for (JComponent component : components = binding.getComponents()) {
            if (!(component instanceof JRadioButton) || !((JRadioButton)component).getText().equals("Use selected SMOS product")) continue;
            component.setEnabled(enabled);
            break;
        }
    }

    private void removeGeometries() throws ValidationException {
        Property geometryProperty = this.propertyContainer.getProperty("geometry");
        geometryProperty.getDescriptor().setValueSet(new ValueSet((Object[])new VectorDataNode[0]));
        this.propertyContainer.setValue("geometry", null);
        this.propertyContainer.setValue("roiType", (Object)2);
    }

    private void createUI() {
        JPanel mainPanel = GuiHelper.createPanelWithBoxLayout();
        mainPanel.add(this.createSourceProductPanel());
        mainPanel.add(this.createRoiPanel());
        mainPanel.add(this.createTargetFilePanel());
        this.setContent(mainPanel);
    }

    private JComponent createSourceProductPanel() {
        boolean useSelectProductEnabled = this.getSelectedSmosProduct() != null;
        TableLayout layout = GuiHelper.createWeightedTableLayout(1);
        JPanel sourceProductPanel = new JPanel((LayoutManager)layout);
        sourceProductPanel.setBorder(BorderFactory.createTitledBorder("Source Products"));
        GuiHelper.addSourceProductsButtons(sourceProductPanel, useSelectProductEnabled, this.bindingContext);
        JCheckBox checkBox = new JCheckBox("Descend into subdirectories");
        this.bindingContext.bind(ALIAS_RECURSIVE, checkBox);
        this.bindingContext.bindEnabledState(ALIAS_RECURSIVE, true, "useSelectedProduct", (Object)false);
        PropertyDescriptor sourceDirectoryDescriptor = this.propertyContainer.getDescriptor("sourceDirectory");
        JComponent fileEditor = GuiHelper.createFileEditorComponent(sourceDirectoryDescriptor, new DefaultChooserFactory(), this.bindingContext);
        layout.setCellPadding(2, 0, new Insets(0, 24, 3, 3));
        sourceProductPanel.add(fileEditor);
        layout.setCellPadding(3, 0, new Insets(0, 24, 3, 3));
        sourceProductPanel.add(checkBox);
        return sourceProductPanel;
    }

    private Component createRoiPanel() {
        JRadioButton useGeometryButton = new JRadioButton("Geometry");
        PropertyDescriptor geometryDescriptor = this.propertyContainer.getDescriptor("geometry");
        if (geometryDescriptor != null && geometryDescriptor.getValueSet() == null) {
            useGeometryButton.setEnabled(false);
        }
        JRadioButton usePinsButton = new JRadioButton("Pins");
        Product selectedProduct = this.getSelectedSmosProduct();
        if (selectedProduct == null || selectedProduct.getPinGroup().getNodeCount() == 0) {
            usePinsButton.setEnabled(false);
        }
        JRadioButton useAreaButton = new JRadioButton("Area");
        HashMap<JRadioButton, Integer> buttonGroupValueSet = new HashMap<JRadioButton, Integer>();
        buttonGroupValueSet.put(useGeometryButton, 0);
        buttonGroupValueSet.put(usePinsButton, 1);
        buttonGroupValueSet.put(useAreaButton, 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(useGeometryButton);
        buttonGroup.add(usePinsButton);
        buttonGroup.add(useAreaButton);
        this.bindingContext.bind("roiType", buttonGroup, buttonGroupValueSet);
        JComboBox geometryComboBox = GuiHelper.createGeometryNodeComboBox(geometryDescriptor, this.bindingContext);
        TableLayout layout = GuiHelper.createWeightedTableLayout(1);
        JPanel roiPanel = new JPanel((LayoutManager)layout);
        roiPanel.setBorder(BorderFactory.createTitledBorder("Region of Interest"));
        roiPanel.add(useGeometryButton);
        roiPanel.add(geometryComboBox);
        roiPanel.add(usePinsButton);
        roiPanel.add(useAreaButton);
        Component latLonPanel = GuiHelper.createLatLonPanel(this.propertyContainer, this.bindingContext);
        roiPanel.add(latLonPanel);
        layout.setCellPadding(1, 0, new Insets(0, 24, 3, 3));
        layout.setCellPadding(3, 0, new Insets(0, 24, 3, 3));
        return roiPanel;
    }

    private JComponent createTargetFilePanel() {
        TableLayout layout = GuiHelper.createWeightedTableLayout(1);
        JPanel targetFilePanel = new JPanel((LayoutManager)layout);
        targetFilePanel.setBorder(BorderFactory.createTitledBorder("Target File"));
        PropertyDescriptor formatDescriptor = this.propertyContainer.getDescriptor(ALIAS_EXPORT_FORMAT);
        JComboBox<Object> formatComboBox = new JComboBox<Object>(formatDescriptor.getValueSet().getItems());
        this.bindingContext.bind(ALIAS_EXPORT_FORMAT, formatComboBox);
        JPanel formatPanel = new JPanel(new FlowLayout(3, 0, 0));
        formatPanel.add(new JLabel("Export as:"));
        formatPanel.add(formatComboBox);
        JLabel label = new JLabel();
        if (NAME_CSV.equals(this.propertyContainer.getValue(ALIAS_EXPORT_FORMAT))) {
            label.setText("Save to file:");
        } else {
            label.setText("Save subset files to directory:");
        }
        PropertyDescriptor targetFileDescriptor = this.propertyContainer.getDescriptor(ALIAS_TARGET_FILE);
        ChooserFactory chooserFactory = file -> {
            JFileChooser fileChooser;
            FileChooserFactory fileChooserFactory = FileChooserFactory.getInstance();
            if (NAME_CSV.equals(this.bindingContext.getBinding(ALIAS_EXPORT_FORMAT).getPropertyValue())) {
                fileChooser = fileChooserFactory.createFileChooser(file);
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.setFileFilter(new FileNameExtensionFilter(NAME_CSV, NAME_CSV));
            } else {
                fileChooser = fileChooserFactory.createDirChooser(file);
            }
            return fileChooser;
        };
        JComponent fileEditor = GuiHelper.createFileEditorComponent(targetFileDescriptor, chooserFactory, this.bindingContext);
        targetFilePanel.add(formatPanel);
        targetFilePanel.add(label);
        targetFilePanel.add(fileEditor);
        this.bindingContext.addPropertyChangeListener(ALIAS_EXPORT_FORMAT, propertyChangeEvent -> {
            if (NAME_CSV.equals(propertyChangeEvent.getNewValue())) {
                label.setText("Save to file:");
            } else {
                label.setText("Save subset files to directory:");
            }
        });
        return targetFilePanel;
    }

    private File getDefaultTargetFile() {
        String def = new File(System.getProperty("user.home", "."), "export.csv").getPath();
        return new File(this.appContext.getPreferences().getPropertyString("org.esa.smos.export.targetFile", def));
    }

    private void setDefaultTargetFile(File targetFile) {
        this.appContext.getPreferences().setPropertyString("org.esa.smos.export.targetFile", targetFile.getPath());
    }

    private Product getSelectedSmosProduct() {
        SmosProductReader smosProductReader;
        ProductFile productFile;
        ProductReader productReader;
        Product selectedProduct = this.appContext.getSelectedProduct();
        if (selectedProduct != null && (productReader = selectedProduct.getProductReader()) instanceof SmosProductReader && (productFile = (smosProductReader = (SmosProductReader)productReader).getProductFile()) instanceof SmosFile) {
            selectedProduct.addProductNodeListener((ProductNodeListener)this.geometryListener);
            return selectedProduct;
        }
        return null;
    }

    @Override
    protected void productAdded() {
        try {
            this.updateSelectedProductAndGeometries();
        }
        catch (ValidationException e) {
            this.showErrorDialog("Internal error: " + e.getMessage());
        }
    }

    @Override
    protected void productRemoved(Product product) {
        try {
            this.removeProductAndGeometries(product);
        }
        catch (ValidationException e) {
            this.showErrorDialog("Internal error: " + e.getMessage());
        }
        product.removeProductNodeListener((ProductNodeListener)this.geometryListener);
    }

    @Override
    protected void geometryAdded() {
        try {
            this.updateSelectedProductAndGeometries();
        }
        catch (ValidationException e) {
            this.showErrorDialog("Internal error: " + e.getMessage());
        }
    }

    @Override
    protected void geometryRemoved() {
        try {
            this.updateSelectedProductAndGeometries();
        }
        catch (ValidationException e) {
            this.showErrorDialog("Internal error: " + e.getMessage());
        }
    }

    @Override
    protected void productSelectionChanged() {
        try {
            this.updateSelectedProductAndGeometries();
        }
        catch (ValidationException e) {
            this.showErrorDialog("Internal error: " + e.getMessage());
        }
    }

    protected void onClose() {
        SelectionSupport selectionSupport = SnapApp.getDefault().getSelectionSupport(Product.class);
        selectionSupport.removeHandler((SelectionSupport.Handler)this);
        super.onClose();
    }

    private class ExportFormatChangeListener
    implements PropertyChangeListener {
        File last;

        private ExportFormatChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (GridPointExportDialog.NAME_CSV.equals(evt.getNewValue())) {
                File dir = (File)GridPointExportDialog.this.propertyContainer.getValue(GridPointExportDialog.ALIAS_TARGET_FILE);
                if (this.last != null) {
                    GridPointExportDialog.this.propertyContainer.setValue(GridPointExportDialog.ALIAS_TARGET_FILE, (Object)new File(dir, this.last.getName()));
                }
            } else {
                this.last = (File)GridPointExportDialog.this.propertyContainer.getValue(GridPointExportDialog.ALIAS_TARGET_FILE);
                GridPointExportDialog.this.propertyContainer.setValue(GridPointExportDialog.ALIAS_TARGET_FILE, (Object)this.last.getParentFile());
            }
        }
    }
}

