/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import java.io.IOException;
import java.io.PrintWriter;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.gui.export.GridPointFilterStream;

class CsvExportStream
implements GridPointFilterStream {
    private final PrintWriter printWriter;
    private final String separator;

    public CsvExportStream(PrintWriter printWriter, String separator) {
        this.printWriter = printWriter;
        this.separator = separator;
    }

    @Override
    public void startFile(SmosFile smosFile) {
        this.printWriter.println("# " + smosFile.getDataFile().getParent());
        this.printTypeHeader((Type)smosFile.getGridPointType());
        this.printWriter.println();
    }

    private void printTypeHeader(Type type) {
        if (type.isCompoundType()) {
            CompoundType compoundType = (CompoundType)type;
            int memberCount = compoundType.getMemberCount();
            for (int i = 0; i < memberCount; ++i) {
                CompoundMember member = compoundType.getMember(i);
                if (member.getType().isSimpleType()) {
                    this.printWriter.print(member.getName());
                } else {
                    this.printTypeHeader(member.getType());
                }
                if (i >= memberCount - 1) continue;
                this.printWriter.print(this.separator);
            }
        } else if (type.isSequenceType()) {
            SequenceType sequenceType = (SequenceType)type;
            Type elementType = sequenceType.getElementType();
            this.printTypeHeader(elementType);
        }
    }

    @Override
    public void stopFile(SmosFile smosFile) {
        this.printWriter.println();
    }

    @Override
    public void handleGridPoint(int id, CompoundData gridPointData) throws IOException {
        int btDataIndex = gridPointData.getMemberIndex("BT_Data");
        if (btDataIndex != -1) {
            SequenceData sequence = gridPointData.getSequence(btDataIndex);
            for (int i = 0; i < sequence.getElementCount(); ++i) {
                this.writeCompound(gridPointData);
                this.writeCompound(sequence.getCompound(i));
                this.printWriter.println();
            }
        } else {
            this.writeCompound(gridPointData);
            this.printWriter.println();
        }
    }

    private void writeCompound(CompoundData compoundData) throws IOException {
        int memberCount = compoundData.getMemberCount();
        CompoundType gridPointType = compoundData.getType();
        for (int i = 0; i < memberCount; ++i) {
            CompoundMember member = gridPointType.getMember(i);
            if (member.getType().isSimpleType()) {
                String memberName = member.getName();
                if (member.getType() == SimpleType.DOUBLE || member.getType() == SimpleType.FLOAT) {
                    this.printWriter.print(compoundData.getDouble(i));
                } else {
                    String formatName = compoundData.getContext().getFormat().getName();
                    BandDescriptor descriptor = Dddb.getInstance().findBandDescriptorForMember(formatName, memberName);
                    long longValue = compoundData.getLong(i);
                    if (descriptor != null) {
                        double doubleValue = descriptor.getScalingFactor() * (double)longValue + descriptor.getScalingOffset();
                        this.printWriter.print(doubleValue);
                    } else {
                        this.printWriter.print(longValue);
                    }
                }
            } else if (member.getType().isCompoundType()) {
                this.writeCompound(compoundData.getCompound(i));
            }
            if (i >= memberCount - 1) continue;
            this.printWriter.print(this.separator);
        }
    }

    @Override
    public void close() throws IOException {
        this.printWriter.close();
    }
}

