/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.table.TableModel;
import org.esa.smos.gui.TableModelExporter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SelectExportMethodDialog;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TableModelExportRunner {
    private final Component parentComponent;
    private String title;
    private final TableModel model;
    private final TableColumnModelExt columnModel;

    public TableModelExportRunner(Component parentComponent, String title, TableModel model, TableColumnModelExt columnModel) {
        this.parentComponent = parentComponent;
        this.title = title;
        this.model = model;
        this.columnModel = columnModel;
    }

    public void run() {
        int method;
        if (this.model.getRowCount() == 0) {
            Dialogs.showMessage((String)this.title, (String)"The table is empty!", (int)1, null);
        }
        if ((method = SelectExportMethodDialog.run((Component)this.parentComponent, (String)this.title, (String)"How do you want to export the table?", (String)"")) == -1) {
            return;
        }
        TableModelExporter exporter = new TableModelExporter(this.model, this.columnModel);
        if (method == 1) {
            File outFile = TableModelExportRunner.promptForFile(this.title);
            if (outFile != null) {
                this.exportToFile(outFile, exporter);
            }
        } else if (method == 0) {
            this.exportToClipboard(exporter);
        }
    }

    private void exportToFile(final File outFile, final TableModelExporter exporter) {
        ProgressMonitorSwingWorker worker = new ProgressMonitorSwingWorker(this.parentComponent, "Table Model Export"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground(ProgressMonitor pm) throws Exception {
                pm.beginTask("Exporting table model...", 1);
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(outFile));){
                    exporter.export(stream);
                }
                finally {
                    pm.done();
                }
                return null;
            }

            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    e.getCause().printStackTrace();
                    String message = MessageFormat.format("The table could not be exported!\nReason: {0}", e.getCause().getMessage());
                    Dialogs.showMessage((String)TableModelExportRunner.this.title, (String)message, (int)0, null);
                }
            }
        };
        worker.execute();
    }

    private void exportToClipboard(final TableModelExporter exporter) {
        ProgressMonitorSwingWorker worker = new ProgressMonitorSwingWorker(this.parentComponent, "Table Model Export"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground(ProgressMonitor pm) throws Exception {
                pm.beginTask("Exporting table model...", 1);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (BufferedOutputStream stream = new BufferedOutputStream(out);){
                    exporter.export(stream);
                }
                finally {
                    pm.done();
                }
                return out.toString();
            }

            protected void done() {
                try {
                    Object result = this.get();
                    if (result instanceof String) {
                        SystemUtils.copyToClipboard((String)((String)result));
                    }
                }
                catch (InterruptedException result) {
                }
                catch (ExecutionException exex) {
                    Throwable cause = exex.getCause();
                    cause.printStackTrace();
                    String message = MessageFormat.format("The table could not be exported!\nReason: {0}", cause.getMessage());
                    Dialogs.showMessage((String)TableModelExportRunner.this.title, (String)message, (int)0, null);
                }
            }
        };
        worker.execute();
    }

    private static File promptForFile(String defaultFileName) {
        String dlgTitle = "Export Table";
        File file = null;
        while (file == null) {
            file = Dialogs.requestFileForSave((String)"Export Table", (boolean)false, null, (String)".txt", (String)defaultFileName, null, (String)"exportSmosTable.lastDir");
            if (file != null) continue;
            return null;
        }
        return file;
    }
}

