/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.util.BrowserUtils;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;

public class SMOSBoxAboutBox
extends JPanel {
    private static final String releaseNotesHTTP = "https://github.com/senbox-org/smos-box/blob/master/ReleaseNotes.md";

    public SMOSBoxAboutBox() {
        super(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        ModuleInfo moduleInfo = Modules.getDefault().ownerOf(SMOSBoxAboutBox.class);
        ImageIcon imageIcon = new ImageIcon(SMOSBoxAboutBox.class.getResource("smos_aboutbox.jpg"));
        JLabel label = new JLabel(imageIcon);
        this.add((Component)label, "Center");
        this.add((Component)this.createVersionPanel(), "South");
    }

    private JPanel createVersionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        ModuleInfo moduleInfo = Modules.getDefault().ownerOf(SMOSBoxAboutBox.class);
        panel.add(new JLabel("<html><b>SMOS-Box version " + moduleInfo.getImplementationVersion() + "</b>", 4));
        URI releaseNotesURI = this.getReleaseNotesURI();
        if (releaseNotesURI != null) {
            JLabel releaseNoteLabel = new JLabel("<html><a href=\"" + releaseNotesURI.toString() + "\">Release Notes</a>", 4);
            releaseNoteLabel.setCursor(new Cursor(12));
            releaseNoteLabel.addMouseListener((MouseListener)new BrowserUtils.URLClickAdaptor(releaseNotesHTTP));
            panel.add(releaseNoteLabel);
        }
        return panel;
    }

    private URI getReleaseNotesURI() {
        try {
            return new URI(releaseNotesHTTP);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

