/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.ui;

import com.bc.ceres.binding.ConversionException;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.util.HashMap;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.ui.NetcdfExportSwingWorker;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetcdfExportSwingWorkerTest {
    private ExportParameter exportParameter;

    @Before
    public void setUp() throws Exception {
        this.exportParameter = new ExportParameter();
    }

    @Test
    public void testCreateMap_sourceDirectory() {
        File expectedSourceDir = new File("/home/tom");
        this.exportParameter.setSourceDirectory(expectedSourceDir);
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        String sourceDirectory = (String)parameterMap.get("sourceProductPaths");
        String absolutePath = expectedSourceDir.getAbsolutePath();
        Assert.assertEquals((Object)(absolutePath + File.separator + "*.zip," + absolutePath + File.separator + "*.dbl," + absolutePath + File.separator + "*" + File.separator + "*.dbl"), (Object)sourceDirectory);
    }

    @Test
    public void testCreateMap_sourceDirectory_NotAddedWhenSingleProductSelected() {
        File expectedSourceDir = new File("/home/tom");
        this.exportParameter.setSourceDirectory(expectedSourceDir);
        this.exportParameter.setUseSelectedProduct(true);
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertFalse((boolean)parameterMap.containsKey("sourceProductPaths"));
    }

    @Test
    public void testCreateMap_targetDirectory() {
        File expectedTargetDir = new File("/out/put");
        this.exportParameter.setTargetDirectory(expectedTargetDir);
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        File targetDirectory = (File)parameterMap.get("targetDirectory");
        Assert.assertEquals((Object)expectedTargetDir.getAbsolutePath(), (Object)targetDirectory.getAbsolutePath());
    }

    @Test
    public void testCreateMap_area() {
        this.exportParameter.setNorthBound(22.9);
        this.exportParameter.setEastBound(100.6);
        this.exportParameter.setSouthBound(11.8);
        this.exportParameter.setWestBound(98.06);
        this.exportParameter.setRoiType(2);
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertEquals((Object)"POLYGON((98.06 22.9,100.6 22.9,100.6 11.8,98.06 11.8,98.06 22.9))", parameterMap.get("geometry"));
    }

    @Test
    public void testCreateMap_wholeProduct() {
        this.exportParameter.setRoiType(0);
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertNull(parameterMap.get("region"));
    }

    @Test
    public void testCreateMap_overwriteTarget() {
        this.exportParameter.setOverwriteTarget(true);
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertEquals((Object)"true", parameterMap.get("overwriteTarget"));
        this.exportParameter.setOverwriteTarget(false);
        parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertEquals((Object)"false", parameterMap.get("overwriteTarget"));
    }

    @Test
    public void testCreateMap_oneVariable() {
        this.exportParameter.setVariableNames(new String[]{"one_band"});
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertEquals((Object)"one_band", parameterMap.get("variableNames"));
    }

    @Test
    public void testCreateMap_threeVariable() {
        this.exportParameter.setVariableNames(new String[]{"band_one", "band_two", "band_three"});
        HashMap parameterMap = NetcdfExportSwingWorker.createParameterMap((ExportParameter)this.exportParameter);
        Assert.assertEquals((Object)"band_one,band_two,band_three", parameterMap.get("variableNames"));
    }

    @Test
    public void testCreateSourcePathWildcards() {
        File inputDir = new File("data");
        String pathWildcards = NetcdfExportSwingWorker.createSourcePathWildcards((File)inputDir);
        String absolutePath = inputDir.getAbsolutePath();
        Assert.assertEquals((Object)(absolutePath + File.separator + "*.zip," + absolutePath + File.separator + "*.dbl," + absolutePath + File.separator + "*" + File.separator + "*.dbl"), (Object)pathWildcards);
    }

    @Test
    public void testAddSelectedGeometry_polygon() throws ConversionException {
        JtsGeometryConverter converter = new JtsGeometryConverter();
        Geometry polygon = converter.parse("POLYGON((0 0, 1 0, 1 1, 0 1, 0 0))");
        HashMap parameterMap = new HashMap();
        NetcdfExportSwingWorker.addSelectedProductGeometry((Geometry)polygon, parameterMap);
        String region = (String)parameterMap.get("geometry");
        Assert.assertEquals((Object)"POLYGON ((0 0, 1 0, 1 1, 0 1, 0 0))", (Object)region);
    }

    @Test
    public void testAddSelectedGeometry_point() throws ConversionException {
        JtsGeometryConverter converter = new JtsGeometryConverter();
        Geometry polygon = converter.parse("POINT(4 6))");
        HashMap parameterMap = new HashMap();
        NetcdfExportSwingWorker.addSelectedProductGeometry((Geometry)polygon, parameterMap);
        Assert.assertFalse((boolean)parameterMap.containsKey("geometry"));
    }
}

