/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.ui;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.esa.smos.ee2netcdf.TestHelper;
import org.esa.smos.ee2netcdf.ui.NetcdfExportDialog;
import org.junit.Assert;
import org.junit.Test;

public class NetcdfExportDialogTest {
    @Test
    public void testGetTargetFiles_singleProduct() throws IOException {
        Path resourceFile = TestHelper.getResourcePath((String)"SM_OPER_MIR_BWLF1C_20111026T143206_20111026T152520_503_001_1.zip");
        String someNotExistingDir = "/some/not/existing/dir";
        Path targetDir = Paths.get(someNotExistingDir, new String[0]);
        List targetFiles = NetcdfExportDialog.getTargetFiles((Path)resourceFile, (Path)targetDir);
        Assert.assertNotNull((Object)targetFiles);
        Assert.assertEquals((long)1L, (long)targetFiles.size());
        Assert.assertEquals((Object)this.getAbsolutePath(someNotExistingDir, "SM_OPER_MIR_BWLF1C_20111026T143206_20111026T152520_503_001_1.nc"), targetFiles.get(0));
    }

    @Test
    public void testGetTargetFiles_directory() throws IOException {
        Path resourceDirectory = TestHelper.getResourceDirectory();
        String someNotExistingDir = "/some/not/existing/dir";
        Path targetDir = Paths.get(someNotExistingDir, new String[0]);
        List targetFiles = NetcdfExportDialog.getTargetFiles((Path)resourceDirectory, (String)"*.zip", (Path)targetDir);
        Assert.assertNotNull((Object)targetFiles);
        Assert.assertEquals((long)5L, (long)targetFiles.size());
        Assert.assertEquals((Object)this.getAbsolutePath(someNotExistingDir, "SM_OPER_MIR_BWLD1C_20100208T040959_20100208T050400_324_001_1.nc"), targetFiles.get(0));
        Assert.assertEquals((Object)this.getAbsolutePath(someNotExistingDir, "SM_OPER_MIR_BWLF1C_20111026T143206_20111026T152520_503_001_1.nc"), targetFiles.get(1));
        Assert.assertEquals((Object)this.getAbsolutePath(someNotExistingDir, "SM_OPER_MIR_OSUDP2_20091204T001853_20091204T011255_310_001_1.nc"), targetFiles.get(2));
        Assert.assertEquals((Object)this.getAbsolutePath(someNotExistingDir, "SM_OPER_MIR_SMUDP2_20120514T163815_20120514T173133_551_001_1.nc"), targetFiles.get(3));
        Assert.assertEquals((Object)this.getAbsolutePath(someNotExistingDir, "SM_REPB_MIR_SCLF1C_20110201T151254_20110201T151308_505_152_1.nc"), targetFiles.get(4));
    }

    private Path getAbsolutePath(String someNotExistingDir, String s) {
        return Paths.get(someNotExistingDir, s).toAbsolutePath();
    }

    @Test
    public void testGetExistingFiles_noneExists() {
        ArrayList<Path> targetFiles = new ArrayList<Path>();
        targetFiles.add(Paths.get("/fantasy/location/target/file", new String[0]));
        targetFiles.add(Paths.get("/not/existing/file", new String[0]));
        List existingFiles = NetcdfExportDialog.getExistingPaths(targetFiles);
        Assert.assertNotNull((Object)existingFiles);
        Assert.assertEquals((long)0L, (long)existingFiles.size());
    }

    @Test
    public void testGetExistingFiles_oneExists() {
        ArrayList<Path> targetPaths = new ArrayList<Path>();
        targetPaths.add(Paths.get("/fantasy/location/target/file", new String[0]));
        targetPaths.add(TestHelper.getResourcePath((String)"SM_OPER_MIR_OSUDP2_20091204T001853_20091204T011255_310_001_1.zip"));
        List existingFiles = NetcdfExportDialog.getExistingPaths(targetPaths);
        Assert.assertNotNull((Object)existingFiles);
        Assert.assertEquals((long)1L, (long)existingFiles.size());
    }

    @Test
    public void testGetExistingFiles_twoExists() {
        ArrayList<Path> targetFiles = new ArrayList<Path>();
        targetFiles.add(TestHelper.getResourcePath((String)"SM_OPER_MIR_BWLF1C_20111026T143206_20111026T152520_503_001_1.zip"));
        targetFiles.add(Paths.get("/fantasy/location/target/file", new String[0]));
        targetFiles.add(TestHelper.getResourcePath((String)"SM_OPER_MIR_OSUDP2_20091204T001853_20091204T011255_310_001_1.zip"));
        List existingFiles = NetcdfExportDialog.getExistingPaths(targetFiles);
        Assert.assertNotNull((Object)existingFiles);
        Assert.assertEquals((long)2L, (long)existingFiles.size());
    }

    @Test
    public void testListToString() {
        Path file_1 = TestHelper.getResourcePath((String)"SM_OPER_MIR_BWLF1C_20111026T143206_20111026T152520_503_001_1.zip");
        Path file_2 = TestHelper.getResourcePath((String)"SM_OPER_MIR_OSUDP2_20091204T001853_20091204T011255_310_001_1.zip");
        ArrayList<Path> targetFiles = new ArrayList<Path>();
        targetFiles.add(file_1);
        targetFiles.add(file_2);
        Assert.assertEquals((Object)(file_1.toAbsolutePath() + "\n" + file_2.toAbsolutePath() + "\n"), (Object)NetcdfExportDialog.listToString(targetFiles));
    }

    @Test
    public void testListToString_ellipseAfterTenFiles() {
        ArrayList<Path> targetFiles = new ArrayList<Path>();
        for (int i = 0; i < 14; ++i) {
            targetFiles.add(Paths.get("blabla_" + i, new String[0]));
        }
        Assert.assertTrue((boolean)NetcdfExportDialog.listToString(targetFiles).contains("..."));
    }
}

