/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.ui;

import java.awt.GraphicsEnvironment;
import org.esa.smos.ee2netcdf.ui.DialogHelper;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DefaultAppContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class DialogHelperTest {
    private final boolean isGuiAvailable = !GraphicsEnvironment.isHeadless();

    @Test
    public void testIsSupportedType() {
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_BWLD1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_BWSD1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_BWLF1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_BWSF1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_SCSF1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_SCLF1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_SCSD1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_SCLD1C"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_SMUDP2"));
        Assert.assertTrue((boolean)DialogHelper.isSupportedType((String)"MIR_OSUDP2"));
        Assert.assertFalse((boolean)DialogHelper.isSupportedType((String)"MPL_XBDOWN"));
        Assert.assertFalse((boolean)DialogHelper.isSupportedType((String)"MIR_SMDAP2"));
        Assert.assertFalse((boolean)DialogHelper.isSupportedType((String)"MIR_CORN0_"));
        Assert.assertFalse((boolean)DialogHelper.isSupportedType((String)"AUX_ECMWF_"));
        Assert.assertFalse((boolean)DialogHelper.isSupportedType((String)"MIR_AFWU1A"));
    }

    @Test
    public void testCanProductSelectionBeEnabled_noProduct() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("test");
        Assert.assertNull((Object)appContext.getSelectedProduct());
        Assert.assertFalse((boolean)DialogHelper.isProductSelectionFeasible((AppContext)appContext));
    }

    @Test
    public void testIsProductSelectionFeasible_wrongProductType() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("test");
        appContext.setSelectedProduct(new Product("test", "MER_RR__1P", 2, 2));
        Assert.assertNotNull((Object)appContext.getSelectedProduct());
        Assert.assertFalse((boolean)DialogHelper.isProductSelectionFeasible((AppContext)appContext));
    }

    @Test
    public void testIsProductSelectionFeasible_validProductType() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("test");
        appContext.setSelectedProduct(new Product("test", "MIR_SCLF1C", 2, 2));
        Assert.assertNotNull((Object)appContext.getSelectedProduct());
        Assert.assertTrue((boolean)DialogHelper.isProductSelectionFeasible((AppContext)appContext));
    }

    @Test
    public void testGetSelectedSmosProduct_noProduct() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("test");
        Assert.assertNull((Object)appContext.getSelectedProduct());
        Assert.assertNull((Object)DialogHelper.getSelectedSmosProduct((AppContext)appContext));
    }

    @Test
    public void testGetSelectedSmosProduct_wrongProductType() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("test");
        appContext.setSelectedProduct(new Product("test", "MER_RR__1P", 2, 2));
        Assert.assertNotNull((Object)appContext.getSelectedProduct());
        Assert.assertNull((Object)DialogHelper.getSelectedSmosProduct((AppContext)appContext));
    }

    @Test
    public void testGetSelectedSmosProduct_validProductType() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("test");
        Product expectedProduct = new Product("test", "MIR_OSUDP2", 2, 2);
        appContext.setSelectedProduct(expectedProduct);
        Assert.assertNotNull((Object)appContext.getSelectedProduct());
        Product selectedProduct = DialogHelper.getSelectedSmosProduct((AppContext)appContext);
        Assert.assertEquals((Object)expectedProduct, (Object)selectedProduct);
    }
}

