/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dgg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.esa.smos.dgg.SmosDgg;
import org.junit.Assert;
import org.junit.Test;

public class SmosDggTest {
    @Test
    public void gridPointIdToSeqnum() {
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToSeqnum((int)1));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToSeqnum((int)2));
        Assert.assertEquals((long)3L, (long)SmosDgg.gridPointIdToSeqnum((int)3));
        Assert.assertEquals((long)262144L, (long)SmosDgg.gridPointIdToSeqnum((int)262144));
        Assert.assertEquals((long)262145L, (long)SmosDgg.gridPointIdToSeqnum((int)262145));
        Assert.assertEquals((long)262146L, (long)SmosDgg.gridPointIdToSeqnum((int)1000001));
        Assert.assertEquals((long)262147L, (long)SmosDgg.gridPointIdToSeqnum((int)1000002));
        Assert.assertEquals((long)524288L, (long)SmosDgg.gridPointIdToSeqnum((int)1262143));
        Assert.assertEquals((long)524289L, (long)SmosDgg.gridPointIdToSeqnum((int)1262144));
        Assert.assertEquals((long)524290L, (long)SmosDgg.gridPointIdToSeqnum((int)2000001));
        Assert.assertEquals((long)524291L, (long)SmosDgg.gridPointIdToSeqnum((int)2000002));
        Assert.assertEquals((long)0x240000L, (long)SmosDgg.gridPointIdToSeqnum((int)8262143));
        Assert.assertEquals((long)2359297L, (long)SmosDgg.gridPointIdToSeqnum((int)8262144));
        Assert.assertEquals((long)0x240002L, (long)SmosDgg.gridPointIdToSeqnum((int)9000001));
        Assert.assertEquals((long)2359299L, (long)SmosDgg.gridPointIdToSeqnum((int)9000002));
        Assert.assertEquals((long)2621441L, (long)SmosDgg.gridPointIdToSeqnum((int)9262144));
        Assert.assertEquals((long)0x280002L, (long)SmosDgg.gridPointIdToSeqnum((int)9262145));
    }

    @Test
    public void gridPointIdToSeqnumInZone() {
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)1));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)2));
        Assert.assertEquals((long)3L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)3));
        Assert.assertEquals((long)262144L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)262144));
        Assert.assertEquals((long)262145L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)262145));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)1000001));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)1000002));
        Assert.assertEquals((long)262143L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)1262143));
        Assert.assertEquals((long)262144L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)1262144));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)2000001));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)2000002));
        Assert.assertEquals((long)262143L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)8262143));
        Assert.assertEquals((long)262144L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)8262144));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)9000001));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)9000002));
        Assert.assertEquals((long)262144L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)9262144));
        Assert.assertEquals((long)262145L, (long)SmosDgg.gridPointIdToSeqnumInZone((int)9262145));
    }

    @Test
    public void gridPointIdToZoneId() {
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToZoneId((int)1));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToZoneId((int)2));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToZoneId((int)3));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToZoneId((int)262144));
        Assert.assertEquals((long)1L, (long)SmosDgg.gridPointIdToZoneId((int)262145));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToZoneId((int)1000001));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToZoneId((int)1000002));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToZoneId((int)1262143));
        Assert.assertEquals((long)2L, (long)SmosDgg.gridPointIdToZoneId((int)1262144));
        Assert.assertEquals((long)3L, (long)SmosDgg.gridPointIdToZoneId((int)2000001));
        Assert.assertEquals((long)3L, (long)SmosDgg.gridPointIdToZoneId((int)2000002));
        Assert.assertEquals((long)9L, (long)SmosDgg.gridPointIdToZoneId((int)8262143));
        Assert.assertEquals((long)9L, (long)SmosDgg.gridPointIdToZoneId((int)8262144));
        Assert.assertEquals((long)10L, (long)SmosDgg.gridPointIdToZoneId((int)9000001));
        Assert.assertEquals((long)10L, (long)SmosDgg.gridPointIdToZoneId((int)9000002));
        Assert.assertEquals((long)10L, (long)SmosDgg.gridPointIdToZoneId((int)9262144));
        Assert.assertEquals((long)10L, (long)SmosDgg.gridPointIdToZoneId((int)9262145));
    }

    @Test
    public void seqnumToGridPointId() {
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToGridPointId((int)1));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToGridPointId((int)2));
        Assert.assertEquals((long)3L, (long)SmosDgg.seqnumToGridPointId((int)3));
        Assert.assertEquals((long)262144L, (long)SmosDgg.seqnumToGridPointId((int)262144));
        Assert.assertEquals((long)262145L, (long)SmosDgg.seqnumToGridPointId((int)262145));
        Assert.assertEquals((long)1000001L, (long)SmosDgg.seqnumToGridPointId((int)262146));
        Assert.assertEquals((long)1000002L, (long)SmosDgg.seqnumToGridPointId((int)262147));
        Assert.assertEquals((long)1262143L, (long)SmosDgg.seqnumToGridPointId((int)524288));
        Assert.assertEquals((long)1262144L, (long)SmosDgg.seqnumToGridPointId((int)524289));
        Assert.assertEquals((long)2000001L, (long)SmosDgg.seqnumToGridPointId((int)524290));
        Assert.assertEquals((long)2000002L, (long)SmosDgg.seqnumToGridPointId((int)524291));
        Assert.assertEquals((long)8262143L, (long)SmosDgg.seqnumToGridPointId((int)0x240000));
        Assert.assertEquals((long)8262144L, (long)SmosDgg.seqnumToGridPointId((int)2359297));
        Assert.assertEquals((long)9000001L, (long)SmosDgg.seqnumToGridPointId((int)0x240002));
        Assert.assertEquals((long)9000002L, (long)SmosDgg.seqnumToGridPointId((int)2359299));
        Assert.assertEquals((long)9262144L, (long)SmosDgg.seqnumToGridPointId((int)2621441));
        Assert.assertEquals((long)9262145L, (long)SmosDgg.seqnumToGridPointId((int)0x280002));
    }

    @Test
    public void seqnumToSeqnumInZone() {
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToSeqnumInZone((int)1));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToSeqnumInZone((int)2));
        Assert.assertEquals((long)3L, (long)SmosDgg.seqnumToSeqnumInZone((int)3));
        Assert.assertEquals((long)262144L, (long)SmosDgg.seqnumToSeqnumInZone((int)262144));
        Assert.assertEquals((long)262145L, (long)SmosDgg.seqnumToSeqnumInZone((int)262145));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToSeqnumInZone((int)262146));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToSeqnumInZone((int)262147));
        Assert.assertEquals((long)262143L, (long)SmosDgg.seqnumToSeqnumInZone((int)524288));
        Assert.assertEquals((long)262144L, (long)SmosDgg.seqnumToSeqnumInZone((int)524289));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToSeqnumInZone((int)524290));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToSeqnumInZone((int)524291));
        Assert.assertEquals((long)262143L, (long)SmosDgg.seqnumToSeqnumInZone((int)0x240000));
        Assert.assertEquals((long)262144L, (long)SmosDgg.seqnumToSeqnumInZone((int)2359297));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToSeqnumInZone((int)0x240002));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToSeqnumInZone((int)2359299));
        Assert.assertEquals((long)262144L, (long)SmosDgg.seqnumToSeqnumInZone((int)2621441));
        Assert.assertEquals((long)262145L, (long)SmosDgg.seqnumToSeqnumInZone((int)0x280002));
    }

    @Test
    public void seqnumToZoneId() {
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToZoneId((int)1));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToZoneId((int)2));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToZoneId((int)3));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToZoneId((int)262144));
        Assert.assertEquals((long)1L, (long)SmosDgg.seqnumToZoneId((int)262145));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToZoneId((int)262146));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToZoneId((int)262147));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToZoneId((int)524288));
        Assert.assertEquals((long)2L, (long)SmosDgg.seqnumToZoneId((int)524289));
        Assert.assertEquals((long)3L, (long)SmosDgg.seqnumToZoneId((int)524290));
        Assert.assertEquals((long)3L, (long)SmosDgg.seqnumToZoneId((int)524291));
        Assert.assertEquals((long)9L, (long)SmosDgg.seqnumToZoneId((int)0x240000));
        Assert.assertEquals((long)9L, (long)SmosDgg.seqnumToZoneId((int)2359297));
        Assert.assertEquals((long)10L, (long)SmosDgg.seqnumToZoneId((int)0x240002));
        Assert.assertEquals((long)10L, (long)SmosDgg.seqnumToZoneId((int)2359299));
        Assert.assertEquals((long)10L, (long)SmosDgg.seqnumToZoneId((int)2621441));
        Assert.assertEquals((long)10L, (long)SmosDgg.seqnumToZoneId((int)0x280002));
    }

    @Test
    public void testImageToModelTransform() throws Exception {
        AffineTransform t = SmosDgg.getInstance().getMultiLevelImage().getModel().getImageToModelTransform(0);
        Point2D.Double i = new Point2D.Double(0.0, 0.0);
        Point2D.Double m = new Point2D.Double();
        t.transform(i, m);
        Assert.assertEquals((double)-180.0, (double)((Point2D)m).getX(), (double)0.0);
        Assert.assertEquals((double)88.59375, (double)((Point2D)m).getY(), (double)0.0);
    }

    @Test
    public void testGetSeqnum() throws Exception {
        Assert.assertEquals((long)-1L, (long)SmosDgg.getInstance().getSeqnum(0.0, 90.0));
        Assert.assertEquals((long)-1L, (long)SmosDgg.getInstance().getSeqnum(0.0, -90.0));
        Assert.assertEquals((long)609961L, (long)SmosDgg.getInstance().getSeqnum(0.0, 0.0));
    }
}

