/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.smos.dgg;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.CropDescriptor;
import org.esa.beam.jai.TiledFileOpImage;

public class SmosDggTilizer {
    public static void main(String[] args) throws IOException {
        new SmosDggTilizer().doIt(new File(args[0]), new File(args[1]));
    }

    private void doIt(File inputLevel0Dir, File outputDir) throws IOException {
        if (!outputDir.exists() && !outputDir.mkdir()) {
            throw new IOException("Failed to create directory: " + outputDir.getAbsolutePath());
        }
        TiledFileOpImage opImage = TiledFileOpImage.create((File)inputLevel0Dir, null);
        opImage = CropDescriptor.create((RenderedImage)opImage, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(64.0f), (Float)Float.valueOf(16384.0f), (Float)Float.valueOf(8064.0f), null);
        int dataType = opImage.getSampleModel().getDataType();
        int tileWidth = 512;
        int tileHeight = 504;
        int levelCount = 7;
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(7, new AffineTransform(), opImage.getWidth(), opImage.getHeight());
        DefaultMultiLevelSource multiLevelSource = new DefaultMultiLevelSource((RenderedImage)opImage, (MultiLevelModel)model);
        for (int level = 0; level < 7; ++level) {
            File outputLevelDir;
            int numYTiles;
            int numXTiles;
            PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)multiLevelSource.getImage(level));
            int width = image.getWidth();
            int height = image.getHeight();
            while (true) {
                numXTiles = width / tileWidth;
                numYTiles = height / tileHeight;
                if (numXTiles * tileWidth == width && numYTiles * tileHeight == image.getHeight()) break;
                if (numXTiles * tileWidth < width) {
                    tileWidth /= 2;
                }
                if (numYTiles * tileHeight >= height) continue;
                tileHeight /= 2;
            }
            if (numXTiles == 0 || numYTiles == 0) {
                throw new IllegalStateException("numXTiles == 0 || numYTiles == 0");
            }
            if (tileWidth < 512 && tileHeight < 504) {
                tileWidth = width;
                tileHeight = height;
                numYTiles = 1;
                numXTiles = 1;
            }
            if (!(outputLevelDir = new File(outputDir, "" + level)).exists() && !outputLevelDir.mkdir()) {
                throw new IOException("Failed to create directory: " + outputLevelDir.getAbsolutePath());
            }
            File imagePropertiesFile = new File(outputLevelDir, "image.properties");
            System.out.println("Writing " + imagePropertiesFile + "...");
            PrintWriter printWriter = new PrintWriter(new FileWriter(imagePropertiesFile));
            this.writeImageProperties(level, dataType, width, height, tileWidth, tileHeight, numXTiles, numYTiles, new PrintWriter(System.out));
            this.writeImageProperties(level, dataType, width, height, tileWidth, tileHeight, numXTiles, numYTiles, printWriter);
            System.out.flush();
            printWriter.close();
            this.writeTiles(outputLevelDir, image, tileWidth, tileHeight, numXTiles, numYTiles);
        }
    }

    private void writeTiles(File levelDir, PlanarImage image, int tileWidth, int tileHeight, int numXTiles, int numYTiles) throws IOException {
        for (int tileY = 0; tileY < numYTiles; ++tileY) {
            for (int tileX = 0; tileX < numXTiles; ++tileX) {
                int x = tileX * tileWidth;
                int y = tileY * tileHeight + image.getMinY();
                Raster raster = image.getData(new Rectangle(x, y, tileWidth, tileHeight));
                int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
                if (data.length != tileWidth * tileHeight) {
                    data = new int[tileWidth * tileHeight];
                    raster.getDataElements(x, y, tileWidth, tileHeight, data);
                }
                this.writeData(levelDir, tileX, tileY, data);
            }
        }
    }

    private void writeImageProperties(int level, int dataType, int width, int height, int tileWidth, int tileHeight, int numXTiles, int numYTiles, PrintWriter printWriter) {
        printWriter.println("level      = " + level);
        printWriter.println("dataType   = " + dataType);
        printWriter.println("width      = " + width);
        printWriter.println("height     = " + height);
        printWriter.println("tileWidth  = " + tileWidth);
        printWriter.println("tileHeight = " + tileHeight);
        printWriter.println("numXTiles  = " + numXTiles);
        printWriter.println("numYTiles  = " + numYTiles);
    }

    private void writeData(File levelDir, int tileX, int tileY, int[] data) throws IOException {
        String baseName = tileX + "-" + tileY + ".raw";
        File file = new File(levelDir, baseName + ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.putNextEntry(new ZipEntry(baseName));
        MemoryCacheImageOutputStream imageOutputStream = new MemoryCacheImageOutputStream(zipOutputStream);
        imageOutputStream.writeInts(data, 0, data.length);
        imageOutputStream.flush();
        zipOutputStream.closeEntry();
        zipOutputStream.close();
    }
}

