/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.smos.dgg;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import org.esa.beam.glevel.TiledFileMultiLevelSource;

public class SmosDgg {
    private static final String SMOS_DGG_DIR_PROPERTY_NAME = "org.esa.beam.smos.dggDir";
    private static final int A = 1000000;
    private static final int B = 262144;
    private static final int C = 262145;
    private static final int D = 737856;
    private static final int MAX_SEQNUM = 0x280002;
    private static final int MAX_ZONE_ID = 10;
    public static final int MIN_GRID_POINT_ID = 1;
    public static final int MAX_GRID_POINT_ID = 9262145;
    private volatile MultiLevelImage dggMultiLevelImage;

    public static SmosDgg getInstance() {
        return Holder.instance;
    }

    public static int gridPointIdToSeqnum(int gridPointId) {
        return gridPointId < 1000000 ? gridPointId : gridPointId - 737856 * ((gridPointId - 1) / 1000000) + 1;
    }

    static int gridPointIdToSeqnumInZone(int gridPointId) {
        return gridPointId % 1000000;
    }

    static int gridPointIdToZoneId(int gridPointId) {
        return gridPointId / 1000000 + 1;
    }

    static int seqnumToGridPointId(int seqnum) {
        return seqnum <= 262145 ? seqnum : (seqnum == 0x280002 ? 9262145 : seqnum - 1 + (seqnum - 2) / 262144 * 737856);
    }

    public static int seqnumToSeqnumInZone(int seqnum) {
        return seqnum <= 262145 ? seqnum : (seqnum == 0x280002 ? 262145 : (seqnum - 2) % 262144 + 1);
    }

    public static int seqnumToZoneId(int seqnum) {
        return seqnum <= 262145 ? 1 : (seqnum == 0x280002 ? 10 : (seqnum - 2) / 262144 + 1);
    }

    public AffineTransform getImageToMapTransform() {
        return this.getMultiLevelImage().getModel().getImageToModelTransform(0);
    }

    public MultiLevelImage getMultiLevelImage() {
        return this.dggMultiLevelImage;
    }

    private SmosDgg() {
        try {
            String dirPath = SmosDgg.getDirPathFromProperty();
            if (dirPath == null) {
                dirPath = SmosDgg.getDirPathFromModule();
            }
            File dir = new File(dirPath);
            TiledFileMultiLevelSource dggMultiLevelSource = TiledFileMultiLevelSource.create((File)dir);
            this.dggMultiLevelImage = new DefaultMultiLevelImage((MultiLevelSource)dggMultiLevelSource);
        }
        catch (Exception e) {
            throw new IllegalStateException(MessageFormat.format("Cannot create SMOS DDG multi-level image: {0}", e.getMessage()), e);
        }
    }

    private static String getDirPathFromModule() throws URISyntaxException {
        URL url = SmosDgg.class.getResource("image.properties");
        URI uri = url.toURI();
        return new File(uri).getParent();
    }

    private static String getDirPathFromProperty() throws IOException {
        File dir;
        String dirPath = System.getProperty(SMOS_DGG_DIR_PROPERTY_NAME);
        if (dirPath != null && !(dir = new File(dirPath)).canRead()) {
            throw new IOException(MessageFormat.format("Cannot read directory ''{0}''. System property ''{0}'' must point to a readable directory.", dir.getPath(), SMOS_DGG_DIR_PROPERTY_NAME));
        }
        return dirPath;
    }

    private static class Holder {
        private static final SmosDgg instance = new SmosDgg();

        private Holder() {
        }
    }
}

