/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.spot;

import com.bc.ceres.binding.Property;
import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import org.esa.s3tbx.dataio.spot.LogVolDescriptor;
import org.esa.s3tbx.dataio.spot.PhysVolDescriptor;
import org.esa.s3tbx.dataio.spot.SpotVgtConstants;
import org.esa.s3tbx.dataio.spot.SpotVgtProductReaderPlugIn;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class SpotVgtProductReader
extends AbstractProductReader {
    private static final String BAND_INFO_PROPERTIES = "band-info.properties";
    private HashMap<Band, FileVar> fileVars;
    private VirtualDir virtualDir;
    private Properties bandInfos;
    private static final String[] PIXEL_DATA_VAR_NAMES = new String[]{"PIXEL_DATA", "PIXEL DATA", "ANGLES_VALUES", "ANGLES VALUES", "MEASURE_VALUE", "MEASURE VALUE"};

    SpotVgtProductReader(SpotVgtProductReaderPlugIn productReaderPlugIn) {
        super((ProductReaderPlugIn)productReaderPlugIn);
        this.initBandInfos();
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = SpotVgtProductReaderPlugIn.getFileInput(this.getInput());
        this.virtualDir = VirtualDir.create((File)inputFile);
        return this.createProduct();
    }

    private Product createProduct() throws IOException {
        String[] logVolFileNames;
        PhysVolDescriptor physVolDescriptor = new PhysVolDescriptor(this.virtualDir.getReader("PHYS_VOL.TXT"));
        LogVolDescriptor logVolDescriptor = new LogVolDescriptor(this.virtualDir.getReader(physVolDescriptor.getLogVolDescriptorFileName()));
        Rectangle imageBounds = logVolDescriptor.getImageBounds();
        this.fileVars = new HashMap(33);
        int targetWidth = imageBounds.width;
        int targetHeight = imageBounds.height;
        Product product = new Product(logVolDescriptor.getProductId(), physVolDescriptor.getFormatReference(), targetWidth, targetHeight, (ProductReader)this);
        Dimension tileSize = JAIUtils.computePreferredTileSize((int)targetWidth, (int)targetHeight, (int)1);
        product.setPreferredTileSize(tileSize);
        product.setFileLocation(new File(this.virtualDir.getBasePath()));
        this.addGeoCoding(product, logVolDescriptor);
        this.addTimeCoding(product, logVolDescriptor);
        this.addMetadata(product, physVolDescriptor, logVolDescriptor);
        for (String logVolFileName : logVolFileNames = this.virtualDir.list(physVolDescriptor.getLogVolDirName())) {
            String bandName;
            BandInfo bandInfo;
            DataType netCdfDataType;
            int bandDataType;
            if (!logVolFileName.endsWith(".hdf") && !logVolFileName.endsWith(".HDF")) continue;
            File hdfFile = this.virtualDir.getFile(physVolDescriptor.getLogVolDirName() + "/" + logVolFileName);
            NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)hdfFile.getPath());
            if (netcdfFile == null) {
                throw new IOException("Failed to open file " + hdfFile.getPath());
            }
            Variable variable = this.findPixelDataVariable(netcdfFile);
            if (!this.isPotentialPixelDataVariable(variable) || (bandDataType = this.convertNetcdfTypeToProductDataType(netCdfDataType = variable.getDataType(), variable.isUnsigned())) == 0 || (bandInfo = this.getBandInfo(bandName = SpotVgtProductReaderPlugIn.getBandName(logVolFileName))) == null) continue;
            int sourceWidth = variable.getDimension(1).getLength();
            int sourceHeight = variable.getDimension(0).getLength();
            int sampling = bandInfo.pSampling;
            if (sampling == 1 || sourceWidth == targetWidth || sourceHeight == targetHeight) {
                this.addBand(product, bandDataType, bandInfo, netcdfFile, variable);
                continue;
            }
            if (sampling <= 1 && sourceWidth > targetWidth && sourceHeight > targetHeight) continue;
            try {
                ProductData data = SpotVgtProductReader.readData(variable, bandDataType, sourceWidth, sourceHeight);
                RenderedOp dstImg = SpotVgtProductReader.createScaledImage(targetWidth, targetHeight, sourceWidth, sourceHeight, sampling, data, tileSize);
                Band band = this.addBand(product, bandDataType, bandInfo, netcdfFile, variable);
                band.setSourceImage((RenderedImage)dstImg);
            }
            catch (IOException iOException) {
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
        this.addFlagsAndMasks(product);
        this.addSpectralInfo(product);
        return product;
    }

    private int convertNetcdfTypeToProductDataType(DataType netCdfDataType, boolean unsigned) {
        if (netCdfDataType == DataType.BYTE) {
            return unsigned ? 20 : 10;
        }
        if (netCdfDataType == DataType.SHORT) {
            return unsigned ? 21 : 11;
        }
        if (netCdfDataType == DataType.INT) {
            return unsigned ? 22 : 12;
        }
        if (netCdfDataType == DataType.FLOAT) {
            return 30;
        }
        if (netCdfDataType == DataType.DOUBLE) {
            return 31;
        }
        return 0;
    }

    private boolean isPotentialPixelDataVariable(Variable variable) {
        return variable != null && variable.getRank() == 2 && variable.getDataType().isNumeric();
    }

    private static ProductData readData(Variable variable, int bandDataType, int rasterWidth, int rasterHeight) throws IOException, InvalidRangeException {
        ProductData data = ProductData.createInstance((int)bandDataType, (int)(rasterWidth * rasterHeight));
        SpotVgtProductReader.read(variable, 0, 0, rasterWidth, rasterHeight, data);
        return data;
    }

    private static RenderedOp createScaledImage(int targetWidth, int targetHeight, int sourceWidth, int sourceHeight, int sourceSampling, ProductData data, Dimension tileSize) {
        int tempW = sourceWidth * sourceSampling + 1;
        int tempH = sourceHeight * sourceSampling + 1;
        float xScale = (float)tempW / (float)sourceWidth;
        float yScale = (float)tempH / (float)sourceHeight;
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        RenderedImage srcImg = ImageUtils.createRenderedImage((int)sourceWidth, (int)sourceHeight, (ProductData)data);
        ImageLayout imageLayout = new ImageLayout(0, 0, targetWidth, targetHeight, 0, 0, tileSize.width, tileSize.height, null, null);
        renderingHints.put(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        RenderedOp tempImg = ScaleDescriptor.create((RenderedImage)srcImg, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(-0.5f * (float)sourceSampling + 1.0f), (Float)Float.valueOf(-0.5f * (float)sourceSampling + 1.0f), (Interpolation)Interpolation.getInstance((int)1), (RenderingHints)renderingHints);
        return CropDescriptor.create((RenderedImage)tempImg, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(targetWidth), (Float)Float.valueOf(targetHeight), null);
    }

    private Band addBand(Product product, int bandDataType, BandInfo bandInfo, NetcdfFile netcdfFile, Variable variable) {
        Band band = product.addBand(bandInfo.name, bandDataType);
        if (!Boolean.getBoolean("s3tbx.spotvgt.donotapplysolarilluminationfactor") && product.getName().matches("V.KRNP.*") && ("B0".equals(bandInfo.name) || "B2".equals(bandInfo.name) || "B3".equals(bandInfo.name) || "MIR".equals(bandInfo.name))) {
            int doy = product.getStartTime().getAsCalendar().get(6);
            band.setScalingFactor(bandInfo.coefA * SpotVgtConstants.SOLAR_ILLUMINATION_FACTOR[doy - 1]);
        } else {
            band.setScalingFactor(bandInfo.coefA);
        }
        band.setScalingOffset(bandInfo.offsetB);
        band.setUnit(bandInfo.unit);
        band.setDescription(bandInfo.description);
        this.fileVars.put(band, new FileVar(netcdfFile, variable));
        return band;
    }

    private Variable findPixelDataVariable(NetcdfFile netcdfFile) {
        for (String name : PIXEL_DATA_VAR_NAMES) {
            Variable pixelDataVar = netcdfFile.getRootGroup().findVariable(name);
            if (pixelDataVar == null) continue;
            return pixelDataVar;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        Variable variable;
        Assert.state((sourceOffsetX == targetOffsetX ? 1 : 0) != 0, (String)"sourceOffsetX != targetOffsetX");
        Assert.state((sourceOffsetY == targetOffsetY ? 1 : 0) != 0, (String)"sourceOffsetY != targetOffsetY");
        Assert.state((sourceStepX == 1 ? 1 : 0) != 0, (String)"sourceStepX != 1");
        Assert.state((sourceStepY == 1 ? 1 : 0) != 0, (String)"sourceStepY != 1");
        Assert.state((sourceWidth == targetWidth ? 1 : 0) != 0, (String)"sourceWidth != targetWidth");
        Assert.state((sourceHeight == targetHeight ? 1 : 0) != 0, (String)"sourceHeight != targetHeight");
        FileVar fileVar = this.fileVars.get(targetBand);
        if (fileVar == null) {
            return;
        }
        Variable variable2 = variable = fileVar.var;
        synchronized (variable2) {
            try {
                SpotVgtProductReader.read(variable, targetOffsetX, targetOffsetY, targetWidth, targetHeight, targetBuffer);
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
    }

    private static void read(Variable variable, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer) throws IOException, InvalidRangeException {
        Array array = variable.read(new int[]{targetOffsetY, targetOffsetX}, new int[]{targetHeight, targetWidth});
        System.arraycopy(array.getStorage(), 0, targetBuffer.getElems(), 0, targetWidth * targetHeight);
    }

    public void close() throws IOException {
        for (Map.Entry<Band, FileVar> entry : this.fileVars.entrySet()) {
            NetcdfFile netcdfFile = entry.getValue().file;
            try {
                netcdfFile.close();
            }
            catch (IOException iOException) {}
        }
        this.fileVars.clear();
        this.virtualDir.close();
        super.close();
    }

    private void addGeoCoding(Product product, LogVolDescriptor logVolDescriptor) {
        GeoCoding geoCoding = logVolDescriptor.getGeoCoding();
        if (geoCoding != null) {
            product.setSceneGeoCoding(geoCoding);
        }
    }

    private void addMetadata(Product product, PhysVolDescriptor physVolDescriptor, LogVolDescriptor logVolDescriptor) {
        product.getMetadataRoot().addElement(this.createMetadataElement("PHYS_VOL", "Physical volume descriptor", physVolDescriptor.getPropertySet().getProperties()));
        product.getMetadataRoot().addElement(this.createMetadataElement("LOG_VOL", "Logical volume descriptor", logVolDescriptor.getPropertySet().getProperties()));
    }

    private void addFlagsAndMasks(Product product) {
        Band smBand = product.getBand("SM");
        if (smBand != null) {
            Band[] bands;
            FlagCoding flagCoding = new FlagCoding("SM");
            flagCoding.addFlag("B0_GOOD", 128, "Radiometric quality for band B0 is good.");
            flagCoding.addFlag("B2_GOOD", 64, "Radiometric quality for band B2 is good.");
            flagCoding.addFlag("B3_GOOD", 32, "Radiometric quality for band B3 is good.");
            flagCoding.addFlag("MIR_GOOD", 16, "Radiometric quality for band MIR is good.");
            flagCoding.addFlag("LAND", 8, "Land code 1 or water code 0.");
            flagCoding.addFlag("ICE_SNOW", 4, "Ice/snow code 1, code 0 if there is no ice/snow");
            flagCoding.addFlag("CLOUD_2", 2, "");
            flagCoding.addFlag("CLOUD_1", 1, "");
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            smBand.setSampleCoding((SampleCoding)flagCoding);
            for (Band band : bands = product.getBands()) {
                if (band == smBand) continue;
                if (this.isSpectralBand(band)) {
                    band.setValidPixelExpression("SM." + band.getName() + "_GOOD");
                    continue;
                }
                if (this.isSubsampledBand(band)) continue;
                band.setValidPixelExpression("SM.LAND");
            }
            product.addMask("B0_BAD", "!SM.B0_GOOD", "Radiometric quality for band B0 is bad.", Color.RED, 0.2);
            product.addMask("B2_BAD", "!SM.B2_GOOD", "Radiometric quality for band B2 is bad.", Color.RED, 0.2);
            product.addMask("B3_BAD", "!SM.B3_GOOD", "Radiometric quality for band B3 is bad.", Color.RED, 0.2);
            product.addMask("MIR_BAD", "!SM.MIR_GOOD", "Radiometric quality for band MIR is bad.", Color.RED, 0.2);
            product.addMask("LAND", "SM.LAND", "Land mask.", Color.GREEN, 0.5);
            product.addMask("WATER", "!SM.LAND", "Water mask.", Color.BLUE, 0.5);
            product.addMask("ICE_SNOW", "SM.ICE_SNOW", "Ice/snow mask.", Color.MAGENTA, 0.5);
            product.addMask("CLEAR", "!SM.CLOUD_1 && !SM.CLOUD_2", "Clear sky.", Color.ORANGE, 0.5);
            product.addMask("CLOUD_SHADOW", "SM.CLOUD_1 && !SM.CLOUD_2", "Cloud shadow.", Color.CYAN, 0.5);
            product.addMask("CLOUD_UNCERTAIN", "!SM.CLOUD_1 && SM.CLOUD_2", "Cloud uncertain.", Color.ORANGE, 0.5);
            product.addMask("CLOUD", "SM.CLOUD_1 && SM.CLOUD_2", "Cloud certain.", Color.YELLOW, 0.5);
        }
    }

    private boolean isSubsampledBand(Band band) {
        return band.isSourceImageSet();
    }

    private boolean isSpectralBand(Band band) {
        return band.getName().equals("B0") || band.getName().equals("B2") || band.getName().equals("B3") || band.getName().equals("MIR");
    }

    private void addSpectralInfo(Product product) {
        this.addSpectralInfo(product, "B0", 0, 430.0f, 470.0f, 1963.4f);
        this.addSpectralInfo(product, "B2", 1, 610.0f, 680.0f, 1570.3f);
        this.addSpectralInfo(product, "B3", 2, 780.0f, 890.0f, 1045.6f);
        this.addSpectralInfo(product, "MIR", 3, 1580.0f, 1750.0f, 234.7f);
    }

    private void addSpectralInfo(Product product, String name, int index, float min, float max, float solFlux) {
        Band spectralBand = product.getBand(name);
        if (spectralBand != null) {
            spectralBand.setSpectralBandIndex(index);
            spectralBand.setSpectralWavelength(min + 0.5f * (max - min));
            spectralBand.setSpectralBandwidth(max - min);
            spectralBand.setSolarFlux(solFlux);
            spectralBand.setDescription(MessageFormat.format("{0} spectral band", name));
        }
    }

    private MetadataElement createMetadataElement(String name, String description, Property[] properties) {
        MetadataElement element = new MetadataElement(name);
        element.setDescription(description);
        for (Property property : properties) {
            element.addAttribute(new MetadataAttribute(property.getName(), ProductData.createInstance((String)property.getValueAsText()), true));
        }
        return element;
    }

    private void addTimeCoding(Product product, LogVolDescriptor logVolDescriptor) {
        Date endDate;
        Date startDate = logVolDescriptor.getStartDate();
        if (startDate != null) {
            product.setStartTime(ProductData.UTC.create((Date)startDate, (long)0L));
        }
        if ((endDate = logVolDescriptor.getEndDate()) != null) {
            product.setEndTime(ProductData.UTC.create((Date)endDate, (long)0L));
        }
    }

    private void initBandInfos() {
        this.bandInfos = new Properties();
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(BAND_INFO_PROPERTIES);
            this.bandInfos.load(stream);
            stream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(MessageFormat.format("Failed to load resource {0}: {1}", BAND_INFO_PROPERTIES, e.getMessage()), e);
        }
    }

    BandInfo getBandInfo(String name) {
        String coefA = this.bandInfos.getProperty(name + ".COEF_A");
        String offsetB = this.bandInfos.getProperty(name + ".OFFSET_B");
        String sampling = this.bandInfos.getProperty(name + ".SAMPLING");
        String unit = this.bandInfos.getProperty(name + ".UNIT");
        String description = this.bandInfos.getProperty(name + ".DESCRIPTION");
        if (coefA != null || offsetB != null || unit != null || description != null || sampling != null) {
            try {
                return new BandInfo(name, coefA != null ? Double.parseDouble(coefA) : 1.0, offsetB != null ? Double.parseDouble(offsetB) : 0.0, sampling != null ? Integer.parseInt(sampling) : 1, unit, description);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class FileVar {
        final NetcdfFile file;
        final Variable var;

        private FileVar(NetcdfFile file, Variable var) {
            this.file = file;
            this.var = var;
        }
    }

    private static class BandInfo {
        private final String name;
        private final double coefA;
        private final double offsetB;
        private final int pSampling;
        private final String unit;
        private final String description;

        private BandInfo(String name, double coefA, double offsetB, int pSampling, String unit, String description) {
            this.name = name;
            this.coefA = coefA;
            this.offsetB = offsetB;
            this.pSampling = pSampling;
            this.unit = unit;
            this.description = description;
        }
    }
}

