/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class InputParameters {
    public int firstForwardPixel;
    public int firstNadirPixel;
    public String FOVMeasurementDataBandName;
    public double[] alongTrackAngle = new double[961];
    public double[] acrossTrackAngle = new double[961];
    public double[] ifov1D = new double[961];
    public double pixelIFOVReportingExtent;
    public boolean cornerReferenceFlag;
    public boolean topographicFlag;
    public double topographyHomogenity;

    void parseCharacterisationFile(String L1BCharacterisationFileLocation) {
        try {
            File binaryFile = new File(L1BCharacterisationFileLocation);
            if (!binaryFile.exists()) {
                throw new RuntimeException();
            }
            try (FileInputStream input = new FileInputStream(binaryFile);){
                byte[] data = new byte[1800];
                try {
                    int read = input.read(data, 0, 1800);
                    if (read <= 0) {
                        throw new RuntimeException();
                    }
                }
                catch (IOException | RuntimeException ex) {
                    System.out.println(ex.getMessage());
                }
                byte[] nadirPixelNumber = new byte[]{data[1753], data[1754], data[1755], data[1756]};
                byte[] forwardPixelNumber = new byte[]{data[1757], data[1758], data[1759], data[1760]};
                boolean littleEndianFlag = false;
                if (L1BCharacterisationFileLocation.contains("AT1") || L1BCharacterisationFileLocation.contains("AT2")) {
                    littleEndianFlag = true;
                }
                this.firstNadirPixel = InputParameters.byteArrayToInt(nadirPixelNumber, littleEndianFlag);
                this.firstForwardPixel = InputParameters.byteArrayToInt(forwardPixelNumber, littleEndianFlag);
                System.out.println("First Nadir Pixel is: " + this.firstNadirPixel + " and First Forward Pixel is: " + this.firstForwardPixel);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static int byteArrayToInt(byte[] b, boolean littleEndianFlag) {
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.order(ByteOrder.BIG_ENDIAN);
        if (littleEndianFlag) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        return bb.getInt();
    }

    void parseRawIFOV(String FOVMeasurementFileLocation) {
        try {
            int j;
            int i;
            int j2;
            String line;
            List lines = new ArrayList<String>();
            FileReader fileReader = new FileReader(FOVMeasurementFileLocation);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            bufferedReader.close();
            String[] values = ((String)lines.get(0)).split(" ");
            int xstart = Integer.parseInt(values[0]);
            int ystart = Integer.parseInt(values[1]);
            int xstop = Integer.parseInt(values[2]);
            int ystop = Integer.parseInt(values[3]);
            int xstep = Integer.parseInt(values[4]);
            int ystep = Integer.parseInt(values[5]);
            int channelNumber = Integer.parseInt(values[6]);
            switch (channelNumber) {
                case 0: {
                    this.FOVMeasurementDataBandName = "12um";
                    break;
                }
                case 1: {
                    this.FOVMeasurementDataBandName = "11um";
                    break;
                }
                case 2: {
                    this.FOVMeasurementDataBandName = "3.7um";
                    break;
                }
                case 3: {
                    this.FOVMeasurementDataBandName = "1.6um";
                    break;
                }
                case 4: {
                    this.FOVMeasurementDataBandName = "0.87um";
                    break;
                }
                case 5: {
                    this.FOVMeasurementDataBandName = "0.66um";
                    break;
                }
                case 6: {
                    this.FOVMeasurementDataBandName = "0.56um";
                    break;
                }
                default: {
                    System.out.println("Unable to read channel name from data");
                    System.exit(1);
                }
            }
            System.out.println("Raw FOV data ingested is for channel: " + this.FOVMeasurementDataBandName);
            int countX = Math.abs(xstop - xstart) / xstep;
            int countY = Math.abs(ystop - ystart) / ystep;
            double[] fovArrayX = new double[(countX + 1) * (countY + 1)];
            double[] fovArrayY = new double[(countX + 1) * (countY + 1)];
            double[] ifov = new double[(countX + 1) * (countY + 1)];
            for (int i2 = 0; i2 < countX + 1; ++i2) {
                for (int j3 = 0; j3 < countY + 1; ++j3) {
                    fovArrayX[i2 + j3 * (countX + 1)] = -2.0 * (double)(xstart + i2 * xstep) / 1000.0;
                    fovArrayY[i2 + j3 * (countX + 1)] = -1.398 * (double)(ystart + j3 * ystep) / 1000.0;
                }
            }
            lines = lines.subList(countX + 4, lines.size());
            for (j2 = 0; j2 < countY + 1; ++j2) {
                List scanLines = lines.subList(j2 * (countX + 3) + 2, j2 * (countX + 3) + (countX + 3));
                for (i = 0; i < countX + 1; ++i) {
                    values = ((String)scanLines.get(i)).split(" ");
                    double tempX = 0.0;
                    double tempY = 0.0;
                    if (values.length == 4) {
                        tempX = Double.parseDouble(values[1]);
                        tempY = Double.parseDouble(values[3]);
                    } else if (values.length == 2) {
                        tempX = Double.parseDouble(values[0]);
                        tempY = Double.parseDouble(values[1]);
                    } else if (values.length == 3) {
                        tempX = values[0].contentEquals("") ? Double.parseDouble(values[1]) : Double.parseDouble(values[0]);
                        tempY = Double.parseDouble(values[2]);
                    }
                    ifov[j2 + i * (countX + 1)] = channelNumber < 4 ? tempY - tempX : (channelNumber == 6 ? tempY + tempX : tempY);
                }
            }
            bufferedReader.close();
            fileReader.close();
            for (j2 = 0; j2 < countY + 1; ++j2) {
                int i3;
                double minimum = 500.0;
                for (i3 = 0; i3 < countX + 1; ++i3) {
                    if (!(ifov[j2 + i3 * (countX + 1)] < minimum)) continue;
                    minimum = ifov[j2 + i3 * (countX + 1)];
                }
                for (i3 = 0; i3 < countX + 1; ++i3) {
                    ifov[j2 + i3 * (countX + 1)] = ifov[j2 + i3 * (countX + 1)] - minimum;
                }
            }
            if (channelNumber < 3) {
                double c;
                double[] dIndexX = new double[countX + 1];
                double[] dIndexY = new double[countY + 1];
                for (i = 0; i < countX + 1; ++i) {
                    dIndexX[i] = i;
                }
                for (int j4 = 0; j4 < countY + 1; ++j4) {
                    dIndexY[j4] = j4;
                }
                for (i = 0; i < 49; ++i) {
                    double m = (ifov[48 + i * (countX + 1)] - ifov[i * (countX + 1)]) / 48.0;
                    c = ifov[i * (countX + 1)];
                    for (j = 0; j < countY + 1; ++j) {
                        ifov[j + i * (countX + 1)] = ifov[j + i * (countX + 1)] - (m * dIndexX[j] + c);
                    }
                }
                for (i = 0; i < 49; ++i) {
                    double m = (ifov[i + 48 * (countX + 1)] - ifov[i]) / 48.0;
                    c = ifov[i];
                    for (j = 0; j < countX + 1; ++j) {
                        ifov[i + j * (countX + 1)] = ifov[i + j * (countX + 1)] - (m * dIndexY[j] + c);
                    }
                }
            }
            double maximum = -500.0;
            double minimum = 500.0;
            for (int i4 = 0; i4 < countX + 1; ++i4) {
                for (int j5 = 0; j5 < countY + 1; ++j5) {
                    if (ifov[i4 + j5 * (countX + 1)] > maximum) {
                        maximum = ifov[i4 + j5 * (countX + 1)];
                    }
                    if (!(ifov[i4 + j5 * (countX + 1)] < minimum)) continue;
                    minimum = ifov[i4 + j5 * (countX + 1)];
                }
            }
            double range = maximum - minimum;
            for (int i5 = 0; i5 < countX + 1; ++i5) {
                for (j = 0; j < countY + 1; ++j) {
                    ifov[i5 + j * (countX + 1)] = (ifov[i5 + j * (countX + 1)] - minimum) / range;
                }
            }
            double sumxz = 0.0;
            double sumyz = 0.0;
            double sumz = 0.0;
            int i6 = 0;
            while ((double)i6 < 49.0) {
                int j6 = 0;
                while ((double)j6 < 49.0) {
                    sumxz += fovArrayX[i6 + j6 * (countX + 1)] * ifov[i6 + j6 * (countX + 1)];
                    sumyz += fovArrayY[i6 + j6 * (countX + 1)] * ifov[i6 + j6 * (countX + 1)];
                    sumz += ifov[i6 + j6 * (countX + 1)];
                    ++j6;
                }
                ++i6;
            }
            double sumX = sumxz / sumz;
            double sumY = sumyz / sumz;
            for (int i7 = 0; i7 < countX + 1; ++i7) {
                for (int j7 = 0; j7 < countY + 1; ++j7) {
                    fovArrayX[i7 + j7 * (countX + 1)] = fovArrayX[i7 + j7 * (countX + 1)] - sumX;
                    fovArrayY[i7 + j7 * (countX + 1)] = fovArrayY[i7 + j7 * (countX + 1)] - sumY;
                }
            }
            this.regridFOV(fovArrayX, fovArrayY, ifov, countX, countY);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.out.println("Could not open raw FOV data, check input filename");
            System.exit(1);
        }
    }

    private void regridFOV(double[] fovArrayX, double[] fovArrayY, double[] ifov, int countX, int countY) {
        int j;
        int i;
        double[] axisX = new double[31];
        double[] axisY = new double[31];
        for (int i2 = 0; i2 < 31; ++i2) {
            axisX[i2] = i2 * 20 - 300;
            axisY[i2] = i2 * 20 - 300;
        }
        double[] regridIfov = new double[961];
        System.out.println("Resampling IFOV using Bilinear Interpolation");
        double[][] reallocatedIFOV = new double[countX + 1][countY + 1];
        for (int i3 = 0; i3 < countX + 1; ++i3) {
            for (int j2 = 0; j2 < countY + 1; ++j2) {
                reallocatedIFOV[i3][j2] = ifov[j2 + i3 * (countX + 1)];
            }
        }
        double[] reallocatedFovArrayX = new double[countX + 1];
        double[] reallocatedFovArrayY = new double[countY + 1];
        System.arraycopy(fovArrayX, 0, reallocatedFovArrayX, 0, countX + 1);
        for (int j3 = 0; j3 < countY + 1; ++j3) {
            reallocatedFovArrayY[j3] = fovArrayY[j3 * (countY + 1)];
        }
        for (i = 0; i < 31; ++i) {
            for (j = 0; j < 31; ++j) {
                double y2;
                double y1;
                double x2;
                double x1;
                double X = axisX[i];
                double Y = axisY[j];
                int solvedX = 0;
                int solvedY = 0;
                int m = 0;
                while (m < countX + 1 && reallocatedFovArrayX[m] >= X) {
                    solvedX = m++;
                }
                int n = 0;
                while (n < countY + 1 && reallocatedFovArrayY[n] >= Y) {
                    solvedY = n++;
                }
                double minX = reallocatedFovArrayX[reallocatedFovArrayX.length - 1];
                if (X < minX) {
                    x1 = reallocatedFovArrayX[reallocatedFovArrayX.length - 2];
                    x2 = reallocatedFovArrayX[reallocatedFovArrayX.length - 1];
                    --solvedX;
                } else {
                    x1 = reallocatedFovArrayX[solvedX];
                    x2 = reallocatedFovArrayX[solvedX + 1];
                }
                double minY = reallocatedFovArrayY[reallocatedFovArrayY.length - 1];
                if (Y < minY) {
                    y1 = reallocatedFovArrayY[reallocatedFovArrayY.length - 2];
                    y2 = reallocatedFovArrayY[reallocatedFovArrayY.length - 1];
                    --solvedY;
                } else {
                    y1 = reallocatedFovArrayY[solvedY];
                    y2 = reallocatedFovArrayY[solvedY + 1];
                }
                double f11 = reallocatedIFOV[solvedX][solvedY];
                double f21 = reallocatedIFOV[solvedX + 1][solvedY];
                double f12 = reallocatedIFOV[solvedX][solvedY + 1];
                double f22 = reallocatedIFOV[solvedX + 1][solvedY + 1];
                regridIfov[j + i * 31] = InputParameters.bilinearInterp(x1, x2, y1, y2, f11, f12, f21, f22, X, Y);
            }
        }
        for (i = 0; i < 31; ++i) {
            for (j = 0; j < 31; ++j) {
                this.alongTrackAngle[i + j * 31] = i * 20 - 300;
                this.acrossTrackAngle[i + j * 31] = j * 20 - 300;
                this.ifov1D[i + j * 31] = regridIfov[i + j * 31];
            }
        }
    }

    private static double bilinearInterp(double x1, double x2, double y1, double y2, double f11, double f12, double f21, double f22, double x, double y) {
        double fxy1 = (x2 - x) / (x2 - x1) * f11 + (x - x1) / (x2 - x1) * f21;
        double fxy2 = (x2 - x) / (x2 - x1) * f12 + (x - x1) / (x2 - x1) * f22;
        double fxy = (y2 - y) / (y2 - y1) * fxy1 + (y - y1) / (y2 - y1) * fxy2;
        return fxy;
    }
}

