/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import java.util.List;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;

class GeolocationInterpolator {
    GeolocationInterpolator() {
    }

    static void searchGeolocationADS(double xCoordinate, double yCoordinate, ProductNodeGroup<MetadataElement> geolocationADS, List<Double> ADSScanYList, double[] pixelLatsLongs, boolean topographicFlag, boolean nadirFlag, double topographyHomogenity) {
        int jg = (int)Math.floor(((xCoordinate /= 1000.0) + 275.0) / 25.0);
        double wx = (xCoordinate + 275.0) / 25.0 - (double)jg;
        int ig = 0;
        int finalCount = ADSScanYList.size();
        int count = 0;
        while (count < finalCount && yCoordinate >= ADSScanYList.get(count)) {
            ig = count++;
        }
        if (ig + 1 < ADSScanYList.size()) {
            double remainder;
            double count2;
            double integer;
            double lambda2;
            double lambda1;
            double longitude;
            double wy = (yCoordinate - ADSScanYList.get(ig)) / (ADSScanYList.get(ig + 1) - ADSScanYList.get(ig));
            MetadataElement geoRecordIg = (MetadataElement)geolocationADS.get(ig);
            MetadataElement geoRecordIgPlus1 = (MetadataElement)geolocationADS.get(ig + 1);
            ProductData geoRecordIgLatitude = geoRecordIg.getAttribute("tie_pt_lat").getData();
            int igGeoLatitude1 = geoRecordIgLatitude.getElemIntAt(jg);
            int igGeoLatitude2 = geoRecordIgLatitude.getElemIntAt(jg + 1);
            ProductData geoRecordIgPlus1Latitude = geoRecordIgPlus1.getAttribute("tie_pt_lat").getData();
            int igGeoPlus1Latitude1 = geoRecordIgPlus1Latitude.getElemIntAt(jg);
            int igGeoPlus1Latitude2 = geoRecordIgPlus1Latitude.getElemIntAt(jg + 1);
            double phi1 = (double)igGeoLatitude1 + wx * (double)(igGeoLatitude2 - igGeoLatitude1);
            double phi2 = (double)igGeoPlus1Latitude1 + wx * (double)(igGeoPlus1Latitude2 - igGeoPlus1Latitude1);
            double latitude = phi1 + wy * (phi2 - phi1);
            ProductData geoRecordIgLongitude = geoRecordIg.getAttribute("tie_pt_long").getData();
            int igGeoLongitude1 = geoRecordIgLongitude.getElemIntAt(jg);
            int igGeoLongitude2 = geoRecordIgLongitude.getElemIntAt(jg + 1);
            ProductData geoRecordIgPlus1Longitude = geoRecordIgPlus1.getAttribute("tie_pt_long").getData();
            int igGeoPlus1Longitude1 = geoRecordIgPlus1Longitude.getElemIntAt(jg);
            int igGeoPlus1Longitude2 = geoRecordIgPlus1Longitude.getElemIntAt(jg + 1);
            double minLongitude = GeolocationInterpolator.getMinValue(igGeoLongitude1, igGeoLongitude2, igGeoPlus1Longitude1, igGeoPlus1Longitude2);
            double maxLongitude = GeolocationInterpolator.getMaxValue(igGeoLongitude1, igGeoLongitude2, igGeoPlus1Longitude1, igGeoPlus1Longitude2);
            if (maxLongitude - minLongitude > 1.8E8) {
                if (igGeoLongitude1 < 0) {
                    igGeoLongitude1 = (int)((double)igGeoLongitude1 + 3.6E8);
                }
                if (igGeoLongitude2 < 0) {
                    igGeoLongitude2 = (int)((double)igGeoLongitude2 + 3.6E8);
                }
                if (igGeoPlus1Longitude1 < 0) {
                    igGeoPlus1Longitude1 = (int)((double)igGeoPlus1Longitude1 + 3.6E8);
                }
                if (igGeoPlus1Longitude2 < 0) {
                    igGeoPlus1Longitude2 = (int)((double)igGeoPlus1Longitude2 + 3.6E8);
                }
            }
            if ((longitude = (lambda1 = (double)igGeoLongitude1 + wx * (double)(igGeoLongitude2 - igGeoLongitude1)) + wy * ((lambda2 = (double)igGeoPlus1Longitude1 + wx * (double)(igGeoPlus1Longitude2 - igGeoPlus1Longitude1)) - lambda1)) > 1.8E8) {
                longitude -= 3.6E8;
            }
            pixelLatsLongs[0] = latitude / 1000000.0;
            pixelLatsLongs[1] = longitude / 1000000.0;
            if (topographicFlag && xCoordinate > (integer = (count2 = xCoordinate / 25.0) - (remainder = count2 % 1.0)) * 25.0 - topographyHomogenity && xCoordinate < integer * 25.0 + topographyHomogenity && yCoordinate > ADSScanYList.get(ig) - topographyHomogenity * 1000.0 && yCoordinate < ADSScanYList.get(ig) + topographyHomogenity * 1000.0) {
                if (nadirFlag) {
                    ProductData geoRecordNadLatCorr = geoRecordIg.getAttribute("lat_corr_nadv").getData();
                    ProductData geoRecordNadLongCorr = geoRecordIg.getAttribute("long_corr_nadv").getData();
                    int nadLatCorr = geoRecordNadLatCorr.getElemIntAt(jg);
                    int nadLongCorr = geoRecordNadLongCorr.getElemIntAt(jg);
                    if (nadLatCorr != -999999 && nadLongCorr != -999999) {
                        pixelLatsLongs[0] = (latitude + (double)nadLatCorr) / 1000000.0;
                        pixelLatsLongs[1] = (longitude + (double)nadLongCorr) / 1000000.0;
                    }
                } else {
                    ProductData geoRecordFwdLatCorr = geoRecordIg.getAttribute("lat_corr_forv").getData();
                    ProductData geoRecordFwdLongCorr = geoRecordIg.getAttribute("long_corr_forv").getData();
                    int fwdLatCorr = geoRecordFwdLatCorr.getElemIntAt(jg);
                    int fwdLongCorr = geoRecordFwdLongCorr.getElemIntAt(jg);
                    if (fwdLatCorr != -999999 && fwdLongCorr != -999999) {
                        pixelLatsLongs[0] = (latitude + (double)fwdLatCorr) / 1000000.0;
                        pixelLatsLongs[1] = (longitude + (double)fwdLongCorr) / 1000000.0;
                    }
                }
            }
        } else {
            pixelLatsLongs[0] = -999999.0;
            pixelLatsLongs[1] = -999999.0;
        }
    }

    static int getMaxValue(int a, int b, int c, int d) {
        int biggest = a;
        if (biggest < b) {
            biggest = b;
        }
        if (biggest < c) {
            biggest = c;
        }
        if (biggest < d) {
            biggest = d;
        }
        return biggest;
    }

    static int getMinValue(int a, int b, int c, int d) {
        int smallest = a;
        if (smallest > b) {
            smallest = b;
        }
        if (smallest > c) {
            smallest = c;
        }
        if (smallest > d) {
            smallest = d;
        }
        return smallest;
    }
}

