/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.aatsr.regrid.GeolocationInterpolator;
import org.esa.s3tbx.aatsr.regrid.InputParameters;
import org.esa.s3tbx.aatsr.regrid.PixelCoordinateInterpolator;
import org.esa.s3tbx.aatsr.regrid.ScanAndPixelIndicesExtractor;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductNodeGroup;

class Calculator {
    public static void getPixelPositionsAcquisitionTimes(int iRow, int jPixel, int s0, ProductNodeGroup<MetadataElement> nadirViewADS, ProductNodeGroup<MetadataElement> forwardViewADS, ProductNodeGroup<MetadataElement> scanPixelADS, ProductNodeGroup<MetadataElement> geolocationADS, List<Double> ADSScanYList, double[] pixelNewPositionsAndTimes, int[] pixelRelativeNumbers, InputParameters parameters) {
        boolean nadirFlag;
        int[] scanAndPixelIndices = new int[]{0, 0};
        double[] pixelCoordinatesAndTime = new double[]{0.0, 0.0, 0.0};
        double[] pixelLatsLongs = new double[]{0.0, 0.0};
        int firstNadirPixel = parameters.firstNadirPixel;
        int firstForwardPixel = parameters.firstForwardPixel;
        ScanAndPixelIndicesExtractor.searchScanAndPixelNumberADS(iRow, jPixel, nadirViewADS, scanAndPixelIndices);
        pixelRelativeNumbers[0] = scanAndPixelIndices[1];
        if (scanAndPixelIndices[0] == 0 || scanAndPixelIndices[1] == 0) {
            pixelNewPositionsAndTimes[0] = -999999.0;
            pixelNewPositionsAndTimes[1] = -999999.0;
            pixelNewPositionsAndTimes[2] = -999999.0;
        } else {
            PixelCoordinateInterpolator.searchScanPixelADS(scanAndPixelIndices, s0, scanPixelADS, firstNadirPixel, pixelCoordinatesAndTime);
            if (parameters.cornerReferenceFlag) {
                PixelCoordinateInterpolator.convertCentreLocationToReference(pixelCoordinatesAndTime, iRow, geolocationADS);
            }
            nadirFlag = true;
            GeolocationInterpolator.searchGeolocationADS(pixelCoordinatesAndTime[0], pixelCoordinatesAndTime[1], geolocationADS, ADSScanYList, pixelLatsLongs, parameters.topographicFlag, nadirFlag, parameters.topographyHomogenity);
            pixelNewPositionsAndTimes[0] = pixelLatsLongs[0];
            pixelNewPositionsAndTimes[1] = pixelLatsLongs[1];
            pixelNewPositionsAndTimes[2] = pixelCoordinatesAndTime[2];
        }
        ScanAndPixelIndicesExtractor.searchScanAndPixelNumberADS(iRow, jPixel, forwardViewADS, scanAndPixelIndices);
        pixelRelativeNumbers[1] = scanAndPixelIndices[1];
        if (scanAndPixelIndices[0] == 0 || scanAndPixelIndices[1] == 0) {
            pixelNewPositionsAndTimes[3] = -999999.0;
            pixelNewPositionsAndTimes[4] = -999999.0;
            pixelNewPositionsAndTimes[5] = -999999.0;
        } else {
            PixelCoordinateInterpolator.searchScanPixelADS(scanAndPixelIndices, s0, scanPixelADS, firstForwardPixel, pixelCoordinatesAndTime);
            if (parameters.cornerReferenceFlag) {
                PixelCoordinateInterpolator.convertCentreLocationToReference(pixelCoordinatesAndTime, iRow, geolocationADS);
            }
            nadirFlag = false;
            GeolocationInterpolator.searchGeolocationADS(pixelCoordinatesAndTime[0], pixelCoordinatesAndTime[1], geolocationADS, ADSScanYList, pixelLatsLongs, parameters.topographicFlag, nadirFlag, parameters.topographyHomogenity);
            pixelNewPositionsAndTimes[3] = pixelLatsLongs[0];
            pixelNewPositionsAndTimes[4] = pixelLatsLongs[1];
            pixelNewPositionsAndTimes[5] = pixelCoordinatesAndTime[2];
        }
    }

    private static void getPixelProjection(InputParameters parameters, double[] pixelDimensions, int[] pixelRelativeNumbers) {
        double coneAngle = Math.toRadians(23.45);
        double gridInterval = 20.0;
        double radius = 6371.0;
        double altitude = 800.0;
        double PI = Math.PI;
        double sinConeAngle = Math.sin(coneAngle);
        double tanConeAngle = Math.tan(coneAngle);
        pixelDimensions[0] = 0.0;
        pixelDimensions[1] = 0.0;
        pixelDimensions[2] = 0.0;
        pixelDimensions[3] = 0.0;
        double[] rotationAngle = new double[101];
        double[] nadirViewAngle = new double[101];
        double[] SSP2PixelAngle = new double[101];
        double[] acrossFOVAngles = new double[101];
        double[] alongFOVAngles = new double[101];
        for (int k = 0; k < 2; ++k) {
            int i;
            int j;
            int j2;
            int i2;
            int i3;
            int i4;
            int pixel = pixelRelativeNumbers[k];
            if (pixel <= 0) {
                if (k == 0) {
                    pixelDimensions[0] = -999999.0;
                    pixelDimensions[1] = -999999.0;
                    break;
                }
                if (k != 1) break;
                pixelDimensions[2] = -999999.0;
                pixelDimensions[3] = -999999.0;
                break;
            }
            for (int i5 = 0; i5 < 101; ++i5) {
                rotationAngle[i5] = i5;
                rotationAngle[i5] = 2.0 * PI * ((double)pixel - (rotationAngle[i5] - 50.0) / 100.0 - 501.0) / 2000.0;
                nadirViewAngle[i5] = 2.0 * Math.asin(sinConeAngle * Math.sin(rotationAngle[i5] / 2.0));
                SSP2PixelAngle[i5] = Math.acos(Math.tan(nadirViewAngle[i5] / 2.0) / tanConeAngle);
                if (Math.abs(rotationAngle[i5]) > PI) {
                    SSP2PixelAngle[i5] = -SSP2PixelAngle[i5];
                }
                acrossFOVAngles[i5] = Math.asin(Math.sin(nadirViewAngle[i5]) * Math.sin(SSP2PixelAngle[i5]));
                alongFOVAngles[i5] = Math.acos(Math.cos(nadirViewAngle[i5]) / Math.cos(acrossFOVAngles[i5]));
                acrossFOVAngles[i5] = Math.toDegrees(acrossFOVAngles[i5] * 3600.0);
                alongFOVAngles[i5] = Math.toDegrees(alongFOVAngles[i5] * 3600.0);
            }
            double centrePixelAcrossAngle = acrossFOVAngles[50];
            double centrePixelAlongAngle = alongFOVAngles[50];
            double viewAngle = nadirViewAngle[50];
            double surfaceToPixelAngle = SSP2PixelAngle[50];
            double zenithAngle = Math.asin(Math.sin(viewAngle) * (radius + altitude) / radius);
            double acrossTrackDistance = radius * Math.asin(Math.sin(zenithAngle - viewAngle) * Math.sin(surfaceToPixelAngle));
            double alongTrackDistance = radius * Math.acos(Math.cos(zenithAngle - viewAngle) / Math.cos(acrossTrackDistance / radius));
            double acrossTrackPerpAngle = Math.atan(radius * Math.sin(acrossTrackDistance / radius) / (radius * (1.0 - Math.cos(acrossTrackDistance / radius)) + altitude));
            double sat2PixelDistance = viewAngle != 0.0 ? radius * Math.sin(zenithAngle - viewAngle) / Math.sin(viewAngle) : altitude;
            double minAlongTrackPixel = 1.0E7;
            double maxAlongTrackPixel = -1.0E7;
            double minAcrossTrackPixel = 1.0E7;
            double maxAcrossTrackPixel = -1.0E7;
            double minAlongTrackFOV = 1.0E7;
            double maxAlongTrackFOV = -1.0E7;
            double minAcrossTrackFOV = 1.0E7;
            double maxAcrossTrackFOV = -1.0E7;
            for (int i6 = 0; i6 < 101; ++i6) {
                if (alongFOVAngles[i6] > maxAlongTrackPixel) {
                    maxAlongTrackPixel = alongFOVAngles[i6];
                }
                if (alongFOVAngles[i6] < minAlongTrackPixel) {
                    minAlongTrackPixel = alongFOVAngles[i6];
                }
                if (acrossFOVAngles[i6] > maxAcrossTrackPixel) {
                    maxAcrossTrackPixel = acrossFOVAngles[i6];
                }
                if (!(acrossFOVAngles[i6] < minAcrossTrackPixel)) continue;
                minAcrossTrackPixel = acrossFOVAngles[i6];
            }
            double[] alongTrackAngle = parameters.alongTrackAngle;
            double[] acrossTrackAngle = parameters.acrossTrackAngle;
            for (int i7 = 0; i7 < 961; ++i7) {
                if (alongTrackAngle[i7] > maxAlongTrackFOV) {
                    maxAlongTrackFOV = alongTrackAngle[i7];
                }
                if (alongTrackAngle[i7] < minAlongTrackFOV) {
                    minAlongTrackFOV = alongTrackAngle[i7];
                }
                if (acrossTrackAngle[i7] > maxAcrossTrackFOV) {
                    maxAcrossTrackFOV = acrossTrackAngle[i7];
                }
                if (!(acrossTrackAngle[i7] < minAcrossTrackFOV)) continue;
                minAcrossTrackFOV = acrossTrackAngle[i7];
            }
            int minAlongTrackIndx = (int)Math.round((minAlongTrackFOV + minAlongTrackPixel - centrePixelAlongAngle) / gridInterval);
            int maxAlongTrackIndx = (int)Math.round((maxAlongTrackFOV + maxAlongTrackPixel - centrePixelAlongAngle) / gridInterval);
            int minAcrossTrackIndx = (int)Math.round((minAcrossTrackFOV + minAcrossTrackPixel - centrePixelAcrossAngle) / gridInterval);
            int maxAcrossTrackIndx = (int)Math.round((maxAcrossTrackFOV + maxAcrossTrackPixel - centrePixelAcrossAngle) / gridInterval);
            double[] alongTrackAngleArray = new double[maxAlongTrackIndx - minAlongTrackIndx + 1];
            double[] acrossTrackAngleArray = new double[maxAcrossTrackIndx - minAcrossTrackIndx + 1];
            double[] FOVResponse = new double[(maxAlongTrackIndx - minAlongTrackIndx + 1) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
            for (i4 = 0; i4 < maxAlongTrackIndx - minAlongTrackIndx + 1; ++i4) {
                alongTrackAngleArray[i4] = (double)i4 * gridInterval + (double)minAlongTrackIndx * gridInterval;
            }
            for (i4 = 0; i4 < maxAcrossTrackIndx - minAcrossTrackIndx + 1; ++i4) {
                acrossTrackAngleArray[i4] = (double)i4 * gridInterval + (double)minAcrossTrackIndx * gridInterval;
            }
            double[] ifov1D = parameters.ifov1D;
            for (int i8 = 0; i8 < 961; ++i8) {
                for (int j3 = 0; j3 < 101; ++j3) {
                    int m = (int)Math.round((alongTrackAngle[i8] + alongFOVAngles[j3] - centrePixelAlongAngle) / gridInterval);
                    int n = (int)Math.round((acrossTrackAngle[i8] + acrossFOVAngles[j3] - centrePixelAcrossAngle) / gridInterval);
                    double dm = (double)m * gridInterval;
                    double dn = (double)n * gridInterval;
                    int u = dm >= alongTrackAngle[i8] + alongFOVAngles[j3] - centrePixelAlongAngle - gridInterval / 2.0 && dm < alongTrackAngle[i8] + alongFOVAngles[j3] - centrePixelAlongAngle + gridInterval / 2.0 ? 1 : 0;
                    int v = dn >= acrossTrackAngle[i8] + acrossFOVAngles[j3] - centrePixelAcrossAngle - gridInterval / 2.0 && dn < acrossTrackAngle[i8] + acrossFOVAngles[j3] - centrePixelAcrossAngle + gridInterval / 2.0 ? 1 : 0;
                    FOVResponse[n - minAcrossTrackIndx + (m - minAlongTrackIndx) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] = FOVResponse[n - minAcrossTrackIndx + (m - minAlongTrackIndx) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] + (double)(u * v) * ifov1D[i8];
                }
            }
            double maximum = -1000000.0;
            double minimum = 1000000.0;
            for (int i9 = 0; i9 < maxAcrossTrackIndx - minAcrossTrackIndx + 1; ++i9) {
                for (int j4 = 0; j4 < maxAlongTrackIndx - minAlongTrackIndx + 1; ++j4) {
                    if (FOVResponse[i9 + j4 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] > maximum) {
                        maximum = FOVResponse[i9 + j4 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    }
                    if (!(FOVResponse[i9 + j4 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] < minimum)) continue;
                    minimum = FOVResponse[i9 + j4 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                }
            }
            double range = maximum - minimum;
            for (i3 = 0; i3 < maxAcrossTrackIndx - minAcrossTrackIndx + 1; ++i3) {
                for (int j5 = 0; j5 < maxAlongTrackIndx - minAlongTrackIndx + 1; ++j5) {
                    FOVResponse[i3 + j5 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] = (FOVResponse[i3 + j5 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] - minimum) / range;
                }
            }
            for (i3 = 0; i3 < maxAlongTrackIndx - minAlongTrackIndx + 1; ++i3) {
                alongTrackAngleArray[i3] = Math.toRadians(alongTrackAngleArray[i3]) / 3600.0 * sat2PixelDistance / Math.cos(Math.toRadians(centrePixelAlongAngle) / 3600.0 + alongTrackDistance / radius);
            }
            for (i3 = 0; i3 < maxAcrossTrackIndx - minAcrossTrackIndx + 1; ++i3) {
                acrossTrackAngleArray[i3] = Math.toRadians(acrossTrackAngleArray[i3]) / 3600.0 * sat2PixelDistance / Math.cos(acrossTrackPerpAngle + acrossTrackDistance / radius);
            }
            int left = 0;
            int right = 0;
            int top = 0;
            int bottom = 0;
            boolean found = false;
            double top_extent_1 = 0.0;
            double top_extent_2 = 0.0;
            double bottom_extent_1 = 0.0;
            double bottom_extent_2 = 0.0;
            double right_extent_1 = 0.0;
            double right_extent_2 = 0.0;
            double left_extent_1 = 0.0;
            double left_extent_2 = 0.0;
            double extent = parameters.pixelIFOVReportingExtent;
            block14: for (i2 = 0; i2 < maxAcrossTrackIndx - minAcrossTrackIndx + 1 && !found; ++i2) {
                for (j2 = 0; j2 < maxAlongTrackIndx - minAlongTrackIndx + 1; ++j2) {
                    if (!(FOVResponse[i2 + j2 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] >= extent)) continue;
                    top = i2;
                    found = true;
                    top_extent_1 = FOVResponse[i2 + j2 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    top_extent_2 = FOVResponse[i2 - 1 + j2 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    continue block14;
                }
            }
            found = false;
            block16: for (i2 = 0; i2 < maxAcrossTrackIndx - minAcrossTrackIndx + 1 && !found; ++i2) {
                for (j2 = 0; j2 < maxAlongTrackIndx - minAlongTrackIndx + 1; ++j2) {
                    if (!(FOVResponse[maxAcrossTrackIndx - minAcrossTrackIndx - i2 + j2 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] >= extent)) continue;
                    bottom = i2 + 1;
                    found = true;
                    bottom_extent_1 = FOVResponse[maxAcrossTrackIndx - minAcrossTrackIndx - i2 + j2 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    bottom_extent_2 = FOVResponse[maxAcrossTrackIndx - minAcrossTrackIndx - (i2 - 1) + j2 * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    continue block16;
                }
            }
            found = false;
            block18: for (j = 0; j < maxAlongTrackIndx - minAlongTrackIndx + 1 && !found; ++j) {
                for (i = 0; i < maxAcrossTrackIndx - minAcrossTrackIndx + 1; ++i) {
                    if (!(FOVResponse[i + j * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] >= extent)) continue;
                    left = j;
                    found = true;
                    left_extent_1 = FOVResponse[i + j * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    left_extent_2 = FOVResponse[i + (j - 1) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    continue block18;
                }
            }
            found = false;
            block20: for (j = 0; j < maxAlongTrackIndx - minAlongTrackIndx + 1 && !found; ++j) {
                for (i = 0; i < maxAcrossTrackIndx - minAcrossTrackIndx + 1; ++i) {
                    if (!(FOVResponse[i + (maxAlongTrackIndx - minAlongTrackIndx - j) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)] >= extent)) continue;
                    right = j + 1;
                    found = true;
                    right_extent_1 = FOVResponse[i + (maxAlongTrackIndx - minAlongTrackIndx - j) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    right_extent_2 = FOVResponse[i + (maxAlongTrackIndx - minAlongTrackIndx - (j - 1)) * (maxAcrossTrackIndx - minAcrossTrackIndx + 1)];
                    continue block20;
                }
            }
            double pixelAcrossDistance = acrossTrackAngleArray[maxAcrossTrackIndx - minAcrossTrackIndx + 1 - bottom] - acrossTrackAngleArray[top];
            double pixelAlongDistance = alongTrackAngleArray[maxAlongTrackIndx - minAlongTrackIndx + 1 - right] - alongTrackAngleArray[left];
            if (k == 0) {
                pixelDimensions[0] = pixelAlongDistance;
                pixelDimensions[1] = pixelAcrossDistance;
                continue;
            }
            if (k != 1) continue;
            pixelDimensions[2] = pixelAlongDistance;
            pixelDimensions[3] = pixelAcrossDistance;
        }
    }

    public static double linearInterp(double x0, double x1, double y0, double y1, double x) {
        double y = y0 + (y1 - y0) * ((x - x0) / (x1 - x0));
        return y;
    }

    public static void getConstantPixelProjection(InputParameters parameters, List<List<Double>> pixelProjectionMap) {
        int i = 0;
        while (i < 2000) {
            double[] pixelDimensions = new double[4];
            int[] pixelRelativeNumbers = new int[]{i++, 0};
            Calculator.getPixelProjection(parameters, pixelDimensions, pixelRelativeNumbers);
            ArrayList<Double> projection = new ArrayList<Double>();
            projection.add(pixelDimensions[0]);
            projection.add(pixelDimensions[1]);
            pixelProjectionMap.add(projection);
        }
    }
}

