/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.List;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class OrbitReferenceMerger
extends AbstractElementMerger {
    OrbitReferenceMerger() {
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        NodeList origChildNodes = fromParents.get(0).getChildNodes();
        this.mergeNodes(origChildNodes, toParent, toDocument);
    }

    private void mergeNodes(NodeList fromNodes, Element toParent, Document toDocument) {
        for (int j = 0; j < fromNodes.getLength(); ++j) {
            Node child = fromNodes.item(j);
            if (child.getNodeType() == 3) continue;
            Element childElement = toDocument.createElement(child.getNodeName());
            if (!child.getTextContent().contains("\n")) {
                String textContent = child.getTextContent();
                Text textNode = toDocument.createTextNode(textContent);
                childElement.appendChild(textNode);
            } else {
                NodeList childNodes = child.getChildNodes();
                if (childNodes.getLength() > 1) {
                    this.mergeNodes(childNodes, childElement, toDocument);
                }
            }
            NamedNodeMap attributes = child.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                childElement.setAttribute(item.getNodeName(), item.getNodeValue());
            }
            toParent.appendChild(childElement);
        }
    }
}

