/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSizeHandler;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AlongTrackCoordinateMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ClassificationSummaryMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.CreationTimeMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.DataObjectMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.DumpInformationMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.DurationMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ElementMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.FootprintMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ImageSizesMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.MaxMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.MinMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.MissingElementsMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.OrbitReferenceMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.PixelQualitySummaryMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ProductNameMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ProductSizeMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.StartTimesMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.StopTimesMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ManifestMerger {
    private Date creationTime;
    private static DefaultMerger defaultMerger;
    private File productDir;
    private long productSize;
    private ImageSize[][] imageSizes;
    private static final String[] discerningAttributesNames;

    public File createMergedManifest(File[] manifestFiles, Date creationTime, File productDir, long productSize) throws IOException, TransformerException, PDUStitchingException, ParserConfigurationException {
        Document document = this.mergeManifests(manifestFiles, creationTime, productDir, productSize);
        File manifestFile = new File(productDir, "xfdumanifest.xml");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 2);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("encoding", "UTF-8");
        DOMSource domSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(domSource, streamResult);
        String docAsString = stringWriter.toString();
        docAsString = docAsString.replace(" standalone=\"no\"", "");
        FileWriter fileWriter = new FileWriter(manifestFile);
        fileWriter.write(docAsString);
        fileWriter.close();
        return manifestFile;
    }

    private Document mergeManifests(File[] manifestFiles, Date creationTime, File productDir, long productSize) throws IOException, PDUStitchingException, ParserConfigurationException {
        this.creationTime = creationTime;
        this.productDir = productDir;
        this.productSize = productSize;
        ArrayList<Node> manifestList = new ArrayList<Node>();
        this.imageSizes = new ImageSize[manifestFiles.length][];
        for (int i = 0; i < manifestFiles.length; ++i) {
            File manifestFile = manifestFiles[i];
            Document xmlDocument = ManifestMerger.createXmlDocument(new FileInputStream(manifestFile));
            this.imageSizes[i] = ImageSizeHandler.extractImageSizes(xmlDocument);
            manifestList.add(xmlDocument);
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        defaultMerger = new DefaultMerger();
        defaultMerger.mergeNodes(manifestList, document, document);
        return document;
    }

    private static Document createXmlDocument(InputStream inputStream) throws IOException {
        String msg = "Cannot create document from manifest XML file.";
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot create document from manifest XML file.", e);
        }
    }

    private ElementMerger getElementMerger(String elementName) throws PDUStitchingException {
        switch (elementName) {
            case "dataObject": {
                return new DataObjectMerger(this.productDir.getAbsolutePath());
            }
            case "slstr:nadirImageSize": 
            case "slstr:obliqueImageSize": {
                return new ImageSizesMerger();
            }
            case "sentinel-safe:startTime": {
                return new StartTimesMerger();
            }
            case "sentinel-safe:stopTime": {
                return new StopTimesMerger();
            }
            case "slstr:classificationSummary": {
                return new ClassificationSummaryMerger(this.imageSizes);
            }
            case "slstr:pixelQualitySummary": {
                return new PixelQualitySummaryMerger();
            }
            case "slstr:missingElements": {
                return new MissingElementsMerger();
            }
            case "sentinel-safe:footPrint": {
                return new FootprintMerger(this.productDir);
            }
            case "sentinel3:creationTime": {
                return new CreationTimeMerger(this.creationTime);
            }
            case "sentinel3:productName": {
                return new ProductNameMerger(this.productDir.getName());
            }
            case "sentinel3:productSize": {
                return new ProductSizeMerger(this.productSize);
            }
            case "slstr:min": {
                return new MinMerger();
            }
            case "slstr:max": {
                return new MaxMerger();
            }
            case "sentinel3:dumpInformation": {
                return new DumpInformationMerger();
            }
            case "sentinel-safe:orbitReference": {
                return new OrbitReferenceMerger();
            }
            case "sentinel3:duration": {
                return new DurationMerger();
            }
            case "sentinel3:alongtrackCoordinate": {
                return new AlongTrackCoordinateMerger();
            }
        }
        return defaultMerger;
    }

    static {
        discerningAttributesNames = new String[]{"ID", "name", "grid", "view", "element", "type", "role"};
    }

    private class DefaultMerger
    extends AbstractElementMerger {
        private DefaultMerger() {
        }

        @Override
        public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
            this.mergeNodes(fromParents, (Node)toParent, toDocument);
        }

        public void mergeNodes(List<Node> fromParents, Node toParent, Document toDocument) throws PDUStitchingException {
            NodeList[] childNodeLists = new NodeList[fromParents.size()];
            for (int i = 0; i < childNodeLists.length; ++i) {
                childNodeLists[i] = fromParents.get(i).getChildNodes();
            }
            for (int j = 0; j < fromParents.size(); ++j) {
                for (int i = 0; i < childNodeLists[j].getLength(); ++i) {
                    Node child = childNodeLists[j].item(i);
                    if (child.getNodeType() == 3 && child.getTextContent().contains("\n") || this.hasIdenticalChild(toParent, child)) continue;
                    String nodeValue = child.getNodeValue();
                    List<Node> childNodes = this.collectChildNodes(child, childNodeLists, j);
                    if (child.getNodeType() == 3) {
                        String textContent = child.getTextContent();
                        Text textNode = toDocument.createTextNode(textContent);
                        toParent.appendChild(textNode);
                        continue;
                    }
                    Element manifestElement = toDocument.createElement(child.getNodeName());
                    manifestElement.setNodeValue(nodeValue);
                    this.copyAttributes(childNodes, manifestElement);
                    toParent.appendChild(manifestElement);
                    this.mergeChildNodes(childNodes, manifestElement, toDocument);
                }
            }
        }

        void mergeChildNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
            ElementMerger elementMerger = ManifestMerger.this.getElementMerger(toParent.getNodeName());
            elementMerger.mergeNodes(fromParents, toParent, toDocument);
        }

        private List<Node> collectChildNodes(Node child, NodeList[] childNodeLists, int indexOfCurrentParent) throws PDUStitchingException {
            ArrayList<Node> itemNodes = new ArrayList<Node>();
            itemNodes.add(child);
            String nodeValue = child.getNodeValue();
            if (indexOfCurrentParent < childNodeLists.length - 1) {
                block0: for (int k = indexOfCurrentParent + 1; k < childNodeLists.length; ++k) {
                    for (int l = 0; l < childNodeLists[k].getLength(); ++l) {
                        if (!childNodeLists[k].item(l).getNodeName().equals(child.getNodeName())) continue;
                        boolean discerningAttributesAreDifferent = false;
                        NamedNodeMap attributes = child.getAttributes();
                        NamedNodeMap otherAttributes = childNodeLists[k].item(l).getAttributes();
                        if (attributes != null && otherAttributes != null) {
                            for (String name : discerningAttributesNames) {
                                Node attributeToBeChecked = attributes.getNamedItem(name);
                                Node attribute = otherAttributes.getNamedItem(name);
                                if (attributeToBeChecked == null || attribute == null || attributeToBeChecked.getNodeValue().trim().equals(attribute.getNodeValue().trim())) continue;
                                discerningAttributesAreDifferent = true;
                            }
                        }
                        if (discerningAttributesAreDifferent) continue;
                        String otherNodeValue = childNodeLists[k].item(l).getNodeValue();
                        if (otherNodeValue != null && nodeValue == null || otherNodeValue == null && nodeValue != null || otherNodeValue != null && !otherNodeValue.trim().equals(nodeValue.trim())) {
                            throw new PDUStitchingException("Different values for node " + child.getParentNode().getNodeName() + ": " + otherNodeValue + ", " + nodeValue);
                        }
                        itemNodes.add(childNodeLists[k].item(l));
                        continue block0;
                    }
                }
            }
            return itemNodes;
        }

        private boolean hasIdenticalChild(Node node, Node newNode) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node nodeToBeChecked = node.getChildNodes().item(i);
                if (!nodeToBeChecked.getNodeName().equals(newNode.getNodeName())) continue;
                NamedNodeMap nodeToBeCheckedAttributes = nodeToBeChecked.getAttributes();
                NamedNodeMap attributes = newNode.getAttributes();
                if (nodeToBeCheckedAttributes != null && attributes != null) {
                    boolean atLeastOneDiscerningAttributeIsDifferent = false;
                    for (String name : discerningAttributesNames) {
                        Node attributeToBeChecked = nodeToBeCheckedAttributes.getNamedItem(name);
                        Node attribute = attributes.getNamedItem(name);
                        if (attributeToBeChecked == null || attribute == null || attributeToBeChecked.getNodeValue().trim().equals(attribute.getNodeValue().trim())) continue;
                        atLeastOneDiscerningAttributeIsDifferent = true;
                        break;
                    }
                    if (atLeastOneDiscerningAttributeIsDifferent) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
    }
}

