/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.List;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AlongTrackCoordinateMerger
extends AbstractElementMerger {
    AlongTrackCoordinateMerger() {
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        int minAlongtrackCoordinate = Integer.MAX_VALUE;
        for (Node node : fromParents) {
            try {
                int alongTrackCoordinate = Integer.parseInt(node.getTextContent());
                if (alongTrackCoordinate >= minAlongtrackCoordinate) continue;
                minAlongtrackCoordinate = alongTrackCoordinate;
            }
            catch (NumberFormatException nfe) {
                throw new PDUStitchingException("Could not parse duration: " + nfe.getMessage());
            }
        }
        this.addTextToNode(toParent, String.valueOf(minAlongtrackCoordinate), toDocument);
    }
}

