/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.converters.DateFormatConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class AbstractElementMerger
implements ElementMerger {
    protected static final DateFormatConverter SLSTR_DATE_FORMAT_CONVERTER = new DateFormatConverter((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));

    AbstractElementMerger() {
    }

    protected void addTextToNode(Node node, String text, Document toDocument) throws PDUStitchingException {
        Text textNode = toDocument.createTextNode(text);
        node.appendChild(textNode);
    }

    protected static Date parseDate(String text) throws PDUStitchingException {
        String subDate = text.substring(0, 23) + "Z";
        try {
            return SLSTR_DATE_FORMAT_CONVERTER.parse(subDate);
        }
        catch (ConversionException e) {
            throw new PDUStitchingException("Error while parsing time: " + e.getMessage());
        }
    }

    protected void copyAttributes(List<Node> itemNodes, Element manifestElement) throws PDUStitchingException {
        for (int n = 0; n < itemNodes.size(); ++n) {
            Node currentItem = itemNodes.get(n);
            NamedNodeMap attributes = currentItem.getAttributes();
            if (attributes == null) continue;
            for (int k = 0; k < attributes.getLength(); ++k) {
                Node attribute = attributes.item(k);
                String attributeName = attribute.getNodeName();
                if (manifestElement.hasAttribute(attributeName)) continue;
                String attributeValue = attribute.getNodeValue();
                if (n < itemNodes.size() - 1) {
                    for (int m = n + 1; m < itemNodes.size(); ++m) {
                        Date otherStartValue;
                        Date startValue;
                        NamedNodeMap otherItemAttributes = itemNodes.get(m).getAttributes();
                        Node otherAttribute = otherItemAttributes.getNamedItem(attributeName);
                        if (otherAttribute == null) continue;
                        String otherAttributeValue = otherAttribute.getNodeValue();
                        if (attributeName.equals("start")) {
                            startValue = AbstractElementMerger.parseDate(attributeValue);
                            otherStartValue = AbstractElementMerger.parseDate(otherAttributeValue);
                            if (!otherStartValue.before(startValue)) continue;
                            attributeValue = otherAttributeValue;
                            continue;
                        }
                        if (attributeName.equals("stop")) {
                            startValue = AbstractElementMerger.parseDate(attributeValue);
                            otherStartValue = AbstractElementMerger.parseDate(otherAttributeValue);
                            if (!otherStartValue.after(startValue)) continue;
                            attributeValue = otherAttributeValue;
                            continue;
                        }
                        if (otherAttributeValue.equals(attributeValue)) continue;
                        throw new PDUStitchingException("Different values for attribute " + attributeName + " of node " + currentItem.getNodeName());
                    }
                }
                manifestElement.setAttribute(attributeName, attributeValue.trim());
            }
        }
    }
}

