/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.converters.DateFormatConverter;
import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSizeHandler;
import org.esa.s3tbx.slstr.pdu.stitching.NcFileStitcher;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.Validator;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestMerger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SlstrPduStitcher {
    private static final String SLSTR_L1B_NAME_PATTERN = "S3.?_SL_1_RBT_.*(.SEN3)?";
    private static final DateFormatConverter SLSTR_DATE_FORMAT_CONVERTER = new DateFormatConverter((DateFormat)new SimpleDateFormat("yyyyMMdd'T'HHmmss"));
    private static final ImageSize NULL_IMAGE_SIZE = new ImageSize("null", 0, 0, 0, 0);

    public static File createStitchedSlstrL1BFile(File targetDirectory, File[] slstrProductFiles, ProgressMonitor pm) throws IllegalArgumentException, IOException, PDUStitchingException, ParserConfigurationException, TransformerException {
        Assert.notNull((Object)slstrProductFiles);
        Logger logger = Logger.getLogger(SlstrPduStitcher.class.getName());
        if (slstrProductFiles.length == 0) {
            throw new IllegalArgumentException("No product files provided");
        }
        Pattern slstrNamePattern = Pattern.compile(SLSTR_L1B_NAME_PATTERN);
        for (int i = 0; i < slstrProductFiles.length; ++i) {
            if (slstrProductFiles[i] == null) {
                throw new PDUStitchingException("File must not be null");
            }
            if (!slstrProductFiles[i].getName().equals("xfdumanifest.xml")) {
                slstrProductFiles[i] = new File(slstrProductFiles[i], "xfdumanifest.xml");
            }
            if (slstrProductFiles[i].getName().equals("xfdumanifest.xml") && slstrProductFiles[i].getParentFile() != null && slstrNamePattern.matcher(slstrProductFiles[i].getParentFile().getName()).matches()) continue;
            throw new IllegalArgumentException("The PDU Stitcher only supports SLSTR L1B products");
        }
        Date now = Calendar.getInstance().getTime();
        if (slstrProductFiles.length == 1) {
            File originalParentDirectory = slstrProductFiles[0].getParentFile();
            String parentDirectoryName = originalParentDirectory.getName();
            File stitchedParentDirectory = new File(targetDirectory, parentDirectoryName);
            if (stitchedParentDirectory.exists()) {
                throw new PDUStitchingException("Target file directory already exists");
            }
            Files.copy(originalParentDirectory.getParentFile().toPath(), stitchedParentDirectory.toPath(), new CopyOption[0]);
            File[] files = originalParentDirectory.listFiles();
            long productSize = 0L;
            if (files != null) {
                for (File originalFile : files) {
                    File newFile = new File(stitchedParentDirectory, originalFile.getName());
                    Files.copy(originalFile.toPath(), newFile.toPath(), new CopyOption[0]);
                    productSize += newFile.length();
                }
            }
            return SlstrPduStitcher.createManifestFile(slstrProductFiles, stitchedParentDirectory, now, productSize);
        }
        SlstrNameDecomposition[] slstrNameDecompositions = new SlstrNameDecomposition[slstrProductFiles.length];
        Document[] manifestDocuments = new Document[slstrProductFiles.length];
        ArrayList<String> ncFileNames = new ArrayList<String>();
        HashMap<String, ImageSize[]> idToImageSizes = new HashMap<String, ImageSize[]>();
        for (int i = 0; i < slstrProductFiles.length; ++i) {
            ImageSize[] imageSizes;
            slstrNameDecompositions[i] = SlstrPduStitcher.decomposeSlstrName(slstrProductFiles[i].getParentFile().getName());
            manifestDocuments[i] = SlstrPduStitcher.createXmlDocument(new FileInputStream(slstrProductFiles[i]));
            for (ImageSize imageSize : imageSizes = ImageSizeHandler.extractImageSizes(manifestDocuments[i])) {
                if (idToImageSizes.containsKey(imageSize.getIdentifier())) {
                    ((ImageSize[])idToImageSizes.get((Object)imageSize.getIdentifier()))[i] = imageSize;
                    continue;
                }
                ImageSize[] mapImageSizes = new ImageSize[slstrProductFiles.length];
                mapImageSizes[i] = imageSize;
                idToImageSizes.put(imageSize.getIdentifier(), mapImageSizes);
            }
            SlstrPduStitcher.collectFiles(ncFileNames, manifestDocuments[i]);
        }
        Validator.validateOrbitReference(manifestDocuments);
        Validator.validateAdjacency(manifestDocuments);
        String stitchedProductFileName = SlstrPduStitcher.createParentDirectoryNameOfStitchedFile(slstrNameDecompositions, now);
        File stitchedProductFileParentDirectory = new File(targetDirectory, stitchedProductFileName);
        if (stitchedProductFileParentDirectory.exists()) {
            throw new PDUStitchingException("Target file directory already exists");
        }
        if (!stitchedProductFileParentDirectory.mkdirs()) {
            throw new PDUStitchingException("Could not create product directory");
        }
        HashMap<String, ImageSize> idToTargetImageSize = new HashMap<String, ImageSize>();
        for (String id : idToImageSizes.keySet()) {
            idToTargetImageSize.put(id, ImageSizeHandler.createTargetImageSize((ImageSize[])idToImageSizes.get(id)));
        }
        long productSize = 0L;
        pm.beginTask("Stitching SLSTR L1B Product Dissemination Units", ncFileNames.size() + 1);
        for (int i = 0; i < ncFileNames.size(); ++i) {
            Object[] imageSizes;
            ImageSize targetImageSize;
            String ncFileName = (String)ncFileNames.get(i);
            String[] splitFileName = ncFileName.split("/");
            String displayFileName = splitFileName[splitFileName.length - 1];
            pm.setSubTaskName(MessageFormat.format("Stitching ''{0}''", displayFileName));
            ArrayList<File> ncFiles = new ArrayList<File>();
            ArrayList<Object> imageSizeList = new ArrayList<Object>();
            String id = ncFileName.substring(ncFileName.length() - 5, ncFileName.length() - 3);
            if (id.equals("tx")) {
                id = "tn";
            }
            if ((targetImageSize = (ImageSize)idToTargetImageSize.get(id)) == null) {
                targetImageSize = NULL_IMAGE_SIZE;
            }
            if ((imageSizes = (ImageSize[])idToImageSizes.get(id)) == null) {
                imageSizes = new ImageSize[ncFileNames.size()];
                Arrays.fill(imageSizes, NULL_IMAGE_SIZE);
            }
            for (int j = 0; j < slstrProductFiles.length; ++j) {
                File slstrProductFile = slstrProductFiles[j];
                File ncFile = new File(slstrProductFile.getParentFile(), ncFileName);
                if (!ncFile.exists()) continue;
                ncFiles.add(ncFile);
                imageSizeList.add(imageSizes[j]);
            }
            if (ncFiles.size() > 0) {
                File[] ncFilesArray = ncFiles.toArray(new File[ncFiles.size()]);
                ImageSize[] imageSizeArray = imageSizeList.toArray(new ImageSize[imageSizeList.size()]);
                logger.log(Level.INFO, "Stitch " + displayFileName);
                NcFileStitcher.stitchNcFiles(ncFileName, stitchedProductFileParentDirectory, now, ncFilesArray, targetImageSize, imageSizeArray);
                productSize += new File(stitchedProductFileParentDirectory, ncFileName).length();
            }
            pm.worked(1);
        }
        pm.setSubTaskName("Stitching manifest");
        logger.log(Level.INFO, "Stitch manifest");
        File manifestFile = SlstrPduStitcher.createManifestFile(slstrProductFiles, stitchedProductFileParentDirectory, now, productSize);
        return manifestFile;
    }

    private static File createManifestFile(File[] manifestFiles, File stitchedParentDirectory, Date now, long productSize) throws ParserConfigurationException, PDUStitchingException, IOException, TransformerException {
        return new ManifestMerger().createMergedManifest(manifestFiles, now, stitchedParentDirectory, productSize);
    }

    static void collectFiles(List<String> ncFileNames, Document manifestDocument) {
        NodeList fileLocationNodes = manifestDocument.getElementsByTagName("fileLocation");
        for (int i = 0; i < fileLocationNodes.getLength(); ++i) {
            String ncFileName = fileLocationNodes.item(i).getAttributes().getNamedItem("href").getNodeValue();
            if (ncFileNames.contains(ncFileName)) continue;
            ncFileNames.add(ncFileName);
        }
    }

    private static Document createXmlDocument(InputStream inputStream) throws IOException {
        String msg = "Cannot create document from manifest XML file.";
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot create document from manifest XML file.", e);
        }
    }

    static String createParentDirectoryNameOfStitchedFile(SlstrNameDecomposition[] slstrNameDecompositions, Date now) {
        String[] slstrNameParts;
        Date startTime = SlstrPduStitcher.extractStartTime(slstrNameDecompositions);
        Date stopTime = SlstrPduStitcher.extractStopTime(slstrNameDecompositions);
        StringBuilder slstrNameStringBuilder = new StringBuilder("S3A_SL_1_RBT___");
        for (String namePart : slstrNameParts = new String[]{SLSTR_DATE_FORMAT_CONVERTER.format(startTime), SLSTR_DATE_FORMAT_CONVERTER.format(stopTime), SLSTR_DATE_FORMAT_CONVERTER.format(now), slstrNameDecompositions[0].duration, slstrNameDecompositions[0].cycleNumber, slstrNameDecompositions[0].relativeOrbitNumber, slstrNameDecompositions[0].frameAlongTrackCoordinate, slstrNameDecompositions[0].fileGeneratingCentre, slstrNameDecompositions[0].platform, slstrNameDecompositions[0].timelinessOfProcessingWorkflow, slstrNameDecompositions[0].baselineCollectionOrDataUsage}) {
            slstrNameStringBuilder.append("_").append(namePart);
        }
        slstrNameStringBuilder.append(".SEN3");
        return slstrNameStringBuilder.toString();
    }

    private static Date extractStartTime(SlstrNameDecomposition[] slstrNameDecompositions) {
        Date earliestDate = new GregorianCalendar(3000, 1, 1).getTime();
        for (SlstrNameDecomposition slstrNameDecomposition : slstrNameDecompositions) {
            Date startTime = slstrNameDecomposition.startTime;
            if (!startTime.before(earliestDate)) continue;
            earliestDate = startTime;
        }
        return earliestDate;
    }

    private static Date extractStopTime(SlstrNameDecomposition[] slstrNameDecompositions) {
        Date latestDate = new GregorianCalendar(1800, 1, 1).getTime();
        for (SlstrNameDecomposition slstrNameDecomposition : slstrNameDecompositions) {
            Date stopTime = slstrNameDecomposition.stopTime;
            if (!stopTime.after(latestDate)) continue;
            latestDate = stopTime;
        }
        return latestDate;
    }

    static SlstrNameDecomposition decomposeSlstrName(String slstrName) {
        SlstrNameDecomposition slstrNameDecomposition = new SlstrNameDecomposition();
        try {
            slstrNameDecomposition.startTime = SLSTR_DATE_FORMAT_CONVERTER.parse(slstrName.substring(16, 31));
        }
        catch (ConversionException e) {
            e.printStackTrace();
        }
        try {
            slstrNameDecomposition.stopTime = SLSTR_DATE_FORMAT_CONVERTER.parse(slstrName.substring(32, 47));
        }
        catch (ConversionException e) {
            e.printStackTrace();
        }
        slstrNameDecomposition.duration = slstrName.substring(64, 68);
        slstrNameDecomposition.cycleNumber = slstrName.substring(69, 72);
        slstrNameDecomposition.relativeOrbitNumber = slstrName.substring(73, 76);
        slstrNameDecomposition.frameAlongTrackCoordinate = slstrName.substring(77, 81);
        slstrNameDecomposition.fileGeneratingCentre = slstrName.substring(82, 85);
        slstrNameDecomposition.platform = slstrName.substring(86, 87);
        slstrNameDecomposition.timelinessOfProcessingWorkflow = slstrName.substring(88, 90);
        slstrNameDecomposition.baselineCollectionOrDataUsage = slstrName.substring(91, 94);
        return slstrNameDecomposition;
    }

    static class SlstrNameDecomposition {
        Date startTime;
        Date stopTime;
        String duration;
        String cycleNumber;
        String relativeOrbitNumber;
        String frameAlongTrackCoordinate;
        String fileGeneratingCentre;
        String platform;
        String timelinessOfProcessingWorkflow;
        String baselineCollectionOrDataUsage;

        SlstrNameDecomposition() {
        }
    }
}

