/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhFileWriter;
import edu.ucar.ral.nujan.netcdf.NhGroup;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.awt.Dimension;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrN4Variable;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrNetcdfUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.dataio.netcdf.nc.N4Variable;
import ucar.ma2.DataType;

public class SlstrNFileWritable {
    private static final int DEFAULT_COMPRESSION = 6;
    private final NhFileWriter nhFileWriter;
    private Map<String, SlstrN4Variable> variables;

    public static SlstrNFileWritable create(String filename) throws IOException {
        try {
            return new SlstrNFileWritable(new NhFileWriter(filename, 1));
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    private SlstrNFileWritable(NhFileWriter nhFileWriter) {
        this.nhFileWriter = nhFileWriter;
        this.variables = new HashMap<String, SlstrN4Variable>();
    }

    void addDimension(String name, int length) throws IOException {
        try {
            this.nhFileWriter.getRootGroup().addDimension(name, length);
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    void addGlobalAttribute(String name, String value) throws IOException {
        try {
            this.nhFileWriter.getRootGroup().addAttribute(name, 9, (Object)SlstrNFileWritable.cropStringToMaxAttributeLength(name, value));
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    private static String cropStringToMaxAttributeLength(String name, String value) {
        if (value.length() > 64535) {
            value = value.substring(0, 64535);
            String msg = String.format("Metadata attribute '%s' has been cropped. Exceeded maximum length of %d", name, 64535);
            Logger.getLogger(N4Variable.class.getSimpleName()).log(Level.WARNING, msg);
        }
        return value;
    }

    SlstrN4Variable addVariable(String name, DataType dataType, boolean unsigned, int[] chunkLens, String dims) throws IOException {
        return this.addVariable(name, dataType, unsigned, chunkLens, dims, 6);
    }

    SlstrN4Variable addVariable(String name, DataType dataType, boolean unsigned, int[] chunkLens, String dimensions, int compressionLevel) throws IOException {
        int i;
        NhGroup rootGroup = this.nhFileWriter.getRootGroup();
        int nhType = SlstrNetcdfUtils.convert(dataType, unsigned);
        String[] dims = dimensions.split(" ");
        int numDims = dims.length;
        NhDimension[] nhDims = new NhDimension[numDims];
        for (i = 0; i < numDims; ++i) {
            nhDims[i] = rootGroup.findLocalDimension(dims[i]);
        }
        if (chunkLens != null) {
            int i2;
            if (chunkLens.length != nhDims.length) {
                throw new IllegalArgumentException("Number of chunk sizes must be same as number of dimensions");
            }
            int imageSize = 1;
            int chunkSize = 1;
            for (i2 = 0; i2 < numDims; ++i2) {
                imageSize *= nhDims[i2].getLength();
                chunkSize *= chunkLens[i2];
            }
            while (imageSize / chunkSize > 16383) {
                chunkSize = 1;
                for (i2 = 0; i2 < numDims; ++i2) {
                    int n = i2;
                    chunkLens[n] = chunkLens[n] * 2;
                    chunkLens[i2] = Math.min(nhDims[i2].getLength(), chunkLens[i2]);
                    chunkSize *= chunkLens[i2];
                }
            }
        } else {
            chunkLens = new int[numDims];
            if (numDims == 1) {
                chunkLens[0] = nhDims[0].getLength();
            } else {
                for (i = 0; i < numDims - 1; ++i) {
                    Dimension tileSize = JAIUtils.computePreferredTileSize((int)nhDims[i].getLength(), (int)nhDims[i + 1].getLength(), (int)1);
                    chunkLens[i] = (int)tileSize.getWidth();
                    chunkLens[i + 1] = (int)tileSize.getHeight();
                }
            }
        }
        Object fillValue = null;
        try {
            NhVariable variable = rootGroup.addVariable(name, nhType, nhDims, chunkLens, fillValue, compressionLevel);
            SlstrN4Variable nVariable = new SlstrN4Variable(variable, chunkLens);
            this.variables.put(name, nVariable);
            return nVariable;
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    SlstrN4Variable findVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public void create() throws IOException {
        try {
            this.nhFileWriter.endDefine();
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    void close() throws IOException {
        try {
            this.nhFileWriter.close();
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }
}

