/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrNetcdfUtils;
import org.esa.snap.dataio.netcdf.nc.N4Variable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;

public class SlstrN4Variable {
    private static final int MAX_ATTRIBUTE_LENGTH = 64535;
    private final NhVariable variable;
    private final int[] chunkLengths;

    SlstrN4Variable(NhVariable variable, int[] chunkLengths) {
        this.variable = variable;
        this.chunkLengths = chunkLengths;
    }

    public String getName() {
        return this.variable.getName();
    }

    void addAttribute(String name, String value) throws IOException {
        this.addAttributeImpl(name, SlstrN4Variable.cropStringToMaxAttributeLength(name, value), 9);
    }

    void addAttribute(String name, Number value, boolean isUnsigned) throws IOException {
        DataType dataType = DataType.getType(value.getClass());
        int nhType = SlstrNetcdfUtils.convert(dataType, isUnsigned);
        this.addAttributeImpl(name, value, nhType);
    }

    void addAttribute(String name, Array value) throws IOException {
        DataType dataType = DataType.getType((Class)value.getElementType());
        int nhType = SlstrNetcdfUtils.convert(dataType, value.isUnsigned());
        this.addAttributeImpl(name, value.getStorage(), nhType);
    }

    private void addAttributeImpl(String name, Object value, int type) throws IOException {
        name = name.replace('.', '_');
        try {
            if (!this.variable.attributeExists(name)) {
                this.variable.addAttribute(name, type, value);
            }
        }
        catch (NhException e) {
            throw new IOException(e);
        }
    }

    public void writeFullyInSections(Array values) throws IOException {
        try {
            int[] indexes = new int[values.getShape().length];
            while (indexes != null) {
                this.variable.writeData(indexes, (Object)values.sectionNoReduce(indexes, this.chunkLengths, null));
                indexes = this.getNextIndexes(indexes, values.getShape());
            }
        }
        catch (NhException | InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    private int[] getNextIndexes(int[] indexes, int[] totalSizes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            int n = i;
            indexes[n] = indexes[n] + this.chunkLengths[i];
            int n2 = i;
            indexes[n2] = indexes[n2] % totalSizes[i];
            if (indexes[i] <= 0) continue;
            return indexes;
        }
        return null;
    }

    int[] getChunkLengths() {
        return this.chunkLengths;
    }

    private static String cropStringToMaxAttributeLength(String name, String value) {
        if (value.length() > 64535) {
            value = value.substring(0, 64535);
            String msg = String.format("Metadata attribute '%s' has been cropped. Exceeded maximum length of %d", name, 64535);
            Logger.getLogger(N4Variable.class.getSimpleName()).log(Level.WARNING, msg);
        }
        return value;
    }
}

