/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrPduStitcher;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.WildcardMatcher;

@OperatorMetadata(alias="PduStitching", category="Optical", version="1.0", authors="Tonio Fincke", copyright="Copyright (C) 2015 by Brockmann Consult (info@brockmann-consult.de)", description="Stitches multiple SLSTR L1B product dissemination units (PDUs) of the same orbit to a single product.", autoWriteDisabled=true)
public class PDUStitchingOp
extends Operator {
    @SourceProducts(description="The product dissemination units to be stitched together. Must all be of type 'SLSTR L1B'.\nIf not given, the parameter 'sourceProductPaths' must be provided.")
    Product[] sourceProducts;
    @Parameter(description="A comma-separated list of file paths specifying the product dissemination units.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).\nIf not given, the parameter 'sourceProducts' must be provided.")
    private String[] sourceProductPaths;
    @Parameter(description="The directory to which the stitched product shall be written.\nWithin this directory, a folder of the SLSTR L1B naming format will be created.\nIf no target directory is given, the product will be written to the user directory.")
    private File targetDir;
    private File[] files;

    public void initialize() throws OperatorException {
        this.setDummyTargetProduct();
        if (!(this.sourceProducts != null && this.sourceProducts.length != 0 || this.sourceProductPaths != null && this.sourceProductPaths.length != 0)) {
            throw new OperatorException("Either 'sourceProducts' pr 'sourceProductPaths' must be set");
        }
        Set<File> filesByProduct = PDUStitchingOp.getSourceProductsFileSet(this.sourceProducts);
        Set<File> filesByPath = PDUStitchingOp.getSourceProductsPathFileSet(this.sourceProductPaths, this.getLogger());
        filesByPath.addAll(filesByProduct);
        this.files = filesByPath.toArray(new File[filesByPath.size()]);
        if (this.files.length == 0) {
            throw new OperatorException("No PDUs to be stitched could be found.");
        }
        if (this.targetDir == null || StringUtils.isNullOrEmpty((String)this.targetDir.getAbsolutePath())) {
            this.targetDir = new File(SystemUtils.getUserHomeDir().getPath());
        }
    }

    public void doExecute(ProgressMonitor pm) throws OperatorException {
        try {
            SlstrPduStitcher.createStitchedSlstrL1BFile(this.targetDir, this.files, pm);
        }
        catch (Exception e) {
            throw new OperatorException(e.getMessage(), (Throwable)e);
        }
    }

    private static Set<File> getSourceProductsFileSet(Product[] sourceProducts) {
        TreeSet<File> sourceProductFileSet = new TreeSet<File>();
        if (sourceProducts != null) {
            for (Product sourceProduct : sourceProducts) {
                sourceProductFileSet.add(sourceProduct.getFileLocation());
            }
        }
        return sourceProductFileSet;
    }

    public static Set<File> getSourceProductsPathFileSet(String[] sourceProductPaths, Logger logger) {
        TreeSet<File> sourceProductFileSet = new TreeSet<File>();
        String[] paths = PDUStitchingOp.trimSourceProductPaths(sourceProductPaths);
        if (paths != null && paths.length != 0) {
            for (String path : paths) {
                try {
                    WildcardMatcher.glob((String)path, sourceProductFileSet);
                }
                catch (IOException e) {
                    logger.severe("I/O problem occurred while scanning source product files: " + e.getMessage());
                }
            }
            if (sourceProductFileSet.isEmpty()) {
                logger.log(Level.WARNING, "No valid source product path found.");
            }
        }
        return sourceProductFileSet;
    }

    private static String[] trimSourceProductPaths(String[] sourceProductPaths) {
        String[] paths = sourceProductPaths != null ? (String[])sourceProductPaths.clone() : null;
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = paths[i].trim();
            }
        }
        return paths;
    }

    private void setDummyTargetProduct() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        this.setTargetProduct(product);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PDUStitchingOp.class);
        }
    }
}

