/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.PixelQualitySummaryMerger;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PixelQualitySummaryMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:pixelQualitySummary grid=\"1 km\">\n              <slstr:cosmeticPixels value=\"261570\" percentage=\"12.000000\"/>\n              <slstr:duplicatedPixels value=\"101452\" percentage=\"4.000000\"/>\n              <slstr:saturatedPixels value=\"0\" percentage=\"0.000000\"/>\n              <slstr:outOfRangePixels value=\"0\" percentage=\"0.000000\"/>\n            </slstr:pixelQualitySummary>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:pixelQualitySummary grid=\"1 km\">\n              <slstr:cosmeticPixels value=\"256969\" percentage=\"11.000000\"/>\n              <slstr:duplicatedPixels value=\"102760\" percentage=\"4.000000\"/>\n              <slstr:saturatedPixels value=\"0\" percentage=\"0.000000\"/>\n              <slstr:outOfRangePixels value=\"0\" percentage=\"0.000000\"/>\n            </slstr:pixelQualitySummary>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:pixelQualitySummary grid=\"1 km\">\n              <slstr:cosmeticPixels value=\"33256\" percentage=\"3.000000\"/>\n              <slstr:duplicatedPixels value=\"49677\" percentage=\"4.000000\"/>\n              <slstr:saturatedPixels value=\"0\" percentage=\"0.000000\"/>\n              <slstr:outOfRangePixels value=\"0\" percentage=\"0.000000\"/>\n            </slstr:pixelQualitySummary>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("slstr:pixelQualitySummary");
        manifest.appendChild(manifestElement);
        new PixelQualitySummaryMerger().mergeNodes(fromParents, manifestElement, manifest);
        TestCase.assertEquals((int)1, (int)manifestElement.getAttributes().getLength());
        assert (manifestElement.hasAttribute("grid"));
        TestCase.assertEquals((String)"1 km", (String)manifestElement.getAttribute("grid"));
        NodeList childNodes = manifestElement.getChildNodes();
        TestCase.assertEquals((int)4, (int)childNodes.getLength());
        TestCase.assertEquals((String)"slstr:cosmeticPixels", (String)childNodes.item(0).getNodeName());
        TestCase.assertEquals((int)2, (int)childNodes.item(0).getAttributes().getLength());
        assert (childNodes.item(0) instanceof Element);
        assert (((Element)childNodes.item(0)).hasAttribute("value"));
        TestCase.assertEquals((String)"551795", (String)((Element)childNodes.item(0)).getAttribute("value"));
        assert (((Element)childNodes.item(0)).hasAttribute("percentage"));
        TestCase.assertEquals((String)"9.810798", (String)((Element)childNodes.item(0)).getAttribute("percentage"));
        TestCase.assertEquals((String)"slstr:duplicatedPixels", (String)childNodes.item(1).getNodeName());
        TestCase.assertEquals((int)2, (int)childNodes.item(1).getAttributes().getLength());
        assert (childNodes.item(1) instanceof Element);
        assert (((Element)childNodes.item(1)).hasAttribute("value"));
        TestCase.assertEquals((String)"253889", (String)((Element)childNodes.item(1)).getAttribute("value"));
        assert (((Element)childNodes.item(1)).hasAttribute("percentage"));
        TestCase.assertEquals((String)"4.000000", (String)((Element)childNodes.item(1)).getAttribute("percentage"));
        TestCase.assertEquals((String)"slstr:saturatedPixels", (String)childNodes.item(2).getNodeName());
        TestCase.assertEquals((int)2, (int)childNodes.item(2).getAttributes().getLength());
        assert (childNodes.item(2) instanceof Element);
        assert (((Element)childNodes.item(2)).hasAttribute("value"));
        TestCase.assertEquals((String)"0", (String)((Element)childNodes.item(2)).getAttribute("value"));
        assert (((Element)childNodes.item(2)).hasAttribute("percentage"));
        TestCase.assertEquals((String)"0.000000", (String)((Element)childNodes.item(2)).getAttribute("percentage"));
        TestCase.assertEquals((String)"slstr:outOfRangePixels", (String)childNodes.item(3).getNodeName());
        TestCase.assertEquals((int)2, (int)childNodes.item(2).getAttributes().getLength());
        assert (childNodes.item(3) instanceof Element);
        assert (((Element)childNodes.item(3)).hasAttribute("value"));
        TestCase.assertEquals((String)"0", (String)((Element)childNodes.item(3)).getAttribute("value"));
        assert (((Element)childNodes.item(3)).hasAttribute("percentage"));
        TestCase.assertEquals((String)"0.000000", (String)((Element)childNodes.item(3)).getAttribute("percentage"));
    }
}

