/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.MissingElementsMerger;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MissingElementsMergerTest {
    @Test
    public void mergeNodes_interrupted() throws ParserConfigurationException, SAXException, IOException, PDUStitchingException {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<slstr:missingElements threshold=\"75\">\n  <slstr:globalInfo grid=\"1 km\" view=\"Oblique\" value=\"77\" over=\"601\" percentage=\"12.81198\"/>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:22.192255Z\" stopTime=\"2017-10-18T01:25:24.592142Z\" percentage=\"10.482529\">\n     <slstr:bandSet>S8, F2</slstr:bandSet>\n  </slstr:elementMissing>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:34.592568Z\" stopTime=\"2017-10-18T01:25:35.292568Z\" percentage=\"2.329451\">\n     <slstr:bandSet>S8</slstr:bandSet>\n  </slstr:elementMissing>\n</slstr:missingElements>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<slstr:missingElements threshold=\"75\">\n  <slstr:globalInfo grid=\"1 km\" view=\"Oblique\" value=\"15\" over=\"575\" percentage=\"2.608696\"/>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:35.592568Z\" stopTime=\"2017-10-18T01:25:36.442568Z\" percentage=\"0.173913\">\n     <slstr:bandSet>S8</slstr:bandSet>\n  </slstr:elementMissing>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:36.942504Z\" stopTime=\"2017-10-18T01:25:38.142447Z\" percentage=\"0.869565\">\n     <slstr:bandSet>S8</slstr:bandSet>\n  </slstr:elementMissing>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:42.192255Z\" stopTime=\"2017-10-18T01:25:44.562142Z\" percentage=\"1.565217\">\n     <slstr:bandSet>S8, F2</slstr:bandSet>\n  </slstr:elementMissing>\n</slstr:missingElements>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<slstr:missingElements threshold=\"75\">\n  <slstr:globalInfo grid=\"1 km\" view=\"Oblique\" value=\"10\" over=\"575\" percentage=\"2.608696\"/>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:44.592142Z\" stopTime=\"2017-10-18T01:25:46.592142Z\" percentage=\"1.391304\">\n     <slstr:bandSet>S8, F2</slstr:bandSet>\n  </slstr:elementMissing>\n  <slstr:elementMissing grid=\"1 km\" view=\"Oblique\" startTime=\"2017-10-18T01:25:55.592568Z\" stopTime=\"2017-10-18T01:25:56.592568Z\" percentage=\"0.347826\">\n     <slstr:bandSet>F2</slstr:bandSet>\n  </slstr:elementMissing>\n</slstr:missingElements>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("slstr:missingElements");
        manifest.appendChild(manifestElement);
        new MissingElementsMerger().mergeNodes(fromParents, manifestElement, manifest);
        TestCase.assertEquals((int)1, (int)manifestElement.getAttributes().getLength());
        assert (manifestElement.hasAttribute("threshold"));
        TestCase.assertEquals((String)"75", (String)manifestElement.getAttribute("threshold"));
        NodeList childNodes = manifestElement.getChildNodes();
        TestCase.assertEquals((int)6, (int)childNodes.getLength());
        Node globalInfoNode = childNodes.item(0);
        TestCase.assertEquals((String)"slstr:globalInfo", (String)globalInfoNode.getNodeName());
        assert (globalInfoNode.hasAttributes());
        NamedNodeMap globalInfoNodeAttributes = globalInfoNode.getAttributes();
        TestCase.assertEquals((int)5, (int)globalInfoNodeAttributes.getLength());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("grid"));
        TestCase.assertEquals((String)"1 km", (String)globalInfoNodeAttributes.getNamedItem("grid").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("view"));
        TestCase.assertEquals((String)"Oblique", (String)globalInfoNodeAttributes.getNamedItem("view").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("value"));
        TestCase.assertEquals((String)"102", (String)globalInfoNodeAttributes.getNamedItem("value").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("over"));
        TestCase.assertEquals((String)"1751", (String)globalInfoNodeAttributes.getNamedItem("over").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("percentage"));
        TestCase.assertEquals((String)"5.825243", (String)globalInfoNodeAttributes.getNamedItem("percentage").getNodeValue());
        this.assertElement(childNodes.item(1), "1 km", "Oblique", "2017-10-18T01:25:22.192255Z", "2017-10-18T01:25:24.592142Z", "3.597944", "S8, F2");
        this.assertElement(childNodes.item(2), "1 km", "Oblique", "2017-10-18T01:25:34.592568Z", "2017-10-18T01:25:36.442568Z", "0.856653", "S8");
        this.assertElement(childNodes.item(3), "1 km", "Oblique", "2017-10-18T01:25:36.942504Z", "2017-10-18T01:25:38.142447Z", "0.285551", "S8");
        this.assertElement(childNodes.item(4), "1 km", "Oblique", "2017-10-18T01:25:42.192255Z", "2017-10-18T01:25:46.592142Z", "0.970874", "S8, F2");
        this.assertElement(childNodes.item(5), "1 km", "Oblique", "2017-10-18T01:25:55.592568Z", "2017-10-18T01:25:56.592568Z", "0.114220", "F2");
    }

    @Test
    public void mergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                      <slstr:missingElements threshold=\"75\">\n                        <slstr:globalInfo grid=\"0.5 km stripe A\" view=\"Nadir\" value=\"2396\" over=\"2396\" percentage=\"100.000000\"/>\n                        <slstr:elementMissing grid=\"0.5 km stripe A\" view=\"Nadir\" startTime=\"2016-04-19T12:09:27.150299Z\" stopTime=\"2016-04-19T12:12:26.841151Z\" percentage=\"100.000000\">\n                           <slstr:bandSet>S4</slstr:bandSet>\n                        </slstr:elementMissing>\n                     </slstr:missingElements>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                      <slstr:missingElements threshold=\"75\">\n                        <slstr:globalInfo grid=\"0.5 km stripe A\" view=\"Nadir\" value=\"2396\" over=\"2396\" percentage=\"100.000000\"/>\n                        <slstr:elementMissing grid=\"0.5 km stripe A\" view=\"Nadir\" startTime=\"2016-04-19T12:12:27.141133Z\" stopTime=\"2016-04-19T12:15:26.831968Z\" percentage=\"100.000000\">\n                           <slstr:bandSet>S4</slstr:bandSet>\n                        </slstr:elementMissing>\n                     </slstr:missingElements>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                      <slstr:missingElements threshold=\"75\">\n                        <slstr:globalInfo grid=\"0.5 km stripe A\" view=\"Nadir\" value=\"1948\" over=\"2400\" percentage=\"81.166664\"/>\n                        <slstr:elementMissing grid=\"0.5 km stripe A\" view=\"Nadir\" startTime=\"2016-04-19T12:15:27.131950Z\" stopTime=\"2016-04-19T12:17:53.224483Z\" percentage=\"81.166664\">\n                           <slstr:bandSet>S4</slstr:bandSet>\n                        </slstr:elementMissing>\n                     </slstr:missingElements>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("slstr:missingElements");
        manifest.appendChild(manifestElement);
        new MissingElementsMerger().mergeNodes(fromParents, manifestElement, manifest);
        TestCase.assertEquals((int)1, (int)manifestElement.getAttributes().getLength());
        assert (manifestElement.hasAttribute("threshold"));
        TestCase.assertEquals((String)"75", (String)manifestElement.getAttribute("threshold"));
        NodeList childNodes = manifestElement.getChildNodes();
        TestCase.assertEquals((int)2, (int)childNodes.getLength());
        Node globalInfoNode = childNodes.item(0);
        TestCase.assertEquals((String)"slstr:globalInfo", (String)globalInfoNode.getNodeName());
        assert (globalInfoNode.hasAttributes());
        NamedNodeMap globalInfoNodeAttributes = globalInfoNode.getAttributes();
        TestCase.assertEquals((int)5, (int)globalInfoNodeAttributes.getLength());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("grid"));
        TestCase.assertEquals((String)"0.5 km stripe A", (String)globalInfoNodeAttributes.getNamedItem("grid").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("view"));
        TestCase.assertEquals((String)"Nadir", (String)globalInfoNodeAttributes.getNamedItem("view").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("value"));
        TestCase.assertEquals((String)"6740", (String)globalInfoNodeAttributes.getNamedItem("value").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("over"));
        TestCase.assertEquals((String)"7192", (String)globalInfoNodeAttributes.getNamedItem("over").getNodeValue());
        TestCase.assertNotNull((Object)globalInfoNodeAttributes.getNamedItem("percentage"));
        TestCase.assertEquals((String)"93.715239", (String)globalInfoNodeAttributes.getNamedItem("percentage").getNodeValue());
        Node elementMissingNode = childNodes.item(1);
        this.assertElement(elementMissingNode, "0.5 km stripe A", "Nadir", "2016-04-19T12:09:27.150299Z", "2016-04-19T12:17:53.224483Z", "93.715239", "S4");
    }

    private void assertElement(Node elementMissingNode, String expectedGrid, String expectedView, String expectedStartTime, String expectedStopTime, String expectedPercentage, String expectedBandSet) {
        TestCase.assertEquals((String)"slstr:elementMissing", (String)elementMissingNode.getNodeName());
        assert (elementMissingNode.hasAttributes());
        NamedNodeMap elementMissingNodeAttributes = elementMissingNode.getAttributes();
        TestCase.assertEquals((int)5, (int)elementMissingNodeAttributes.getLength());
        TestCase.assertNotNull((Object)elementMissingNodeAttributes.getNamedItem("grid"));
        TestCase.assertEquals((String)expectedGrid, (String)elementMissingNodeAttributes.getNamedItem("grid").getNodeValue());
        TestCase.assertNotNull((Object)elementMissingNodeAttributes.getNamedItem("view"));
        TestCase.assertEquals((String)expectedView, (String)elementMissingNodeAttributes.getNamedItem("view").getNodeValue());
        TestCase.assertNotNull((Object)elementMissingNodeAttributes.getNamedItem("startTime"));
        TestCase.assertEquals((String)expectedStartTime, (String)elementMissingNodeAttributes.getNamedItem("startTime").getNodeValue());
        TestCase.assertNotNull((Object)elementMissingNodeAttributes.getNamedItem("stopTime"));
        TestCase.assertEquals((String)expectedStopTime, (String)elementMissingNodeAttributes.getNamedItem("stopTime").getNodeValue());
        TestCase.assertNotNull((Object)elementMissingNodeAttributes.getNamedItem("percentage"));
        TestCase.assertEquals((String)expectedPercentage, (String)elementMissingNodeAttributes.getNamedItem("percentage").getNodeValue());
        NodeList elementMissingNodeChildNodes = elementMissingNode.getChildNodes();
        TestCase.assertEquals((int)1, (int)elementMissingNodeChildNodes.getLength());
        Node bandSetNode = elementMissingNodeChildNodes.item(0);
        TestCase.assertEquals((String)"slstr:bandSet", (String)bandSetNode.getNodeName());
        TestCase.assertEquals((int)0, (int)bandSetNode.getAttributes().getLength());
        TestCase.assertEquals((int)1, (int)bandSetNode.getChildNodes().getLength());
        TestCase.assertEquals((String)expectedBandSet, (String)bandSetNode.getFirstChild().getNodeValue());
        TestCase.assertEquals((String)expectedBandSet, (String)bandSetNode.getTextContent());
    }
}

