/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ImageSizesMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageSizesMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:nadirImageSize grid=\"Tie Points\">\n              <sentinel3:startOffset>21687</sentinel3:startOffset>\n              <sentinel3:trackOffset>64</sentinel3:trackOffset>\n              <sentinel3:rows>2000</sentinel3:rows>\n              <sentinel3:columns>130</sentinel3:columns>\n            </slstr:nadirImageSize>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                        <slstr:nadirImageSize grid=\"Tie Points\">\n                            <sentinel3:startOffset>23687</sentinel3:startOffset>\n                            <sentinel3:trackOffset>64</sentinel3:trackOffset>\n                            <sentinel3:rows>2000</sentinel3:rows>\n                            <sentinel3:columns>130</sentinel3:columns>\n                        </slstr:nadirImageSize>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n        <slstr:nadirImageSize grid=\"Tie Points\">\n        <sentinel3:startOffset>25687</sentinel3:startOffset>\n        <sentinel3:trackOffset>64</sentinel3:trackOffset>\n        <sentinel3:rows>2000</sentinel3:rows>\n        <sentinel3:columns>130</sentinel3:columns>\n        </slstr:nadirImageSize>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("slstr:nadirImageSize");
        manifest.appendChild(manifestElement);
        new ImageSizesMerger().mergeNodes(fromParents, manifestElement, manifest);
        TestCase.assertEquals((int)1, (int)manifestElement.getAttributes().getLength());
        assert (manifestElement.hasAttribute("grid"));
        TestCase.assertEquals((String)"Tie Points", (String)manifestElement.getAttribute("grid"));
        NodeList childNodes = manifestElement.getChildNodes();
        TestCase.assertEquals((int)4, (int)childNodes.getLength());
        TestCase.assertEquals((String)"sentinel3:startOffset", (String)childNodes.item(0).getNodeName());
        TestCase.assertEquals((String)"21687", (String)childNodes.item(0).getFirstChild().getNodeValue());
        TestCase.assertEquals((String)"sentinel3:trackOffset", (String)childNodes.item(1).getNodeName());
        TestCase.assertEquals((String)"64", (String)childNodes.item(1).getFirstChild().getNodeValue());
        TestCase.assertEquals((String)"sentinel3:rows", (String)childNodes.item(2).getNodeName());
        TestCase.assertEquals((String)"6000", (String)childNodes.item(2).getFirstChild().getNodeValue());
        TestCase.assertEquals((String)"sentinel3:columns", (String)childNodes.item(3).getNodeName());
        TestCase.assertEquals((String)"130", (String)childNodes.item(3).getFirstChild().getNodeValue());
    }
}

