/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.FootprintMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FootprintMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel-safe:footPrint srsName=\"http://www.opengis.net/def/crs/EPSG/0/4326\">\n              <gml:posList>45.5154 -87.5954 43.7689 -87.8511 42.0217 -88.1109 40.2738 -88.375 38.5253 -88.6431 36.7761 -88.9153 35.0263 -89.1916 33.2759 -89.4719 31.525 -89.7564 29.7735 -90.0451 28.0304 -90.3366 27.761 -88.4102 27.4648 -86.4938 27.1425 -84.5879 26.7944 -82.6935 26.4212 -80.8109 26.0233 -78.9409 25.6013 -77.0837 25.1559 -75.24 24.6877 -73.4099 24.1973 -71.5937 23.8153 -70.2409 25.5389 -69.6432 27.2588 -69.0219 28.9746 -68.3749 30.686 -67.7003 32.3925 -66.9955 34.0937 -66.2579 35.7889 -65.4847 37.4776 -64.6724 39.1592 -63.8174 40.8246 -62.92 41.4768 -65.0384 42.0891 -67.1983 42.66 -69.3987 43.1878 -71.6382 43.6709 -73.915 44.108 -76.2268 44.4976 -78.571 44.8384 -80.9447 45.1293 -83.3445 45.3693 -85.7666 45.5154 -87.5954</gml:posList>\n            </sentinel-safe:footPrint>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                        <sentinel-safe:footPrint srsName=\"http://www.opengis.net/def/crs/EPSG/0/4326\">\n                            <gml:posList>28.0216 -90.3381 26.2692 -90.6355 24.5165 -90.9374 22.7634 -91.2439 21.01 -91.5553 19.2564 -91.8716 17.5027 -92.1931 15.7489 -92.52 13.995 -92.8525 12.2413 -93.1909 10.4965 -93.5337 10.1579 -91.8143 9.8103 -90.0987 9.45406 -88.3867 9.0895 -86.6782 8.71695 -84.9732 8.33675 -83.2716 7.94927 -81.5733 7.55485 -79.8783 7.15384 -78.1863 6.74662 -76.4973 6.43734 -75.2325 8.18338 -74.7973 9.92809 -74.3502 11.6713 -73.8907 13.4129 -73.4177 15.1526 -72.9304 16.8902 -72.4277 18.6255 -71.9087 20.3583 -71.3722 22.0884 -70.8167 23.8067 -70.2438 24.3132 -72.0493 24.7981 -73.8688 25.2606 -75.7022 25.7002 -77.5493 26.1162 -79.4095 26.508 -81.2826 26.875 -83.168 27.2167 -85.0653 27.5325 -86.9737 27.822 -88.8925 28.0216 -90.3381</gml:posList>\n                        </sentinel-safe:footPrint>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel-safe:footPrint srsName=\"http://www.opengis.net/def/crs/EPSG/0/4326\">\n              <gml:posList>10.4877 -93.5354 8.73433 -93.8863 6.98131 -94.2441 5.22872 -94.6089 3.47666 -94.9812 1.72525 -95.3614 -0.0253962 -95.7499 -1.77517 -96.1472 -3.52393 -96.5539 -5.27155 -96.9704 -7.00916 -97.3953 -7.4229 -95.7069 -7.83021 -94.0154 -8.2307 -92.3206 -8.62401 -90.6225 -9.00979 -88.9209 -9.38767 -87.2157 -9.75731 -85.5068 -10.1184 -83.7943 -10.4705 -82.0779 -10.8133 -80.3577 -11.0642 -79.065 -9.31249 -78.7172 -7.56084 -78.3625 -5.80935 -78.0007 -4.05812 -77.6313 -2.30726 -77.254 -0.556876 -76.8684 1.19291 -76.474 2.94196 -76.0702 4.69016 -75.6566 6.42861 -75.2346 6.84022 -76.9214 7.24588 -78.6111 7.64525 -80.3038 8.03795 -81.9996 8.42364 -83.6987 8.80195 -85.4011 9.17254 -87.1069 9.53507 -88.8162 9.8892 -90.5291 10.2346 -92.2456 10.4877 -93.5354</gml:posList>\n            </sentinel-safe:footPrint>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("sentinel-safe:footprint");
        manifest.appendChild(manifestElement);
        new FootprintMerger(new File(FootprintMergerTest.class.getResource("").getFile())).mergeNodes(fromParents, manifestElement, manifest);
        NodeList manifestElementChildNodes = manifestElement.getChildNodes();
        Assert.assertEquals((long)1L, (long)manifestElementChildNodes.getLength());
        Node posListNode = manifestElementChildNodes.item(0);
        Assert.assertEquals((Object)"gml:posList", (Object)posListNode.getNodeName());
        Assert.assertEquals((Object)"45.5154 -87.5954 43.7689 -87.8511 42.0217 -88.1109 40.2738 -88.3750 38.5253 -88.6431 36.7761 -88.9153 35.0263 -89.1916 33.2759 -89.4719 31.5250 -89.7564 29.7735 -90.0451 28.0304 -90.3366 27.7610 -88.4102 27.4648 -86.4938 27.1425 -84.5879 26.7944 -82.6935 26.4212 -80.8109 26.0233 -78.9409 25.6013 -77.0837 25.1559 -75.2400 24.6877 -73.4099 24.1973 -71.5937 23.8153 -70.2409 25.5303 -69.6463 27.2502 -69.0250 28.9661 -68.3783 30.6775 -67.7037 32.3840 -66.9991 34.0852 -66.2617 35.7804 -65.4887 37.4692 -64.6765 39.1509 -63.8218 40.8246 -62.9200 41.3174 -64.5048 41.9399 -66.6545 42.5213 -68.8449 43.0600 -71.0748 43.5544 -73.3424 44.0031 -75.6457 44.4047 -77.9821 44.7578 -80.3487 45.0613 -82.7423 45.3142 -85.1592 45.5154 -87.5954", (Object)posListNode.getTextContent());
    }

    @Test
    public void testMergeNodes_NoNcFile() throws ParserConfigurationException, SAXException, IOException, PDUStitchingException {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel-safe:footPrint srsName=\"http://www.opengis.net/def/crs/EPSG/0/4326\">\n              <gml:posList>45.5154 -87.5954 43.7689 -87.8511 42.0217 -88.1109 40.2738 -88.375 38.5253 -88.6431 36.7761 -88.9153 35.0263 -89.1916 33.2759 -89.4719 31.525 -89.7564 29.7735 -90.0451 28.0304 -90.3366 27.761 -88.4102 27.4648 -86.4938 27.1425 -84.5879 26.7944 -82.6935 26.4212 -80.8109 26.0233 -78.9409 25.6013 -77.0837 25.1559 -75.24 24.6877 -73.4099 24.1973 -71.5937 23.8153 -70.2409 25.5389 -69.6432 27.2588 -69.0219 28.9746 -68.3749 30.686 -67.7003 32.3925 -66.9955 34.0937 -66.2579 35.7889 -65.4847 37.4776 -64.6724 39.1592 -63.8174 40.8246 -62.92 41.4768 -65.0384 42.0891 -67.1983 42.66 -69.3987 43.1878 -71.6382 43.6709 -73.915 44.108 -76.2268 44.4976 -78.571 44.8384 -80.9447 45.1293 -83.3445 45.3693 -85.7666 45.5154 -87.5954</gml:posList>\n            </sentinel-safe:footPrint>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                        <sentinel-safe:footPrint srsName=\"http://www.opengis.net/def/crs/EPSG/0/4326\">\n                            <gml:posList>28.0216 -90.3381 26.2692 -90.6355 24.5165 -90.9374 22.7634 -91.2439 21.01 -91.5553 19.2564 -91.8716 17.5027 -92.1931 15.7489 -92.52 13.995 -92.8525 12.2413 -93.1909 10.4965 -93.5337 10.1579 -91.8143 9.8103 -90.0987 9.45406 -88.3867 9.0895 -86.6782 8.71695 -84.9732 8.33675 -83.2716 7.94927 -81.5733 7.55485 -79.8783 7.15384 -78.1863 6.74662 -76.4973 6.43734 -75.2325 8.18338 -74.7973 9.92809 -74.3502 11.6713 -73.8907 13.4129 -73.4177 15.1526 -72.9304 16.8902 -72.4277 18.6255 -71.9087 20.3583 -71.3722 22.0884 -70.8167 23.8067 -70.2438 24.3132 -72.0493 24.7981 -73.8688 25.2606 -75.7022 25.7002 -77.5493 26.1162 -79.4095 26.508 -81.2826 26.875 -83.168 27.2167 -85.0653 27.5325 -86.9737 27.822 -88.8925 28.0216 -90.3381</gml:posList>\n                        </sentinel-safe:footPrint>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel-safe:footPrint srsName=\"http://www.opengis.net/def/crs/EPSG/0/4326\">\n              <gml:posList>10.4877 -93.5354 8.73433 -93.8863 6.98131 -94.2441 5.22872 -94.6089 3.47666 -94.9812 1.72525 -95.3614 -0.0253962 -95.7499 -1.77517 -96.1472 -3.52393 -96.5539 -5.27155 -96.9704 -7.00916 -97.3953 -7.4229 -95.7069 -7.83021 -94.0154 -8.2307 -92.3206 -8.62401 -90.6225 -9.00979 -88.9209 -9.38767 -87.2157 -9.75731 -85.5068 -10.1184 -83.7943 -10.4705 -82.0779 -10.8133 -80.3577 -11.0642 -79.065 -9.31249 -78.7172 -7.56084 -78.3625 -5.80935 -78.0007 -4.05812 -77.6313 -2.30726 -77.254 -0.556876 -76.8684 1.19291 -76.474 2.94196 -76.0702 4.69016 -75.6566 6.42861 -75.2346 6.84022 -76.9214 7.24588 -78.6111 7.64525 -80.3038 8.03795 -81.9996 8.42364 -83.6987 8.80195 -85.4011 9.17254 -87.1069 9.53507 -88.8162 9.8892 -90.5291 10.2346 -92.2456 10.4877 -93.5354</gml:posList>\n            </sentinel-safe:footPrint>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("sentinel-safe:footprint");
        manifest.appendChild(manifestElement);
        new FootprintMerger(new File(FootprintMergerTest.class.getResource("../").getFile())).mergeNodes(fromParents, manifestElement, manifest);
        NodeList manifestElementChildNodes = manifestElement.getChildNodes();
        Assert.assertEquals((long)1L, (long)manifestElementChildNodes.getLength());
        Node posListNode = manifestElementChildNodes.item(0);
        Assert.assertEquals((Object)"gml:posList", (Object)posListNode.getNodeName());
        Assert.assertEquals((Object)"45.5154 -87.5954 43.7689 -87.8511 42.0217 -88.1109 40.2738 -88.375 38.5253 -88.6431 36.7761 -88.9153 35.0263 -89.1916 33.2759 -89.4719 31.525 -89.7564 29.7735 -90.0451 28.0304 -90.3366 27.761 -88.4102 27.4648 -86.4938 27.1425 -84.5879 26.7944 -82.6935 26.4212 -80.8109 26.0233 -78.9409 25.6013 -77.0837 25.1559 -75.24 24.6877 -73.4099 24.1973 -71.5937 23.8153 -70.2409 25.5389 -69.6432 27.2588 -69.0219 28.9746 -68.3749 30.686 -67.7003 32.3925 -66.9955 34.0937 -66.2579 35.7889 -65.4847 37.4776 -64.6724 39.1592 -63.8174 40.8246 -62.92 41.4768 -65.0384 42.0891 -67.1983 42.66 -69.3987 43.1878 -71.6382 43.6709 -73.915 44.108 -76.2268 44.4976 -78.571 44.8384 -80.9447 45.1293 -83.3445 45.3693 -85.7666 45.5154 -87.5954 28.0216 -90.3381 26.2692 -90.6355 24.5165 -90.9374 22.7634 -91.2439 21.01 -91.5553 19.2564 -91.8716 17.5027 -92.1931 15.7489 -92.52 13.995 -92.8525 12.2413 -93.1909 10.4965 -93.5337 10.1579 -91.8143 9.8103 -90.0987 9.45406 -88.3867 9.0895 -86.6782 8.71695 -84.9732 8.33675 -83.2716 7.94927 -81.5733 7.55485 -79.8783 7.15384 -78.1863 6.74662 -76.4973 6.43734 -75.2325 8.18338 -74.7973 9.92809 -74.3502 11.6713 -73.8907 13.4129 -73.4177 15.1526 -72.9304 16.8902 -72.4277 18.6255 -71.9087 20.3583 -71.3722 22.0884 -70.8167 23.8067 -70.2438 24.3132 -72.0493 24.7981 -73.8688 25.2606 -75.7022 25.7002 -77.5493 26.1162 -79.4095 26.508 -81.2826 26.875 -83.168 27.2167 -85.0653 27.5325 -86.9737 27.822 -88.8925 28.0216 -90.3381 10.4877 -93.5354 8.73433 -93.8863 6.98131 -94.2441 5.22872 -94.6089 3.47666 -94.9812 1.72525 -95.3614 -0.0253962 -95.7499 -1.77517 -96.1472 -3.52393 -96.5539 -5.27155 -96.9704 -7.00916 -97.3953 -7.4229 -95.7069 -7.83021 -94.0154 -8.2307 -92.3206 -8.62401 -90.6225 -9.00979 -88.9209 -9.38767 -87.2157 -9.75731 -85.5068 -10.1184 -83.7943 -10.4705 -82.0779 -10.8133 -80.3577 -11.0642 -79.065 -9.31249 -78.7172 -7.56084 -78.3625 -5.80935 -78.0007 -4.05812 -77.6313 -2.30726 -77.254 -0.556876 -76.8684 1.19291 -76.474 2.94196 -76.0702 4.69016 -75.6566 6.42861 -75.2346 6.84022 -76.9214 7.24588 -78.6111 7.64525 -80.3038 8.03795 -81.9996 8.42364 -83.6987 8.80195 -85.4011 9.17254 -87.1069 9.53507 -88.8162 9.8892 -90.5291 10.2346 -92.2456 10.4877 -93.5354", (Object)posListNode.getTextContent());
    }
}

