/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.DumpInformationMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DumpInformationMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel3:dumpInformation>\n              <sentinel3:granuleNumber>4</sentinel3:granuleNumber>\n              <sentinel3:granulePosition>NONE</sentinel3:granulePosition>\n              <sentinel3:dumpStart>2013-07-07T15:12:52.000000Z</sentinel3:dumpStart>\n              <sentinel3:receivingGroundStation>CGS</sentinel3:receivingGroundStation>\n              <sentinel3:receivingStartTime>2015-02-17T18:26:57.418621Z</sentinel3:receivingStartTime>\n              <sentinel3:receivingStopTime>2015-02-17T18:27:10.880813Z</sentinel3:receivingStopTime>\n            </sentinel3:dumpInformation>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                        <sentinel3:dumpInformation>\n                            <sentinel3:granuleNumber>5</sentinel3:granuleNumber>\n                            <sentinel3:granulePosition>NONE</sentinel3:granulePosition>\n                            <sentinel3:dumpStart>2013-07-07T15:12:52.000000Z</sentinel3:dumpStart>\n                            <sentinel3:receivingGroundStation>CGS</sentinel3:receivingGroundStation>\n                            <sentinel3:receivingStartTime>2015-02-17T18:27:10.909138Z</sentinel3:receivingStartTime>\n                            <sentinel3:receivingStopTime>2015-02-17T18:27:24.371332Z</sentinel3:receivingStopTime>\n                        </sentinel3:dumpInformation>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <sentinel3:dumpInformation>\n              <sentinel3:granuleNumber>6</sentinel3:granuleNumber>\n              <sentinel3:granulePosition>NONE</sentinel3:granulePosition>\n              <sentinel3:dumpStart>2013-07-07T15:12:52.000000Z</sentinel3:dumpStart>\n              <sentinel3:receivingGroundStation>CGS</sentinel3:receivingGroundStation>\n              <sentinel3:receivingStartTime>2015-02-17T18:27:24.399655Z</sentinel3:receivingStartTime>\n              <sentinel3:receivingStopTime>2015-02-17T18:27:37.861849Z</sentinel3:receivingStopTime>\n            </sentinel3:dumpInformation>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element parentElement = manifest.createElement("parent");
        Element manifestElement = manifest.createElement("sentinel3:dumpInformation");
        parentElement.appendChild(manifestElement);
        manifest.appendChild(parentElement);
        new DumpInformationMerger().mergeNodes(fromParents, manifestElement, manifest);
        NodeList manifestChildNodes = parentElement.getChildNodes();
        TestCase.assertEquals((int)3, (int)manifestChildNodes.getLength());
        for (int i = 0; i < fromParents.size(); ++i) {
            this.assertEqualsElement((Node)fromParents.get(i), manifestChildNodes.item(i));
        }
    }

    private void assertEqualsElement(Node expected, Node actual) {
        TestCase.assertEquals((String)expected.getNodeName(), (String)actual.getNodeName());
        TestCase.assertEquals((int)0, (int)actual.getAttributes().getLength());
        NodeList expectedChildNodes = expected.getChildNodes();
        NodeList actualChildNodes = actual.getChildNodes();
        TestCase.assertEquals((int)6, (int)actualChildNodes.getLength());
        for (int i = 0; i < actualChildNodes.getLength(); ++i) {
            Node expectedItem = expectedChildNodes.item(2 * i + 1);
            Node actualItem = actualChildNodes.item(i);
            TestCase.assertEquals((String)expectedItem.getNodeName(), (String)actualItem.getNodeName());
            TestCase.assertEquals((String)expectedItem.getTextContent(), (String)actualItem.getTextContent());
            TestCase.assertEquals((int)0, (int)actualItem.getAttributes().getLength());
        }
    }
}

