/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Assert;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.DataObjectMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataObjectMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n      <dataObject ID=\"ADFData\">\n          <byteStream mimeType=\"application/x-netcdf\" size=\"36985\">\n              <fileLocation locatorType=\"URL\" href=\"viscal.nc\"/>\n              <checksum checksumName=\"MD5\">9c0ed7a6a15d3bfebbeb1609a8d41fa0</checksum>\n          </byteStream>\n      </dataObject>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n        <dataObject ID=\"ADFData\">\n            <byteStream mimeType=\"application/x-netcdf\" size=\"36985\">\n                <fileLocation locatorType=\"URL\" href=\"viscal.nc\"/>\n                <checksum checksumName=\"MD5\">bd2e513c1fc816c899fe5b3130846bdd</checksum>\n            </byteStream>\n        </dataObject>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n    <dataObject ID=\"ADFData\">\n      <byteStream mimeType=\"application/x-netcdf\" size=\"36985\">\n        <fileLocation locatorType=\"URL\" href=\"viscal.nc\"/>\n        <checksum checksumName=\"MD5\">b12d0db5bbfdc22ea728219511894868</checksum>\n      </byteStream>\n    </dataObject>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("dataObject");
        manifestElement.setAttribute("ID", "test");
        manifest.appendChild(manifestElement);
        DataObjectMerger dataObjectMerger = new DataObjectMerger(DataObjectMergerTest.class.getResource("").getFile());
        dataObjectMerger.mergeNodes(fromParents, manifestElement, manifest);
        NodeList manifestChilds = manifestElement.getChildNodes();
        Assert.assertEquals((int)1, (int)manifestChilds.getLength());
        Node byteStreamElement = manifestChilds.item(0);
        Assert.assertEquals((String)"byteStream", (String)byteStreamElement.getNodeName());
        NamedNodeMap byteStreamElementAttributes = byteStreamElement.getAttributes();
        Assert.assertEquals((int)2, (int)byteStreamElementAttributes.getLength());
        Node mimeTypeAttribute = byteStreamElementAttributes.getNamedItem("mimeType");
        Assert.assertNotNull((Object)mimeTypeAttribute);
        Assert.assertEquals((String)"application/x-netcdf", (String)mimeTypeAttribute.getNodeValue());
        Node sizeAttribute = byteStreamElementAttributes.getNamedItem("size");
        Assert.assertNotNull((Object)sizeAttribute);
        Assert.assertEquals((String)"30", (String)sizeAttribute.getNodeValue());
        NodeList byteStreamChildren = byteStreamElement.getChildNodes();
        Assert.assertEquals((int)2, (int)byteStreamChildren.getLength());
        Node fileLocationElement = byteStreamChildren.item(0);
        Assert.assertEquals((String)"fileLocation", (String)fileLocationElement.getNodeName());
        NamedNodeMap fileLocationElementAttributes = fileLocationElement.getAttributes();
        Assert.assertEquals((int)2, (int)fileLocationElementAttributes.getLength());
        Node locatorTypeAttribute = fileLocationElementAttributes.getNamedItem("locatorType");
        Assert.assertNotNull((Object)locatorTypeAttribute);
        Assert.assertEquals((String)"URL", (String)locatorTypeAttribute.getNodeValue());
        Node hrefAttribute = fileLocationElementAttributes.getNamedItem("href");
        Assert.assertNotNull((Object)hrefAttribute);
        Assert.assertEquals((String)"viscal.nc", (String)hrefAttribute.getNodeValue());
        Node checksumElement = byteStreamChildren.item(1);
        Assert.assertEquals((String)"checksum", (String)checksumElement.getNodeName());
        NamedNodeMap checksumElementAttributes = checksumElement.getAttributes();
        Assert.assertEquals((int)1, (int)checksumElementAttributes.getLength());
        Node checksumNameAttribute = checksumElementAttributes.getNamedItem("checksumName");
        Assert.assertNotNull((Object)checksumNameAttribute);
        Assert.assertEquals((String)"MD5", (String)checksumNameAttribute.getNodeValue());
        Assert.assertEquals((String)"97b5dcca12501c1f051186b9d8755373", (String)checksumElement.getTextContent());
    }

    @Test
    public void testGetChecksum() {
        File file = new File(DataObjectMergerTest.class.getResource("justSomeDummyFileForCreatingAChecksum").getFile());
        String checksum = DataObjectMerger.getChecksum((File)file);
        Assert.assertEquals((String)"e40ee529b406f33efb8f53ee5e26bcbf", (String)checksum);
    }

    @Test
    @Ignore
    public void testGetChecksum_speedTest() {
        File file = new File(DataObjectMergerTest.class.getResource("justSomeDummyFileForCreatingAChecksum").getFile());
        long total = 0L;
        for (int i = 0; i < 100; ++i) {
            long start = System.currentTimeMillis();
            String checksum = DataObjectMerger.getChecksum((File)file);
            long end = System.currentTimeMillis();
            total += end - start;
        }
        System.out.println("1: " + (double)total / 100.0 + " ms");
    }

    @Test
    public void testGetChecksum_NotWorking() {
        String checksum = DataObjectMerger.getChecksum((File)new File(""));
        Assert.assertEquals((String)"", (String)checksum);
    }
}

