/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ClassificationSummaryMerger;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.ManifestTestUtils;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassificationSummaryMergerTest {
    @Test
    public void testMergeNodes() throws Exception {
        ArrayList<Node> fromParents = new ArrayList<Node>();
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:classificationSummary grid=\"1 km\">\n              <sentinel3:salineWaterPixels percentage=\"29.595219\"/>\n              <sentinel3:landPixels percentage=\"47.091896\"/>\n              <sentinel3:coastalPixels percentage=\"0.465542\"/>\n              <sentinel3:freshInlandWaterPixels percentage=\"3.184458\"/>\n              <sentinel3:tidalRegionPixels percentage=\"1.462398\"/>\n              <sentinel3:cloudyPixels percentage=\"42.695602\"/>\n            </slstr:classificationSummary>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:classificationSummary grid=\"1 km\">\n                <sentinel3:salineWaterPixels percentage=\"57.154091\"/>\n                <sentinel3:landPixels percentage=\"19.533026\"/>\n                <sentinel3:coastalPixels percentage=\"0.548977\"/>\n                <sentinel3:freshInlandWaterPixels percentage=\"0.418456\"/>\n                <sentinel3:tidalRegionPixels percentage=\"7.769990\"/>\n                <sentinel3:cloudyPixels percentage=\"47.409790\"/>\n            </slstr:classificationSummary>").getFirstChild());
        fromParents.add(ManifestTestUtils.createNode("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <slstr:classificationSummary grid=\"1 km\">\n              <sentinel3:salineWaterPixels percentage=\"76.334869\"/>\n              <sentinel3:landPixels percentage=\"0.352250\"/>\n              <sentinel3:coastalPixels percentage=\"0.041999\"/>\n              <sentinel3:freshInlandWaterPixels percentage=\"0.000383\"/>\n              <sentinel3:tidalRegionPixels percentage=\"41.587013\"/>\n              <sentinel3:cloudyPixels percentage=\"46.897827\"/>\n            </slstr:classificationSummary>").getFirstChild());
        Document manifest = ManifestTestUtils.createDocument();
        Element manifestElement = manifest.createElement("slstr:classificationSummary");
        manifest.appendChild(manifestElement);
        ImageSize[][] imageSizes = new ImageSize[fromParents.size()][];
        for (int i = 0; i < fromParents.size(); ++i) {
            ImageSize[] pduImageSizes = new ImageSize[4];
            pduImageSizes[0] = new ImageSize("in", 0, 0, 2, 2);
            pduImageSizes[1] = new ImageSize("io", 1, 1, 3, 3);
            pduImageSizes[1] = new ImageSize("an", 1, 1, 5, 4);
            pduImageSizes[1] = new ImageSize("ao", 1, 1, 2, 6);
            imageSizes[i] = pduImageSizes;
        }
        new ClassificationSummaryMerger((ImageSize[][])imageSizes).mergeNodes(fromParents, manifestElement, manifest);
        NodeList childNodes = manifestElement.getChildNodes();
        TestCase.assertEquals((int)6, (int)childNodes.getLength());
        TestCase.assertEquals((String)"sentinel3:salineWaterPixels", (String)childNodes.item(0).getNodeName());
        NamedNodeMap salineWaterAttributes = childNodes.item(0).getAttributes();
        TestCase.assertEquals((int)1, (int)salineWaterAttributes.getLength());
        Node salinePercentage = salineWaterAttributes.getNamedItem("percentage");
        Assert.assertNotNull((Object)salinePercentage);
        TestCase.assertEquals((double)54.361393, (double)Double.parseDouble(salinePercentage.getNodeValue()), (double)1.0E-8);
        TestCase.assertEquals((String)"", (String)childNodes.item(0).getTextContent());
        TestCase.assertEquals((String)"sentinel3:landPixels", (String)childNodes.item(1).getNodeName());
        NamedNodeMap landPixelsAttributes = childNodes.item(1).getAttributes();
        TestCase.assertEquals((int)1, (int)landPixelsAttributes.getLength());
        Node landPercentage = landPixelsAttributes.getNamedItem("percentage");
        Assert.assertNotNull((Object)landPercentage);
        TestCase.assertEquals((double)22.325724, (double)Double.parseDouble(landPercentage.getNodeValue()), (double)1.0E-8);
        TestCase.assertEquals((String)"", (String)childNodes.item(1).getTextContent());
        TestCase.assertEquals((String)"sentinel3:coastalPixels", (String)childNodes.item(2).getNodeName());
        NamedNodeMap coastalPixelsAttributes = childNodes.item(2).getAttributes();
        TestCase.assertEquals((int)1, (int)coastalPixelsAttributes.getLength());
        Node coastalPercentage = coastalPixelsAttributes.getNamedItem("percentage");
        Assert.assertNotNull((Object)coastalPercentage);
        TestCase.assertEquals((double)0.352172666, (double)Double.parseDouble(coastalPercentage.getNodeValue()), (double)1.0E-8);
        TestCase.assertEquals((String)"", (String)childNodes.item(2).getTextContent());
        TestCase.assertEquals((String)"sentinel3:freshInlandWaterPixels", (String)childNodes.item(3).getNodeName());
        NamedNodeMap freshInlandWaterPixelsAttributes = childNodes.item(3).getAttributes();
        TestCase.assertEquals((int)1, (int)freshInlandWaterPixelsAttributes.getLength());
        Node freshInlandWaterPixelsPercentage = freshInlandWaterPixelsAttributes.getNamedItem("percentage");
        Assert.assertNotNull((Object)freshInlandWaterPixelsPercentage);
        TestCase.assertEquals((double)1.201099, (double)Double.parseDouble(freshInlandWaterPixelsPercentage.getNodeValue()), (double)1.0E-8);
        TestCase.assertEquals((String)"", (String)childNodes.item(3).getTextContent());
        TestCase.assertEquals((String)"sentinel3:tidalRegionPixels", (String)childNodes.item(4).getNodeName());
        NamedNodeMap tidalRegionPixelsAttributes = childNodes.item(4).getAttributes();
        TestCase.assertEquals((int)1, (int)tidalRegionPixelsAttributes.getLength());
        Node tidalRegionPixelsPercentage = tidalRegionPixelsAttributes.getNamedItem("percentage");
        Assert.assertNotNull((Object)tidalRegionPixelsPercentage);
        TestCase.assertEquals((double)16.93980033, (double)Double.parseDouble(tidalRegionPixelsPercentage.getNodeValue()), (double)1.0E-8);
        TestCase.assertEquals((String)"", (String)childNodes.item(4).getTextContent());
        TestCase.assertEquals((String)"sentinel3:cloudyPixels", (String)childNodes.item(5).getNodeName());
        NamedNodeMap cloudyPixelsAttributes = childNodes.item(5).getAttributes();
        TestCase.assertEquals((int)1, (int)cloudyPixelsAttributes.getLength());
        Node cloudyPixelsPercentage = cloudyPixelsAttributes.getNamedItem("percentage");
        Assert.assertNotNull((Object)cloudyPixelsPercentage);
        TestCase.assertEquals((double)45.66773966, (double)Double.parseDouble(cloudyPixelsPercentage.getNodeValue()), (double)1.0E-8);
        TestCase.assertEquals((String)"", (String)childNodes.item(5).getTextContent());
    }
}

