/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrPduStitcher;
import org.esa.s3tbx.slstr.pdu.stitching.TestUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SlstrPduStitcherTest {
    private File targetDirectory;

    @Before
    public void setUp() {
        this.targetDirectory = new File("test_out");
        if (!this.targetDirectory.mkdirs()) {
            Assert.fail((String)"Unable to create test target directory");
        }
    }

    @After
    public void tearDown() {
        if (this.targetDirectory.isDirectory() && !FileUtils.deleteTree((File)this.targetDirectory)) {
            Assert.fail((String)"Unable to delete test directory");
        }
    }

    @Test
    public void testStitchPDUs_NotEmpty() throws Exception {
        try {
            SlstrPduStitcher.createStitchedSlstrL1BFile((File)this.targetDirectory, (File[])new File[0], (ProgressMonitor)ProgressMonitor.NULL);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            TestCase.assertEquals((String)"No product files provided", (String)e.getMessage());
        }
    }

    @Test
    public void testStitchPDUs_OnlyOneSlstrL1BProductFile() throws Exception {
        File firstSlstrFile = TestUtils.getFirstSlstrFile();
        File stitchedProductFile = SlstrPduStitcher.createStitchedSlstrL1BFile((File)this.targetDirectory, (File[])new File[]{firstSlstrFile}, (ProgressMonitor)ProgressMonitor.NULL);
        File slstrFileParentDirectory = firstSlstrFile.getParentFile();
        File stitchedProductFileParentDirectory = stitchedProductFile.getParentFile();
        TestCase.assertEquals((String)slstrFileParentDirectory.getName(), (String)stitchedProductFileParentDirectory.getName());
        TestCase.assertEquals((Object)this.targetDirectory, (Object)stitchedProductFileParentDirectory.getParentFile());
        File[] files = slstrFileParentDirectory.listFiles();
        junit.framework.Assert.assertNotNull((Object)files);
        for (File slstrFile : files) {
            assert (new File(stitchedProductFileParentDirectory, slstrFile.getName()).exists());
        }
    }

    @Test
    @Ignore
    public void testStitchPDUs_AllSlstrL1BProductFiles() throws IOException, PDUStitchingException, TransformerException, ParserConfigurationException {
        File[] slstrFiles = TestUtils.getSlstrFiles();
        File stitchedProductFile = SlstrPduStitcher.createStitchedSlstrL1BFile((File)this.targetDirectory, (File[])slstrFiles, (ProgressMonitor)ProgressMonitor.NULL);
        File stitchedProductFileParentDirectory = stitchedProductFile.getParentFile();
        assert (new File(stitchedProductFileParentDirectory, "xfdumanifest.xml").exists());
        assert (new File(stitchedProductFileParentDirectory, "F1_BT_io.nc").exists());
        assert (new File(stitchedProductFileParentDirectory, "met_tx.nc").exists());
        assert (new File(stitchedProductFileParentDirectory, "viscal.nc").exists());
        TestCase.assertEquals((Object)this.targetDirectory, (Object)stitchedProductFileParentDirectory.getParentFile());
    }

    @Test
    public void testDecomposeSlstrName() {
        SlstrPduStitcher.SlstrNameDecomposition firstSlstrNameDecomposition = SlstrPduStitcher.decomposeSlstrName((String)TestUtils.getFirstSlstrFile().getParentFile().getName());
        Date startTime = new GregorianCalendar(2013, 6, 7, 15, 32, 52).getTime();
        Date stopTime = new GregorianCalendar(2013, 6, 7, 15, 37, 52).getTime();
        TestCase.assertEquals((Object)startTime, (Object)firstSlstrNameDecomposition.startTime);
        TestCase.assertEquals((Object)stopTime, (Object)firstSlstrNameDecomposition.stopTime);
        TestCase.assertEquals((String)"0299", (String)firstSlstrNameDecomposition.duration);
        TestCase.assertEquals((String)"158", (String)firstSlstrNameDecomposition.cycleNumber);
        TestCase.assertEquals((String)"182", (String)firstSlstrNameDecomposition.relativeOrbitNumber);
        TestCase.assertEquals((String)"____", (String)firstSlstrNameDecomposition.frameAlongTrackCoordinate);
        TestCase.assertEquals((String)"SVL", (String)firstSlstrNameDecomposition.fileGeneratingCentre);
        TestCase.assertEquals((String)"O", (String)firstSlstrNameDecomposition.platform);
        TestCase.assertEquals((String)"NR", (String)firstSlstrNameDecomposition.timelinessOfProcessingWorkflow);
        TestCase.assertEquals((String)"001", (String)firstSlstrNameDecomposition.baselineCollectionOrDataUsage);
    }

    @Test
    public void testCreateParentDirectoryNameOfStitchedFile() {
        SlstrPduStitcher.SlstrNameDecomposition[] decompositions = new SlstrPduStitcher.SlstrNameDecomposition[]{SlstrPduStitcher.decomposeSlstrName((String)TestUtils.getFirstSlstrFile().getParentFile().getName()), SlstrPduStitcher.decomposeSlstrName((String)TestUtils.getSecondSlstrFile().getParentFile().getName()), SlstrPduStitcher.decomposeSlstrName((String)TestUtils.getThirdSlstrFile().getParentFile().getName())};
        String parentDirectoryNameOfStitchedFile = SlstrPduStitcher.createParentDirectoryNameOfStitchedFile((SlstrPduStitcher.SlstrNameDecomposition[])decompositions, (Date)Calendar.getInstance().getTime());
        String now = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(Calendar.getInstance().getTime());
        TestCase.assertEquals((String)("S3A_SL_1_RBT____20130707T153252_20130707T154752_" + now + "_0299_158_182______SVL_O_NR_001.SEN3"), (String)parentDirectoryNameOfStitchedFile);
    }

    @Test
    public void testCollectFiles() throws IOException {
        File[] slstrFiles;
        ArrayList ncFiles = new ArrayList();
        for (File slstrFile : slstrFiles = TestUtils.getSlstrFiles()) {
            SlstrPduStitcher.collectFiles(ncFiles, (Document)SlstrPduStitcherTest.createXmlDocument(new FileInputStream(slstrFile)));
        }
        TestCase.assertEquals((int)3, (int)ncFiles.size());
        TestCase.assertEquals((String)"met_tx.nc", (String)((String)ncFiles.get(0)));
        TestCase.assertEquals((String)"viscal.nc", (String)((String)ncFiles.get(1)));
        TestCase.assertEquals((String)"F1_BT_io.nc", (String)((String)ncFiles.get(2)));
    }

    private static Document createXmlDocument(InputStream inputStream) throws IOException {
        String msg = "Cannot create document from manifest XML file.";
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot create document from manifest XML file.", e);
        }
    }
}

