/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import com.bc.ceres.binding.converters.DateFormatConverter;
import edu.ucar.ral.nujan.netcdf.NhException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.NcFileStitcher;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrN4Variable;
import org.esa.s3tbx.slstr.pdu.stitching.SlstrNFileWritable;
import org.esa.s3tbx.slstr.pdu.stitching.TestUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayLong;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NcFileStitcherTest {
    private File targetDirectory;
    private NetcdfFile netcdfFile;

    @Before
    public void setUp() {
        this.targetDirectory = new File("test_out");
        if (!this.targetDirectory.mkdirs()) {
            Assert.fail((String)"Unable to create test target directory");
        }
        this.netcdfFile = null;
    }

    @After
    public void tearDown() throws IOException {
        if (this.netcdfFile != null) {
            this.netcdfFile.close();
        }
        if (this.targetDirectory.isDirectory() && !FileUtils.deleteTree((File)this.targetDirectory)) {
            Assert.fail((String)"Unable to delete test directory");
        }
    }

    @Test
    public void testStitchViscal() throws IOException, PDUStitchingException {
        String ncFileName = "viscal.nc";
        ImageSize targetImageSize = new ImageSize("xx", 0, 0, 0, 0);
        ImageSize[] imageSizes = new ImageSize[]{new ImageSize("xx", 0, 0, 0, 0), new ImageSize("xx", 0, 0, 0, 0), new ImageSize("xx", 0, 0, 0, 0)};
        Date now = Calendar.getInstance().getTime();
        File[] ncFiles = NcFileStitcherTest.getNcFiles("viscal.nc");
        File stitchedFile = NcFileStitcher.stitchNcFiles((String)"viscal.nc", (File)this.targetDirectory, (Date)now, (File[])ncFiles, (ImageSize)targetImageSize, (ImageSize[])imageSizes);
        assert (stitchedFile != null);
        assert (stitchedFile.exists());
        TestCase.assertEquals((String)"viscal.nc", (String)stitchedFile.getName());
        this.netcdfFile = NetcdfFileOpener.open((Object)stitchedFile);
        junit.framework.Assert.assertNotNull((Object)this.netcdfFile);
        List variables = this.netcdfFile.getVariables();
        TestCase.assertEquals((int)40, (int)variables.size());
        TestCase.assertEquals((String)"ANX_time", (String)((Variable)variables.get(0)).getFullName());
        TestCase.assertEquals((Object)DataType.STRING, (Object)((Variable)variables.get(0)).getDataType());
        TestCase.assertEquals((String)"calibration_time", (String)((Variable)variables.get(1)).getFullName());
        TestCase.assertEquals((Object)DataType.STRING, (Object)((Variable)variables.get(1)).getDataType());
    }

    @Test
    @Ignore
    public void testStitchMet_tx() throws IOException, PDUStitchingException, InvalidRangeException {
        int i;
        String ncFileName = "met_tx.nc";
        ImageSize targetImageSize = new ImageSize("in", 21687, 64, 6000, 130);
        ImageSize[] imageSizes = new ImageSize[]{new ImageSize("in", 21687, 64, 2000, 130), new ImageSize("in", 23687, 64, 2000, 130), new ImageSize("in", 25687, 64, 2000, 130)};
        Date now = Calendar.getInstance().getTime();
        File[] ncFiles = NcFileStitcherTest.getNcFiles("met_tx.nc");
        File stitchedFile = NcFileStitcher.stitchNcFiles((String)"met_tx.nc", (File)this.targetDirectory, (Date)now, (File[])ncFiles, (ImageSize)targetImageSize, (ImageSize[])imageSizes);
        assert (stitchedFile != null);
        assert (stitchedFile.exists());
        TestCase.assertEquals((String)"met_tx.nc", (String)stitchedFile.getName());
        this.netcdfFile = NetcdfFileOpener.open((Object)stitchedFile);
        junit.framework.Assert.assertNotNull((Object)this.netcdfFile);
        List variables = this.netcdfFile.getVariables();
        TestCase.assertEquals((int)28, (int)variables.size());
        TestCase.assertEquals((String)"t_single", (String)((Variable)variables.get(0)).getFullName());
        TestCase.assertEquals((Object)DataType.SHORT, (Object)((Variable)variables.get(0)).getDataType());
        TestCase.assertEquals((String)"sea_ice_fraction_tx", (String)((Variable)variables.get(9)).getFullName());
        TestCase.assertEquals((Object)DataType.FLOAT, (Object)((Variable)variables.get(9)).getDataType());
        TestCase.assertEquals((String)"u_wind_tx", (String)((Variable)variables.get(10)).getFullName());
        TestCase.assertEquals((Object)DataType.FLOAT, (Object)((Variable)variables.get(10)).getDataType());
        TestCase.assertEquals((String)"snow_depth_tx", (String)((Variable)variables.get(27)).getFullName());
        TestCase.assertEquals((Object)DataType.FLOAT, (Object)((Variable)variables.get(27)).getDataType());
        TestCase.assertEquals((String)"long_name", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(0)).getFullName());
        TestCase.assertEquals((String)"Snow liquid water equivalent depth", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(0)).getStringValue());
        TestCase.assertEquals((String)"standard_name", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(1)).getFullName());
        TestCase.assertEquals((String)"lwe_thickness_of_surface_snow_amount", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(1)).getStringValue());
        TestCase.assertEquals((String)"units", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(2)).getFullName());
        TestCase.assertEquals((String)"metre", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(2)).getStringValue());
        TestCase.assertEquals((String)"model", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(3)).getFullName());
        TestCase.assertEquals((String)"ECMWF_F", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(3)).getStringValue());
        TestCase.assertEquals((String)"parameter", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(4)).getFullName());
        TestCase.assertEquals((String)"141", (String)((Attribute)((Variable)variables.get(27)).getAttributes().get(4)).getStringValue());
        ArrayList[] inputFileVariables = new ArrayList[3];
        for (i = 0; i < 3; ++i) {
            NetcdfFile ncFile = NetcdfFileOpener.open((Object)ncFiles[i]);
            junit.framework.Assert.assertNotNull((Object)ncFile);
            inputFileVariables[i] = ncFile.getVariables();
        }
        for (i = 0; i < variables.size(); ++i) {
            Variable variable = (Variable)variables.get(i);
            for (int j = 0; j < inputFileVariables.length; ++j) {
                Object[] actualArray;
                Object[] expectedArray;
                int rowOffset = j * 2000;
                Variable inputFileVariable = (Variable)inputFileVariables[j].get(i + 1);
                List inputFileVariableDimensions = inputFileVariable.getDimensions();
                int[] origin = new int[inputFileVariableDimensions.size()];
                int[] shape = new int[inputFileVariableDimensions.size()];
                for (int k = 0; k < inputFileVariableDimensions.size(); ++k) {
                    if (((Dimension)inputFileVariableDimensions.get(k)).getFullName().equals("rows")) {
                        origin[k] = rowOffset;
                        shape[k] = 2000;
                        continue;
                    }
                    origin[k] = 0;
                    shape[k] = ((Dimension)inputFileVariableDimensions.get(k)).getLength();
                }
                Section section = new Section(origin, shape);
                Array stitchedArrayPart = variable.read(section);
                Array fileArray = inputFileVariable.read();
                if (variable.getDataType() == DataType.SHORT) {
                    expectedArray = (short[])fileArray.copyTo1DJavaArray();
                    actualArray = (short[])stitchedArrayPart.copyTo1DJavaArray();
                    Assert.assertArrayEquals((short[])expectedArray, (short[])actualArray);
                    continue;
                }
                expectedArray = (float[])fileArray.copyTo1DJavaArray();
                actualArray = (float[])stitchedArrayPart.copyTo1DJavaArray();
                Assert.assertArrayEquals((float[])expectedArray, (float[])actualArray, (float)1.0E-8f);
            }
        }
    }

    @Test
    public void testStitchF1_BT_io() throws Exception {
        int i;
        String ncFileName = "F1_BT_io.nc";
        ImageSize targetImageSize = new ImageSize("io", 21687, 450, 6000, 900);
        ImageSize[] imageSizes = new ImageSize[]{new ImageSize("io", 23687, 450, 2000, 900)};
        Date now = Calendar.getInstance().getTime();
        File[] ncFiles = new File[]{NcFileStitcherTest.getSecondNcFile("F1_BT_io.nc")};
        File stitchedFile = NcFileStitcher.stitchNcFiles((String)"F1_BT_io.nc", (File)this.targetDirectory, (Date)now, (File[])ncFiles, (ImageSize)targetImageSize, (ImageSize[])imageSizes);
        assert (stitchedFile != null);
        assert (stitchedFile.exists());
        TestCase.assertEquals((String)"F1_BT_io.nc", (String)stitchedFile.getName());
        this.netcdfFile = NetcdfFileOpener.open((Object)stitchedFile);
        junit.framework.Assert.assertNotNull((Object)this.netcdfFile);
        List variables = this.netcdfFile.getVariables();
        TestCase.assertEquals((int)4, (int)variables.size());
        TestCase.assertEquals((String)"F1_BT_io", (String)((Variable)variables.get(0)).getFullName());
        TestCase.assertEquals((Object)DataType.SHORT, (Object)((Variable)variables.get(0)).getDataType());
        TestCase.assertEquals((String)"rows columns", (String)((Variable)variables.get(0)).getDimensionsString());
        List F1_BT_io_attributes = ((Variable)variables.get(0)).getAttributes();
        TestCase.assertEquals((String)"_ChunkSize", (String)((Attribute)F1_BT_io_attributes.get(0)).getFullName());
        Array chunkLengths = ((Attribute)F1_BT_io_attributes.get(0)).getValues();
        TestCase.assertEquals((int)1, (int)chunkLengths.getShape().length);
        TestCase.assertEquals((int)2, (int)chunkLengths.getShape()[0]);
        TestCase.assertEquals((int)600, (int)chunkLengths.getInt(0));
        TestCase.assertEquals((int)450, (int)chunkLengths.getInt(1));
        TestCase.assertEquals((String)"standard_name", (String)((Attribute)F1_BT_io_attributes.get(1)).getFullName());
        TestCase.assertEquals((String)"toa_brightness_temperature", (String)((Attribute)F1_BT_io_attributes.get(1)).getStringValue());
        TestCase.assertEquals((String)"long_name", (String)((Attribute)F1_BT_io_attributes.get(2)).getFullName());
        TestCase.assertEquals((String)"Gridded pixel brightness temperature for channel F1 (1km TIR grid, oblique view)", (String)((Attribute)F1_BT_io_attributes.get(2)).getStringValue());
        TestCase.assertEquals((String)"units", (String)((Attribute)F1_BT_io_attributes.get(3)).getFullName());
        TestCase.assertEquals((String)"K", (String)((Attribute)F1_BT_io_attributes.get(3)).getStringValue());
        TestCase.assertEquals((String)"_FillValue", (String)((Attribute)F1_BT_io_attributes.get(4)).getFullName());
        TestCase.assertEquals((Object)Short.MIN_VALUE, (Object)((Attribute)F1_BT_io_attributes.get(4)).getNumericValue());
        TestCase.assertEquals((String)"scale_factor", (String)((Attribute)F1_BT_io_attributes.get(5)).getFullName());
        TestCase.assertEquals((Object)0.01, (Object)((Attribute)F1_BT_io_attributes.get(5)).getNumericValue());
        TestCase.assertEquals((String)"add_offset", (String)((Attribute)F1_BT_io_attributes.get(6)).getFullName());
        TestCase.assertEquals((Object)283.73, (Object)((Attribute)F1_BT_io_attributes.get(6)).getNumericValue());
        TestCase.assertEquals((String)"F1_exception_io", (String)((Variable)variables.get(1)).getFullName());
        TestCase.assertEquals((String)"F1_BT_orphan_io", (String)((Variable)variables.get(2)).getFullName());
        TestCase.assertEquals((String)"F1_exception_orphan_io", (String)((Variable)variables.get(3)).getFullName());
        TestCase.assertEquals((Object)DataType.BYTE, (Object)((Variable)variables.get(3)).getDataType());
        TestCase.assertEquals((boolean)true, (boolean)((Variable)variables.get(3)).isUnsigned());
        TestCase.assertEquals((String)"rows orphan_pixels", (String)((Variable)variables.get(3)).getDimensionsString());
        List F1_exception_orphan_io_attributes = ((Variable)variables.get(3)).getAttributes();
        TestCase.assertEquals((String)"_ChunkSize", (String)((Attribute)F1_exception_orphan_io_attributes.get(0)).getFullName());
        chunkLengths = ((Attribute)F1_exception_orphan_io_attributes.get(0)).getValues();
        TestCase.assertEquals((int)1, (int)chunkLengths.getShape().length);
        TestCase.assertEquals((int)2, (int)chunkLengths.getShape()[0]);
        TestCase.assertEquals((int)600, (int)chunkLengths.getInt(0));
        TestCase.assertEquals((int)112, (int)chunkLengths.getInt(1));
        TestCase.assertEquals((String)"standard_name", (String)((Attribute)F1_exception_orphan_io_attributes.get(1)).getFullName());
        TestCase.assertEquals((String)"toa_brightness_temperature_status_flag", (String)((Attribute)F1_exception_orphan_io_attributes.get(1)).getStringValue());
        TestCase.assertEquals((String)"flag_masks", (String)((Attribute)F1_exception_orphan_io_attributes.get(2)).getFullName());
        TestCase.assertEquals((boolean)true, (boolean)((Attribute)F1_exception_orphan_io_attributes.get(2)).isArray());
        Array F1_exception_orphan_io_values = ((Attribute)F1_exception_orphan_io_attributes.get(2)).getValues();
        TestCase.assertEquals((long)8L, (long)F1_exception_orphan_io_values.getSize());
        TestCase.assertEquals((boolean)true, (boolean)F1_exception_orphan_io_values.isUnsigned());
        TestCase.assertEquals((byte)1, (byte)F1_exception_orphan_io_values.getByte(0));
        TestCase.assertEquals((byte)2, (byte)F1_exception_orphan_io_values.getByte(1));
        TestCase.assertEquals((byte)4, (byte)F1_exception_orphan_io_values.getByte(2));
        TestCase.assertEquals((byte)8, (byte)F1_exception_orphan_io_values.getByte(3));
        TestCase.assertEquals((byte)16, (byte)F1_exception_orphan_io_values.getByte(4));
        TestCase.assertEquals((byte)32, (byte)F1_exception_orphan_io_values.getByte(5));
        TestCase.assertEquals((byte)64, (byte)F1_exception_orphan_io_values.getByte(6));
        TestCase.assertEquals((byte)-128, (byte)F1_exception_orphan_io_values.getByte(7));
        TestCase.assertEquals((String)"flag_meanings", (String)((Attribute)F1_exception_orphan_io_attributes.get(3)).getFullName());
        TestCase.assertEquals((String)"ISP_absent pixel_absent not_decompressed no_signal saturation invalid_radiance no_parameters unfilled_pixel", (String)((Attribute)F1_exception_orphan_io_attributes.get(3)).getStringValue());
        TestCase.assertEquals((String)"_FillValue", (String)((Attribute)F1_exception_orphan_io_attributes.get(4)).getFullName());
        TestCase.assertEquals((Object)-128, (Object)((Attribute)F1_exception_orphan_io_attributes.get(4)).getNumericValue());
        List inputFileVariables = new ArrayList();
        for (i = 0; i < 1; ++i) {
            NetcdfFile ncfile = NetcdfFileOpener.open((Object)ncFiles[i]);
            junit.framework.Assert.assertNotNull((Object)ncfile);
            inputFileVariables = ncfile.getVariables();
        }
        for (i = 0; i < variables.size(); ++i) {
            Object[] actualArray;
            Object[] expectedArray;
            Variable variable = (Variable)variables.get(i);
            int offset = 2000;
            Section section = new Section(new int[]{offset, 0}, new int[]{offset, variable.getDimension(1).getLength()});
            Array stitchedArrayPart = variable.read(section);
            Array fileArray = ((Variable)inputFileVariables.get(i)).read();
            if (variable.getDataType() == DataType.SHORT) {
                expectedArray = (short[])fileArray.copyTo1DJavaArray();
                actualArray = (short[])stitchedArrayPart.copyTo1DJavaArray();
                Assert.assertArrayEquals((short[])expectedArray, (short[])actualArray);
                continue;
            }
            expectedArray = (byte[])fileArray.copyTo1DJavaArray();
            actualArray = (byte[])stitchedArrayPart.copyTo1DJavaArray();
            Assert.assertArrayEquals((byte[])expectedArray, (byte[])actualArray);
        }
    }

    @Test
    public void testSetGlobalAttributes() throws IOException {
        File file = new File(this.targetDirectory, "something.nc");
        SlstrNFileWritable netcdfWriteable = SlstrNFileWritable.create((String)file.getAbsolutePath());
        List[] attributeLists = new List[2];
        attributeLists[0] = new ArrayList();
        attributeLists[0].add(new Attribute("xyz", "yz"));
        attributeLists[0].add(new Attribute("abc", "23"));
        ArrayByte someArray = new ArrayByte(new int[]{2});
        someArray.setByte(0, (byte)5);
        someArray.setByte(0, (byte)5);
        someArray.setUnsigned(true);
        attributeLists[0].add(new Attribute("def", (Array)someArray));
        attributeLists[1] = new ArrayList();
        attributeLists[1].add(new Attribute("xyz", "yz"));
        attributeLists[1].add(new Attribute("abc", "44"));
        attributeLists[1].add(new Attribute("defg", (Array)someArray));
        DateFormatConverter globalAttributesDateFormatConverter = new DateFormatConverter((DateFormat)new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'"));
        String someTimeAsString = globalAttributesDateFormatConverter.format(new GregorianCalendar(2013, 6, 7, 15, 32, 52).getTime());
        attributeLists[1].add(new Attribute("creation_time", someTimeAsString));
        Date now = Calendar.getInstance().getTime();
        String nowAsString = globalAttributesDateFormatConverter.format(now);
        NcFileStitcher.setGlobalAttributes((SlstrNFileWritable)netcdfWriteable, (List[])attributeLists, (String)this.targetDirectory.getName(), (Date)now);
        netcdfWriteable.create();
        netcdfWriteable.close();
        this.netcdfFile = NetcdfFileOpener.open((Object)file);
        junit.framework.Assert.assertNotNull((Object)this.netcdfFile);
        List globalAttributes = this.netcdfFile.getGlobalAttributes();
        TestCase.assertEquals((int)6, (int)globalAttributes.size());
        TestCase.assertEquals((String)"xyz", (String)((Attribute)globalAttributes.get(0)).getFullName());
        TestCase.assertEquals((String)"yz", (String)((Attribute)globalAttributes.get(0)).getStringValue());
        TestCase.assertEquals((String)"abc_1", (String)((Attribute)globalAttributes.get(1)).getFullName());
        TestCase.assertEquals((String)"44", (String)((Attribute)globalAttributes.get(1)).getStringValue());
        TestCase.assertEquals((String)"abc", (String)((Attribute)globalAttributes.get(2)).getFullName());
        TestCase.assertEquals((String)"23", (String)((Attribute)globalAttributes.get(2)).getStringValue());
        TestCase.assertEquals((String)"def", (String)((Attribute)globalAttributes.get(3)).getFullName());
        TestCase.assertEquals((String)someArray.toString(), (String)((Attribute)globalAttributes.get(3)).getStringValue());
        TestCase.assertEquals((String)"defg", (String)((Attribute)globalAttributes.get(4)).getFullName());
        TestCase.assertEquals((String)someArray.toString(), (String)((Attribute)globalAttributes.get(4)).getStringValue());
        TestCase.assertEquals((String)"creation_time", (String)((Attribute)globalAttributes.get(5)).getFullName());
        TestCase.assertEquals((String)nowAsString, (String)((Attribute)globalAttributes.get(5)).getStringValue());
    }

    @Test
    public void testSetDimensions() throws IOException, NhException, PDUStitchingException {
        List[] dimensionLists = new ArrayList[2];
        List[] variableLists = new ArrayList[2];
        File inputFile1 = new File(this.targetDirectory, "input_1.nc");
        SlstrNFileWritable inputWriteable1 = SlstrNFileWritable.create((String)inputFile1.getAbsolutePath());
        inputWriteable1.addDimension("rows", 5);
        inputWriteable1.addDimension("columns", 7);
        inputWriteable1.addDimension("the_twilight_zone", 12);
        SlstrN4Variable abVariable1 = inputWriteable1.addVariable("ab", DataType.BYTE, true, null, "rows columns");
        SlstrN4Variable cdVariable1 = inputWriteable1.addVariable("cd", DataType.LONG, false, null, "columns the_twilight_zone");
        inputWriteable1.create();
        abVariable1.writeFullyInSections((Array)new ArrayByte(new int[]{5, 7}));
        cdVariable1.writeFullyInSections((Array)new ArrayLong(new int[]{7, 12}));
        inputWriteable1.close();
        NetcdfFile inputnc1 = NetcdfFileOpener.open((Object)inputFile1);
        junit.framework.Assert.assertNotNull((Object)inputnc1);
        dimensionLists[0] = inputnc1.getDimensions();
        variableLists[0] = inputnc1.getVariables();
        inputnc1.close();
        File inputFile2 = new File(this.targetDirectory, "input_2.nc");
        NFileWriteable inputWriteable2 = NWritableFactory.create((String)inputFile2.getAbsolutePath(), (String)"netcdf4");
        inputWriteable2.addDimension("rows", 5);
        inputWriteable2.addDimension("columns", 7);
        inputWriteable2.addDimension("outer_limits", 25);
        NVariable abVariable2 = inputWriteable2.addVariable("ab", DataType.BYTE, true, null, "rows columns");
        NVariable cdVariable2 = inputWriteable2.addVariable("ef", DataType.LONG, false, null, "columns outer_limits");
        inputWriteable2.create();
        abVariable2.writeFully((Array)new ArrayByte(new int[]{5, 7}));
        cdVariable2.writeFully((Array)new ArrayLong(new int[]{7, 25}));
        inputWriteable2.close();
        NetcdfFile inputnc2 = NetcdfFileOpener.open((Object)inputFile2);
        junit.framework.Assert.assertNotNull((Object)inputnc2);
        dimensionLists[1] = inputnc2.getDimensions();
        variableLists[1] = inputnc2.getVariables();
        inputnc2.close();
        File file = new File(this.targetDirectory, "something.nc");
        SlstrNFileWritable netcdfWriteable = SlstrNFileWritable.create((String)file.getAbsolutePath());
        ImageSize targetImageSize = new ImageSize("id", 10, 20, 10, 20);
        NcFileStitcher.setDimensions((SlstrNFileWritable)netcdfWriteable, (List[])dimensionLists, (ImageSize)targetImageSize, (List[])variableLists);
        netcdfWriteable.create();
        netcdfWriteable.close();
        this.netcdfFile = NetcdfFileOpener.open((Object)file);
        junit.framework.Assert.assertNotNull((Object)this.netcdfFile);
        List dimensions = this.netcdfFile.getDimensions();
        TestCase.assertEquals((int)4, (int)dimensions.size());
        TestCase.assertEquals((String)"rows", (String)((Dimension)dimensions.get(0)).getFullName());
        TestCase.assertEquals((int)10, (int)((Dimension)dimensions.get(0)).getLength());
        TestCase.assertEquals((String)"columns", (String)((Dimension)dimensions.get(1)).getFullName());
        TestCase.assertEquals((int)20, (int)((Dimension)dimensions.get(1)).getLength());
        TestCase.assertEquals((String)"the_twilight_zone", (String)((Dimension)dimensions.get(2)).getFullName());
        TestCase.assertEquals((int)12, (int)((Dimension)dimensions.get(2)).getLength());
        TestCase.assertEquals((String)"outer_limits", (String)((Dimension)dimensions.get(3)).getFullName());
        TestCase.assertEquals((int)25, (int)((Dimension)dimensions.get(3)).getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDimensions_VaryingDimensionLengths() throws IOException, NhException, PDUStitchingException {
        List[] dimensionLists = new ArrayList[2];
        List[] variableLists = new ArrayList[2];
        File inputFile1 = new File(this.targetDirectory, "input_1.nc");
        NFileWriteable inputWriteable1 = NWritableFactory.create((String)inputFile1.getAbsolutePath(), (String)"netcdf4");
        inputWriteable1.addDimension("rows", 5);
        inputWriteable1.addDimension("columns", 7);
        inputWriteable1.addDimension("the_twilight_zone", 12);
        NVariable abVariable1 = inputWriteable1.addVariable("ab", DataType.BYTE, true, null, "rows columns");
        NVariable cdVariable1 = inputWriteable1.addVariable("cd", DataType.LONG, false, null, "columns the_twilight_zone");
        inputWriteable1.create();
        abVariable1.writeFully((Array)new ArrayByte(new int[]{5, 7}));
        cdVariable1.writeFully((Array)new ArrayLong(new int[]{7, 12}));
        inputWriteable1.close();
        NetcdfFile inputnc1 = NetcdfFileOpener.open((Object)inputFile1);
        junit.framework.Assert.assertNotNull((Object)inputnc1);
        dimensionLists[0] = inputnc1.getDimensions();
        variableLists[0] = inputnc1.getVariables();
        inputnc1.close();
        File inputFile2 = new File(this.targetDirectory, "input_2.nc");
        NFileWriteable inputWriteable2 = NWritableFactory.create((String)inputFile2.getAbsolutePath(), (String)"netcdf4");
        inputWriteable2.addDimension("rows", 5);
        inputWriteable2.addDimension("columns", 7);
        inputWriteable2.addDimension("the_twilight_zone", 25);
        NVariable abVariable2 = inputWriteable2.addVariable("ab", DataType.BYTE, true, null, "rows columns");
        NVariable cdVariable2 = inputWriteable2.addVariable("ef", DataType.LONG, false, null, "columns the_twilight_zone");
        inputWriteable2.create();
        abVariable2.writeFully((Array)new ArrayByte(new int[]{5, 7}));
        cdVariable2.writeFully((Array)new ArrayLong(new int[]{7, 25}));
        inputWriteable2.close();
        NetcdfFile inputnc2 = NetcdfFileOpener.open((Object)inputFile2);
        junit.framework.Assert.assertNotNull((Object)inputnc2);
        dimensionLists[1] = inputnc2.getDimensions();
        variableLists[1] = inputnc2.getVariables();
        inputnc2.close();
        File file = new File(this.targetDirectory, "something.nc");
        SlstrNFileWritable netcdfWriteable = SlstrNFileWritable.create((String)file.getAbsolutePath());
        netcdfWriteable.create();
        ImageSize targetImageSize = new ImageSize("id", 10, 20, 10, 20);
        try {
            NcFileStitcher.setDimensions((SlstrNFileWritable)netcdfWriteable, (List[])dimensionLists, (ImageSize)targetImageSize, (List[])variableLists);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            TestCase.assertEquals((String)"Dimension the_twilight_zone has different lengths across input files", (String)e.getMessage());
        }
        finally {
            netcdfWriteable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDimensions_VaryingValues() throws IOException, NhException, PDUStitchingException {
        List[] dimensionLists = new ArrayList[2];
        List[] variableLists = new ArrayList[2];
        File inputFile1 = new File(this.targetDirectory, "input_1.nc");
        NFileWriteable inputWriteable1 = NWritableFactory.create((String)inputFile1.getAbsolutePath(), (String)"netcdf4");
        inputWriteable1.addDimension("rows", 5);
        inputWriteable1.addDimension("columns", 7);
        inputWriteable1.addDimension("cd", 12);
        NVariable abVariable1 = inputWriteable1.addVariable("ab", DataType.BYTE, true, null, "rows columns");
        NVariable cdVariable1 = inputWriteable1.addVariable("cd", DataType.LONG, false, null, "cd");
        inputWriteable1.create();
        abVariable1.writeFully((Array)new ArrayByte(new int[]{5, 7}));
        cdVariable1.writeFully((Array)new ArrayLong(new int[]{12}));
        inputWriteable1.close();
        NetcdfFile inputnc1 = NetcdfFileOpener.open((Object)inputFile1);
        junit.framework.Assert.assertNotNull((Object)inputnc1);
        dimensionLists[0] = inputnc1.getDimensions();
        variableLists[0] = inputnc1.getVariables();
        File inputFile2 = new File(this.targetDirectory, "input_2.nc");
        NFileWriteable inputWriteable2 = NWritableFactory.create((String)inputFile2.getAbsolutePath(), (String)"netcdf4");
        inputWriteable2.addDimension("rows", 5);
        inputWriteable2.addDimension("columns", 7);
        inputWriteable2.addDimension("cd", 12);
        NVariable abVariable2 = inputWriteable2.addVariable("ab", DataType.BYTE, true, null, "rows columns");
        NVariable cdVariable2 = inputWriteable2.addVariable("cd", DataType.LONG, false, null, "cd");
        inputWriteable2.create();
        abVariable2.writeFully((Array)new ArrayByte(new int[]{5, 7}));
        ArrayLong values = new ArrayLong(new int[]{12});
        values.setLong(10, 10L);
        cdVariable2.writeFully((Array)values);
        inputWriteable2.close();
        NetcdfFile inputnc2 = NetcdfFileOpener.open((Object)inputFile2);
        junit.framework.Assert.assertNotNull((Object)inputnc2);
        dimensionLists[1] = inputnc2.getDimensions();
        variableLists[1] = inputnc2.getVariables();
        File file = new File(this.targetDirectory, "something.nc");
        SlstrNFileWritable netcdfWriteable = SlstrNFileWritable.create((String)file.getAbsolutePath());
        netcdfWriteable.create();
        ImageSize targetImageSize = new ImageSize("id", 10, 20, 10, 20);
        try {
            NcFileStitcher.setDimensions((SlstrNFileWritable)netcdfWriteable, (List[])dimensionLists, (ImageSize)targetImageSize, (List[])variableLists);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            TestCase.assertEquals((String)"Values for cd are different across input files", (String)e.getMessage());
        }
        finally {
            inputnc1.close();
            inputnc2.close();
            netcdfWriteable.close();
        }
    }

    @Test
    public void testDetermineDestinationOffsets_f1_BT_in() throws IOException {
        int[][] expected_f1_BT_in_DestinationOffsets = new int[][]{{0}, {3000000}, {6000000}};
        int[] rowOffsets = new int[]{0, 2000, 4000};
        int[] numberOfRows = new int[]{2000, 2000, 2000};
        int[] sectionSizes_f1_BT_in = new int[]{3000000, 3000000, 3000000};
        int[][] sourceOffsets = new int[][]{{0}, {0}, {0}};
        int[][] actual_f1_BT_in_DestinationOffsets = NcFileStitcher.determineDestinationOffsets((int[])rowOffsets, (int[])numberOfRows, (int[])sectionSizes_f1_BT_in, (int[][])sourceOffsets);
        for (int i = 0; i < expected_f1_BT_in_DestinationOffsets.length; ++i) {
            Assert.assertArrayEquals((int[])expected_f1_BT_in_DestinationOffsets[i], (int[])actual_f1_BT_in_DestinationOffsets[i]);
        }
    }

    @Test
    public void testDetermineDestinationOffsets_met_tx() throws IOException {
        int[][] expected_met_tx_DestinationOffsets = new int[][]{{0, 780000, 1560000, 2340000, 3120000}, {260000, 1040000, 1820000, 2600000, 3380000}, {520000, 1300000, 2080000, 2860000, 3640000}};
        int[] sectionSizes_met_tx = new int[]{260000, 260000, 260000};
        int[] rowOffsets = new int[]{0, 2000, 4000};
        int[] numberOfRows = new int[]{2000, 2000, 2000};
        int[][] sourceOffsets = new int[][]{{0, 260000, 520000, 780000, 1040000}, {0, 260000, 520000, 780000, 1040000}, {0, 260000, 520000, 780000, 1040000}};
        int[][] actual_met_tx_DestinationOffsets = NcFileStitcher.determineDestinationOffsets((int[])rowOffsets, (int[])numberOfRows, (int[])sectionSizes_met_tx, (int[][])sourceOffsets);
        for (int i = 0; i < expected_met_tx_DestinationOffsets.length; ++i) {
            Assert.assertArrayEquals((int[])expected_met_tx_DestinationOffsets[i], (int[])actual_met_tx_DestinationOffsets[i]);
        }
    }

    @Test
    public void testDetermineDestinationOffsets_S1_quality_an() throws IOException {
        int[][] expectedDestinationOffsets = new int[][]{{0, 3396, 6792, 10188, 13584, 16980, 20376, 23772}, {1601, 4997, 8393, 11789, 15185, 18581, 21977, 25373}, {3201, 6597, 9993, 13389, 16785, 20181, 23577, 26973}};
        int[] sectionSizes = new int[]{1601, 1600, 195};
        int[] rowOffsets = new int[]{0, 1601, 3201};
        int[] numberOfRows = new int[]{1601, 1600, 195};
        int[][] sourceOffsets = new int[][]{{0, 1601, 3202, 4803, 6404, 8005, 9606, 11207}, {0, 1600, 3200, 4800, 6400, 8000, 9600, 11200}, {0, 195, 390, 585, 780, 975, 1170, 1365}};
        int[][] actualDestinationOffsets = NcFileStitcher.determineDestinationOffsets((int[])rowOffsets, (int[])numberOfRows, (int[])sectionSizes, (int[][])sourceOffsets);
        for (int i = 0; i < expectedDestinationOffsets.length; ++i) {
            Assert.assertArrayEquals((int[])expectedDestinationOffsets[i], (int[])actualDestinationOffsets[i]);
        }
    }

    @Test
    public void testDetermineDestinationOffsets_differentSectionSizes() throws IOException {
        int[][] expectedDestinationOffsets = new int[][]{{0}, {2000000}, {6500000}};
        int[] rowOffsets = new int[]{0, 2000, 6500};
        int[] numberOfRows = new int[]{2000, 4500, 1500};
        int[] sectionSizes = new int[]{2000000, 4500000, 1500000};
        int[][] sourceOffsets = new int[][]{{0}, {0}, {0}};
        int[][] actual_f1_BT_in_DestinationOffsets = NcFileStitcher.determineDestinationOffsets((int[])rowOffsets, (int[])numberOfRows, (int[])sectionSizes, (int[][])sourceOffsets);
        for (int i = 0; i < expectedDestinationOffsets.length; ++i) {
            Assert.assertArrayEquals((int[])expectedDestinationOffsets[i], (int[])actual_f1_BT_in_DestinationOffsets[i]);
        }
    }

    @Test
    public void testDetermineSourceOffsets() throws IOException {
        File f1_BT_io_file = NcFileStitcherTest.getSecondNcFile("F1_BT_io.nc");
        NetcdfFile f1_BT_io_netcdfFile = NetcdfFileOpener.open((Object)f1_BT_io_file);
        junit.framework.Assert.assertNotNull((Object)f1_BT_io_netcdfFile);
        Variable f1_BT_io_variable = (Variable)f1_BT_io_netcdfFile.getVariables().get(0);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])NcFileStitcher.determineSourceOffsets((int)1800000, (Variable)f1_BT_io_variable));
        File met_tx_file = NcFileStitcherTest.getFirstNcFile("met_tx.nc");
        NetcdfFile met_tx_netcdfFile = NetcdfFileOpener.open((Object)met_tx_file);
        junit.framework.Assert.assertNotNull((Object)met_tx_netcdfFile);
        Variable u_wind_tx_variable = (Variable)met_tx_netcdfFile.getVariables().get(11);
        Assert.assertArrayEquals((int[])new int[]{0, 260000, 520000, 780000, 1040000}, (int[])NcFileStitcher.determineSourceOffsets((int)260000, (Variable)u_wind_tx_variable));
    }

    @Test
    public void testDetermineSectionSize() throws IOException {
        File f1_BT_io_file = NcFileStitcherTest.getSecondNcFile("F1_BT_io.nc");
        NetcdfFile f1_BT_io_netcdfFile = NetcdfFileOpener.open((Object)f1_BT_io_file);
        junit.framework.Assert.assertNotNull((Object)f1_BT_io_netcdfFile);
        Variable f1_BT_io_variable = (Variable)f1_BT_io_netcdfFile.getVariables().get(0);
        TestCase.assertEquals((int)1800000, (int)NcFileStitcher.determineSectionSize((int)0, (Variable)f1_BT_io_variable));
        File met_tx_file = NcFileStitcherTest.getFirstNcFile("met_tx.nc");
        NetcdfFile met_tx_netcdfFile = NetcdfFileOpener.open((Object)met_tx_file);
        junit.framework.Assert.assertNotNull((Object)met_tx_netcdfFile);
        Variable u_wind_tx_variable = (Variable)met_tx_netcdfFile.getVariables().get(11);
        TestCase.assertEquals((int)260000, (int)NcFileStitcher.determineSectionSize((int)2, (Variable)u_wind_tx_variable));
    }

    private static File[] getNcFiles(String fileName) {
        return new File[]{NcFileStitcherTest.getFirstNcFile(fileName), NcFileStitcherTest.getSecondNcFile(fileName), NcFileStitcherTest.getThirdNcFile(fileName)};
    }

    private static File getFirstNcFile(String fileName) {
        return NcFileStitcherTest.getNcFile(TestUtils.FIRST_FILE_NAME, fileName);
    }

    private static File getSecondNcFile(String fileName) {
        return NcFileStitcherTest.getNcFile(TestUtils.SECOND_FILE_NAME, fileName);
    }

    private static File getThirdNcFile(String fileName) {
        return NcFileStitcherTest.getNcFile(TestUtils.THIRD_FILE_NAME, fileName);
    }

    private static File getNcFile(String fileName, String name) {
        String fullFileName = fileName + "/" + name;
        URL resource = NcFileStitcherTest.class.getResource(fullFileName);
        return new File(resource.getFile());
    }
}

