/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSizeHandler;
import org.esa.s3tbx.slstr.pdu.stitching.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImageSizeHandlerTest {
    @Test
    public void testExtractImageSizes() throws IOException {
        ImageSize[] imageSizes1 = ImageSizeHandler.extractImageSizes((Document)ImageSizeHandlerTest.createXmlDocument(new FileInputStream(ImageSizeHandlerTest.getFirstSlstrFile())));
        TestCase.assertEquals((int)10, (int)imageSizes1.length);
        assert (new ImageSize("in", 21687, 998, 2000, 1500).equals((Object)imageSizes1[0]));
        TestCase.assertEquals((Object)new ImageSize("an", 43374, 1996, 4000, 3000), (Object)imageSizes1[1]);
        TestCase.assertEquals((Object)new ImageSize("bn", 43374, 1996, 4000, 3000), (Object)imageSizes1[2]);
        TestCase.assertEquals((Object)new ImageSize("cn", 43374, 1996, 4000, 3000), (Object)imageSizes1[3]);
        TestCase.assertEquals((Object)new ImageSize("tn", 21687, 64, 2000, 130), (Object)imageSizes1[4]);
        TestCase.assertEquals((Object)new ImageSize("io", 21687, 450, 2000, 900), (Object)imageSizes1[5]);
        TestCase.assertEquals((Object)new ImageSize("ao", 43374, 900, 4000, 1800), (Object)imageSizes1[6]);
        TestCase.assertEquals((Object)new ImageSize("bo", 43374, 900, 4000, 1800), (Object)imageSizes1[7]);
        TestCase.assertEquals((Object)new ImageSize("co", 43374, 900, 4000, 1800), (Object)imageSizes1[8]);
        TestCase.assertEquals((Object)new ImageSize("to", 21687, 64, 2000, 130), (Object)imageSizes1[9]);
        ImageSize[] imageSizes2 = ImageSizeHandler.extractImageSizes((Document)ImageSizeHandlerTest.createXmlDocument(new FileInputStream(ImageSizeHandlerTest.getSecondSlstrFile())));
        TestCase.assertEquals((int)10, (int)imageSizes2.length);
        TestCase.assertEquals((Object)new ImageSize("in", 23687, 998, 2000, 1500), (Object)imageSizes2[0]);
        TestCase.assertEquals((Object)new ImageSize("an", 47374, 1996, 4000, 3000), (Object)imageSizes2[1]);
        TestCase.assertEquals((Object)new ImageSize("bn", 47374, 1996, 4000, 3000), (Object)imageSizes2[2]);
        TestCase.assertEquals((Object)new ImageSize("cn", 47374, 1996, 4000, 3000), (Object)imageSizes2[3]);
        TestCase.assertEquals((Object)new ImageSize("tn", 23687, 64, 2000, 130), (Object)imageSizes2[4]);
        TestCase.assertEquals((Object)new ImageSize("io", 23687, 450, 2000, 900), (Object)imageSizes2[5]);
        TestCase.assertEquals((Object)new ImageSize("ao", 47374, 900, 4000, 1800), (Object)imageSizes2[6]);
        TestCase.assertEquals((Object)new ImageSize("bo", 47374, 900, 4000, 1800), (Object)imageSizes2[7]);
        TestCase.assertEquals((Object)new ImageSize("co", 47374, 900, 4000, 1800), (Object)imageSizes2[8]);
        TestCase.assertEquals((Object)new ImageSize("to", 23687, 64, 2000, 130), (Object)imageSizes2[9]);
        ImageSize[] imageSizes3 = ImageSizeHandler.extractImageSizes((Document)ImageSizeHandlerTest.createXmlDocument(new FileInputStream(ImageSizeHandlerTest.getThirdSlstrFile())));
        TestCase.assertEquals((int)10, (int)imageSizes3.length);
        TestCase.assertEquals((Object)new ImageSize("in", 25687, 998, 2000, 1500), (Object)imageSizes3[0]);
        TestCase.assertEquals((Object)new ImageSize("an", 51374, 1996, 4000, 3000), (Object)imageSizes3[1]);
        TestCase.assertEquals((Object)new ImageSize("bn", 51374, 1996, 4000, 3000), (Object)imageSizes3[2]);
        TestCase.assertEquals((Object)new ImageSize("cn", 51374, 1996, 4000, 3000), (Object)imageSizes3[3]);
        TestCase.assertEquals((Object)new ImageSize("tn", 25687, 64, 2000, 130), (Object)imageSizes3[4]);
        TestCase.assertEquals((Object)new ImageSize("io", 25687, 450, 2000, 900), (Object)imageSizes3[5]);
        TestCase.assertEquals((Object)new ImageSize("ao", 51374, 900, 4000, 1800), (Object)imageSizes3[6]);
        TestCase.assertEquals((Object)new ImageSize("bo", 51374, 900, 4000, 1800), (Object)imageSizes3[7]);
        TestCase.assertEquals((Object)new ImageSize("co", 51374, 900, 4000, 1800), (Object)imageSizes3[8]);
        TestCase.assertEquals((Object)new ImageSize("to", 25687, 64, 2000, 130), (Object)imageSizes3[9]);
    }

    @Test
    public void testCreateTargetImageSize() {
        ImageSize[] imageSizes = new ImageSize[]{new ImageSize("in", 21687, 998, 2000, 1500), new ImageSize("in", 23687, 445, 2000, 1500), new ImageSize("in", 25687, 1443, 2000, 1500)};
        ImageSize targetImageSize = ImageSizeHandler.createTargetImageSize((ImageSize[])imageSizes);
        Assert.assertNotNull((Object)targetImageSize);
        TestCase.assertEquals((String)"in", (String)targetImageSize.getIdentifier());
        TestCase.assertEquals((int)21687, (int)targetImageSize.getStartOffset());
        TestCase.assertEquals((int)445, (int)targetImageSize.getTrackOffset());
        TestCase.assertEquals((int)6000, (int)targetImageSize.getRows());
        TestCase.assertEquals((int)2498, (int)targetImageSize.getColumns());
    }

    private static Document createXmlDocument(InputStream inputStream) throws IOException {
        String msg = "Cannot create document from manifest XML file.";
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot create document from manifest XML file.", e);
        }
    }

    private static File getFirstSlstrFile() {
        return ImageSizeHandlerTest.getResource(TestUtils.FIRST_FILE_NAME);
    }

    private static File getSecondSlstrFile() {
        return ImageSizeHandlerTest.getResource(TestUtils.SECOND_FILE_NAME);
    }

    private static File getThirdSlstrFile() {
        return ImageSizeHandlerTest.getResource(TestUtils.THIRD_FILE_NAME);
    }

    private static File getResource(String fileName) {
        String fullFileName = fileName + "/xfdumanifest.xml";
        URL resource = ImageSizeHandlerTest.class.getResource(fullFileName);
        return new File(resource.getFile());
    }
}

