/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.text.NumberFormatter;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PixelQualitySummaryMerger
extends AbstractElementMerger {
    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        String grid = fromParents.get(0).getAttributes().getNamedItem("grid").getNodeValue();
        toParent.setAttribute("grid", grid);
        Collection<List<Node>> summaryNodesLists = this.collectSummaryNodes(fromParents);
        NumberFormatter numberFormatter = this.getNumberFormatter();
        for (List<Node> summaryNodesList : summaryNodesLists) {
            if (summaryNodesList.size() != fromParents.size()) continue;
            int totalClassifiedPixels = 0;
            int totalPixels = 0;
            for (Node summaryNode : summaryNodesList) {
                NamedNodeMap summaryNodeAttributes = summaryNode.getAttributes();
                int classifiedPixels = Integer.parseInt(summaryNodeAttributes.getNamedItem("value").getNodeValue());
                double percentage = Double.parseDouble(summaryNodeAttributes.getNamedItem("percentage").getNodeValue());
                totalClassifiedPixels += classifiedPixels;
                totalPixels = (int)((double)totalPixels + (double)classifiedPixels / percentage * 100.0);
            }
            Element summaryElement = toDocument.createElement(summaryNodesList.get(0).getNodeName());
            summaryElement.setAttribute("value", "" + totalClassifiedPixels);
            if (totalPixels > 0) {
                Double percentage = (double)totalClassifiedPixels / (double)totalPixels * 100.0;
                try {
                    summaryElement.setAttribute("percentage", numberFormatter.valueToString(percentage));
                }
                catch (ParseException e) {
                    throw new PDUStitchingException("Could not format number: " + e.getMessage());
                }
            } else {
                summaryElement.setAttribute("percentage", "0.000000");
            }
            toParent.appendChild(summaryElement);
        }
    }

    private NumberFormatter getNumberFormatter() {
        DecimalFormat format = new DecimalFormat("0.000000");
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return new NumberFormatter(format);
    }

    private Collection<List<Node>> collectSummaryNodes(List<Node> fromParents) {
        LinkedHashMap summaryNodesMap = new LinkedHashMap();
        for (Node parent : fromParents) {
            NodeList childNodes = parent.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node summaryNode = childNodes.item(j);
                String nodeName = summaryNode.getNodeName();
                if (!nodeName.startsWith("slstr")) continue;
                if (summaryNodesMap.containsKey(nodeName)) {
                    ((List)summaryNodesMap.get(nodeName)).add(summaryNode);
                    continue;
                }
                ArrayList<Node> nodeList = new ArrayList<Node>();
                nodeList.add(summaryNode);
                summaryNodesMap.put(nodeName, nodeList);
            }
        }
        return summaryNodesMap.values();
    }
}

