/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.NumberFormatter;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MissingElementsMerger
extends AbstractElementMerger {
    private static final String SEPARATOR = "_";
    private static final String GLOBAL_INFO_NAME = "slstr:globalInfo";
    private static final String ELEMENT_MISSING_NAME = "slstr:elementMissing";
    private static final String BAND_SET_ELEMENT = "slstr:bandSet";
    private static final long NUMBER_OF_MILLIS_BETWEEN_ENTRIES = 450L;

    MissingElementsMerger() {
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        String threshold = fromParents.get(0).getAttributes().getNamedItem("threshold").getNodeValue();
        toParent.setAttribute("threshold", threshold);
        NumberFormatter numberFormatter = this.getNumberFormatter();
        Map<String, List<Node>> globalInfoNodesListMap = this.collectNodes(fromParents, GLOBAL_INFO_NAME);
        HashMap<String, Double> overs = new HashMap<String, Double>();
        for (Map.Entry<String, List<Node>> globalInfoNodesEntry : globalInfoNodesListMap.entrySet()) {
            String percentage;
            String[] key = globalInfoNodesEntry.getKey().split(SEPARATOR);
            String gridValue = key[0];
            String viewValue = key[1];
            int value = 0;
            int over = 0;
            List<Node> globalInfoNodes = globalInfoNodesEntry.getValue();
            for (Node globalInfoNode : globalInfoNodes) {
                Node valueNode = globalInfoNode.getAttributes().getNamedItem("value");
                Node overNode = globalInfoNode.getAttributes().getNamedItem("over");
                if (valueNode == null || overNode == null) continue;
                value += Integer.parseInt(valueNode.getNodeValue());
                int over1 = Integer.parseInt(overNode.getNodeValue());
                over += over1;
            }
            try {
                overs.put(globalInfoNodesEntry.getKey(), Double.valueOf(over));
                double percentageAsDouble = (double)value / (double)over * 100.0;
                percentage = numberFormatter.valueToString(percentageAsDouble);
            }
            catch (ParseException e) {
                throw new PDUStitchingException("Could not format number: " + e.getMessage());
            }
            Element globalInfoElement = toDocument.createElement(GLOBAL_INFO_NAME);
            globalInfoElement.setAttribute("grid", gridValue);
            globalInfoElement.setAttribute("view", viewValue);
            globalInfoElement.setAttribute("value", String.valueOf(value));
            globalInfoElement.setAttribute("over", String.valueOf(over));
            globalInfoElement.setAttribute("percentage", percentage);
            toParent.appendChild(globalInfoElement);
        }
        List<NewNode> newMissingNodes = this.getNewMissingNodes(fromParents);
        ArrayList<NewNode> sortedNodes = new ArrayList<NewNode>();
        for (NewNode newNode : newMissingNodes) {
            boolean inserted = false;
            for (int j = 0; j < sortedNodes.size(); ++j) {
                NewNode sortedNode = (NewNode)sortedNodes.get(j);
                if (!newNode.startTime.before(sortedNode.startTime)) continue;
                sortedNodes.add(j, newNode);
                inserted = true;
                break;
            }
            if (inserted) continue;
            sortedNodes.add(newNode);
        }
        for (NewNode node : sortedNodes) {
            String key = node.gridValue + SEPARATOR + node.viewValue;
            double over = (Double)overs.get(key);
            try {
                String percentage = numberFormatter.valueToString((double)node.value / over * 100.0);
                this.addNode(toDocument, toParent, node, percentage);
            }
            catch (ParseException e) {
                throw new PDUStitchingException("Could not format number: " + e.getMessage());
            }
        }
    }

    private void addNode(Document toDocument, Element toParent, NewNode node, String percentage) throws PDUStitchingException {
        Element elementMissingElement = toDocument.createElement(ELEMENT_MISSING_NAME);
        elementMissingElement.setAttribute("grid", node.gridValue);
        elementMissingElement.setAttribute("view", node.viewValue);
        elementMissingElement.setAttribute("startTime", node.startTimeAsNodeValue);
        elementMissingElement.setAttribute("stopTime", node.stopTimeAsNodeValue);
        elementMissingElement.setAttribute("percentage", percentage);
        Element bandSetElement = toDocument.createElement(BAND_SET_ELEMENT);
        this.addTextToNode(bandSetElement, node.bandSet, toDocument);
        elementMissingElement.appendChild(bandSetElement);
        toParent.appendChild(elementMissingElement);
    }

    private String getBandSetFromNode(Node node) {
        NodeList elementMissingNodeChildNodes = node.getChildNodes();
        for (int i = 0; i < elementMissingNodeChildNodes.getLength(); ++i) {
            Node childNode = elementMissingNodeChildNodes.item(i);
            if (!childNode.getNodeName().equals(BAND_SET_ELEMENT)) continue;
            return childNode.getTextContent();
        }
        return "";
    }

    private String getStartTimeFromNode(Node node) throws PDUStitchingException {
        Node startTimeNode = node.getAttributes().getNamedItem("startTime");
        return startTimeNode.getNodeValue();
    }

    private String getStopTimeFromNode(Node node) throws PDUStitchingException {
        Node stopTimeNode = node.getAttributes().getNamedItem("stopTime");
        return stopTimeNode.getNodeValue();
    }

    private double getPercentageFromNode(Node node) throws PDUStitchingException {
        Node percentageNode = node.getAttributes().getNamedItem("percentage");
        String percentageNodeValue = percentageNode.getNodeValue();
        return Double.parseDouble(percentageNodeValue);
    }

    private String getGridFromNode(Node node) throws PDUStitchingException {
        Node gridNode = node.getAttributes().getNamedItem("grid");
        return gridNode.getNodeValue();
    }

    private String getViewFromNode(Node node) throws PDUStitchingException {
        Node viewNode = node.getAttributes().getNamedItem("view");
        return viewNode.getNodeValue();
    }

    private int getOverFromNode(Node node) throws PDUStitchingException {
        Node overNode = node.getAttributes().getNamedItem("over");
        return Integer.parseInt(overNode.getNodeValue());
    }

    private NumberFormatter getNumberFormatter() {
        DecimalFormat format = new DecimalFormat("0.000000");
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return new NumberFormatter(format);
    }

    private List<NewNode> getNewMissingNodes(List<Node> fromParents) throws PDUStitchingException {
        ArrayList<NewNode> newMissingElements = new ArrayList<NewNode>();
        for (Node parent : fromParents) {
            HashMap<String, Integer> overs = new HashMap<String, Integer>();
            NodeList childNodes = parent.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(GLOBAL_INFO_NAME)) continue;
                String childGrid = this.getGridFromNode(childNode);
                String childView = this.getViewFromNode(childNode);
                int childOver = this.getOverFromNode(childNode);
                String key = childGrid + SEPARATOR + childView;
                overs.put(key, childOver);
            }
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(ELEMENT_MISSING_NAME)) continue;
                String childGrid = this.getGridFromNode(childNode);
                String childView = this.getViewFromNode(childNode);
                String childStartTime = this.getStartTimeFromNode(childNode);
                String childStopTime = this.getStopTimeFromNode(childNode);
                String childBandSet = this.getBandSetFromNode(childNode);
                double childPercentage = this.getPercentageFromNode(childNode);
                String key = childGrid + SEPARATOR + childView;
                if (!overs.containsKey(key)) {
                    throw new PDUStitchingException("Unidentified missing element detected");
                }
                Integer over = (Integer)overs.get(key);
                int childValue = (int)Math.round((double)over.intValue() / 100.0 * childPercentage);
                boolean contained = false;
                for (NewNode missingNode : newMissingElements) {
                    if (!missingNode.belongsToNode(childGrid, childView, childStartTime, childStopTime, childBandSet)) continue;
                    missingNode.incorporate(childStartTime, childStopTime, childValue);
                    contained = true;
                }
                if (contained) continue;
                NewNode newNode = new NewNode(childGrid, childView, childStartTime, childStopTime, childBandSet, childValue);
                newMissingElements.add(newNode);
            }
        }
        for (NewNode newNode : newMissingElements) {
            for (NewNode otherNode : newMissingElements) {
                if (newNode == otherNode || !newNode.belongsToNode(otherNode)) continue;
                newNode.incorporate(otherNode);
                newMissingElements.remove(otherNode);
            }
        }
        return newMissingElements;
    }

    private Map<String, List<Node>> collectNodes(List<Node> fromParents, String wantedNodeName) throws PDUStitchingException {
        LinkedHashMap<String, List<Node>> nodesMap = new LinkedHashMap<String, List<Node>>();
        for (Node parent : fromParents) {
            NodeList childNodes = parent.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(wantedNodeName)) continue;
                String gridFromNode = this.getGridFromNode(childNode);
                String viewFromNode = this.getViewFromNode(childNode);
                String identifier = gridFromNode + SEPARATOR + viewFromNode;
                if (nodesMap.containsKey(identifier)) {
                    ((List)nodesMap.get(identifier)).add(childNode);
                    continue;
                }
                ArrayList<Node> nodeList = new ArrayList<Node>();
                nodeList.add(childNode);
                nodesMap.put(identifier, nodeList);
            }
        }
        return nodesMap;
    }

    private class NewNode {
        private final String gridValue;
        private final String viewValue;
        private String startTimeAsNodeValue;
        private Date startTime;
        private String stopTimeAsNodeValue;
        private Date stopTime;
        private final String bandSet;
        private int value;

        NewNode(String gridValue, String viewValue, String startTime, String stopTime, String bandSet, int value) throws PDUStitchingException {
            this.gridValue = gridValue;
            this.viewValue = viewValue;
            this.startTimeAsNodeValue = startTime;
            this.startTime = AbstractElementMerger.parseDate(startTime);
            this.stopTimeAsNodeValue = stopTime;
            this.stopTime = AbstractElementMerger.parseDate(stopTime);
            this.bandSet = bandSet;
            this.value = value;
        }

        boolean belongsToNode(NewNode otherNode) throws PDUStitchingException {
            return this.belongsToNode(otherNode.gridValue, otherNode.viewValue, otherNode.startTimeAsNodeValue, otherNode.stopTimeAsNodeValue, otherNode.bandSet);
        }

        boolean belongsToNode(String otherGrid, String otherView, String otherStartTime, String otherStopTime, String otherBandSet) throws PDUStitchingException {
            if (!(this.bandSet.equals(otherBandSet) && this.gridValue.equals(otherGrid) && this.viewValue.equals(otherView))) {
                return false;
            }
            Date otherStartTimeAsDate = AbstractElementMerger.parseDate(otherStartTime);
            if (otherStartTimeAsDate.getTime() - this.stopTime.getTime() > 450L) {
                return false;
            }
            Date otherStopTimeAsDate = AbstractElementMerger.parseDate(otherStopTime);
            return this.startTime.getTime() - otherStopTimeAsDate.getTime() < 450L;
        }

        void incorporate(NewNode otherNode) throws PDUStitchingException {
            this.incorporate(otherNode.startTimeAsNodeValue, otherNode.stopTimeAsNodeValue, otherNode.value);
        }

        void incorporate(String otherStartTime, String otherStopTime, int otherValue) throws PDUStitchingException {
            Date otherStopTimeAsStopDate = AbstractElementMerger.parseDate(otherStopTime);
            Date otherStartTimeAsStartDate = AbstractElementMerger.parseDate(otherStartTime);
            if (this.startTime.before(otherStopTimeAsStopDate)) {
                this.stopTime = otherStopTimeAsStopDate;
                this.stopTimeAsNodeValue = otherStopTime;
            } else {
                this.startTime = otherStartTimeAsStartDate;
                this.startTimeAsNodeValue = otherStartTime;
            }
            this.value += otherValue;
        }
    }
}

