/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.List;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSizeHandler;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class ImageSizesMerger
extends AbstractElementMerger {
    ImageSizesMerger() {
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        ImageSize[] imageSizes = new ImageSize[fromParents.size()];
        for (int i = 0; i < imageSizes.length; ++i) {
            imageSizes[i] = ImageSizeHandler.extractImageSizeFromNode(fromParents.get(i), "");
        }
        ImageSize targetImageSize = ImageSizeHandler.createTargetImageSize(imageSizes);
        String grid = fromParents.get(0).getAttributes().item(0).getNodeValue();
        toParent.setAttribute("grid", grid);
        Element startOffsetElement = toDocument.createElement("sentinel3:startOffset");
        Text startOffsetTextNode = toDocument.createTextNode("" + targetImageSize.getStartOffset());
        startOffsetElement.appendChild(startOffsetTextNode);
        toParent.appendChild(startOffsetElement);
        Element trackOffsetElement = toDocument.createElement("sentinel3:trackOffset");
        Text trackOffsetTextNode = toDocument.createTextNode("" + targetImageSize.getTrackOffset());
        trackOffsetElement.appendChild(trackOffsetTextNode);
        toParent.appendChild(trackOffsetElement);
        Element rowsElement = toDocument.createElement("sentinel3:rows");
        Text rowsTextNode = toDocument.createTextNode("" + targetImageSize.getRows());
        rowsElement.appendChild(rowsTextNode);
        toParent.appendChild(rowsElement);
        Element columnsElement = toDocument.createElement("sentinel3:columns");
        Text columnsTextNode = toDocument.createTextNode("" + targetImageSize.getColumns());
        columnsElement.appendChild(columnsTextNode);
        toParent.appendChild(columnsElement);
    }
}

