/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Validator {
    public static void validate(File[] manifestFiles) throws IOException {
        String msg = "Cannot create document from manifest XML file";
        Document[] manifests = new Document[manifestFiles.length];
        try {
            for (int i = 0; i < manifestFiles.length; ++i) {
                manifests[i] = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(manifestFiles[i]);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(MessageFormat.format("{0}: {1}", "Cannot create document from manifest XML file", e.getMessage()));
        }
        try {
            Validator.validateOrbitReference(manifests);
            Validator.validateAdjacency(manifests);
        }
        catch (PDUStitchingException e) {
            throw new IOException(e.getMessage());
        }
    }

    static void validateOrbitReference(Document[] manifests) throws PDUStitchingException {
        String[] tagNames;
        if (manifests.length < 2) {
            return;
        }
        for (String tagName : tagNames = new String[]{"sentinel-safe:orbitNumber", "sentinel-safe:relativeOrbitNumber", "sentinel-safe:passNumber", "sentinel-safe:relativePassNumber", "sentinel-safe:cycleNumber", "sentinel-safe:phaseIdentifier", "sentinel-safe:epoch", "sentinel-safe:x", "sentinel-safe:y", "sentinel-safe:z"}) {
            NodeList referenceNodes = manifests[0].getElementsByTagName(tagName);
            for (int j = 1; j < manifests.length; ++j) {
                NodeList testNodes = manifests[j].getElementsByTagName(tagName);
                if (referenceNodes.getLength() != testNodes.getLength()) {
                    throw new PDUStitchingException("Invalid orbit reference due to different element " + tagName);
                }
                for (int k = 0; k < referenceNodes.getLength(); ++k) {
                    referenceNodes.item(k).normalize();
                    testNodes.item(k).normalize();
                    if (referenceNodes.item(k).isEqualNode(testNodes.item(k))) continue;
                    throw new PDUStitchingException("Invalid orbit reference due to different element " + tagName);
                }
            }
        }
    }

    static void validateAdjacency(Document[] manifests) throws PDUStitchingException {
        int[] startOffsets = new int[manifests.length];
        int[] endOffsets = new int[manifests.length];
        block0: for (int k = 0; k < manifests.length; ++k) {
            Document manifest = manifests[k];
            NodeList nadirImageSizes = manifest.getElementsByTagName("slstr:nadirImageSize");
            for (int i = 0; i < nadirImageSizes.getLength(); ++i) {
                Node nadirImageSize = nadirImageSizes.item(i);
                Node grid = nadirImageSize.getAttributes().getNamedItem("grid");
                startOffsets[k] = -1;
                endOffsets[k] = 0;
                if (grid == null || !grid.getNodeValue().equals("0.5 km stripe A")) continue;
                NodeList childNodes = nadirImageSize.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    if (childNodes.item(j).getNodeName().equals("sentinel3:startOffset")) {
                        startOffsets[k] = Integer.parseInt(childNodes.item(j).getTextContent());
                        continue;
                    }
                    if (!childNodes.item(j).getNodeName().equals("sentinel3:rows")) continue;
                    endOffsets[k] = startOffsets[k] + Integer.parseInt(childNodes.item(j).getTextContent());
                }
                continue block0;
            }
        }
        Arrays.sort(startOffsets);
        Arrays.sort(endOffsets);
        for (int i = 0; i < manifests.length - 1; ++i) {
            if (endOffsets[i] == startOffsets[i + 1]) continue;
            throw new PDUStitchingException("Selected units must be adjacent");
        }
    }
}

