/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageSizeHandler {
    public static ImageSize createTargetImageSize(ImageSize[] imageSizes) {
        int startOffset = Integer.MAX_VALUE;
        int trackOffset = Integer.MAX_VALUE;
        int highestStart = Integer.MIN_VALUE;
        int highestTrack = Integer.MIN_VALUE;
        for (ImageSize imageSize : imageSizes) {
            if (imageSize.getStartOffset() < startOffset) {
                startOffset = imageSize.getStartOffset();
            }
            if (imageSize.getTrackOffset() < trackOffset) {
                trackOffset = imageSize.getTrackOffset();
            }
            if (imageSize.getStartOffset() + imageSize.getRows() > highestStart) {
                highestStart = imageSize.getStartOffset() + imageSize.getRows();
            }
            if (imageSize.getTrackOffset() + imageSize.getColumns() <= highestTrack) continue;
            highestTrack = imageSize.getTrackOffset() + imageSize.getColumns();
        }
        return new ImageSize(imageSizes[0].getIdentifier(), startOffset, trackOffset, highestStart - startOffset, highestTrack - trackOffset);
    }

    public static ImageSize[] extractImageSizes(Document manifestDocument) {
        int i;
        NodeList nadirElements = manifestDocument.getElementsByTagName("slstr:nadirImageSize");
        NodeList obliqueElements = manifestDocument.getElementsByTagName("slstr:obliqueImageSize");
        ImageSize[] imageSizes = new ImageSize[obliqueElements.getLength() + obliqueElements.getLength()];
        for (i = 0; i < nadirElements.getLength(); ++i) {
            imageSizes[i] = ImageSizeHandler.extractImageSizeFromNode(nadirElements.item(i), "n");
        }
        for (i = 0; i < obliqueElements.getLength(); ++i) {
            imageSizes[nadirElements.getLength() + i] = ImageSizeHandler.extractImageSizeFromNode(obliqueElements.item(i), "o");
        }
        return imageSizes;
    }

    public static ImageSize extractImageSizeFromNode(Node element, String idExtension) {
        String id = ImageSizeHandler.getId(element.getAttributes().getNamedItem("grid").getNodeValue()) + idExtension;
        int startOffset = -1;
        int trackOffset = -1;
        int rows = -1;
        int columns = -1;
        NodeList elementChildNodes = element.getChildNodes();
        for (int j = 0; j < elementChildNodes.getLength(); ++j) {
            Node node = elementChildNodes.item(j);
            if (node.getNodeName().equals("sentinel3:startOffset")) {
                startOffset = Integer.parseInt(node.getChildNodes().item(0).getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("sentinel3:trackOffset")) {
                trackOffset = Integer.parseInt(node.getChildNodes().item(0).getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("sentinel3:rows")) {
                rows = Integer.parseInt(node.getChildNodes().item(0).getNodeValue());
                continue;
            }
            if (!node.getNodeName().equals("sentinel3:columns")) continue;
            columns = Integer.parseInt(node.getChildNodes().item(0).getNodeValue());
        }
        return new ImageSize(id, startOffset, trackOffset, rows, columns);
    }

    private static String getId(String gridName) {
        switch (gridName) {
            case "1 km": {
                return "i";
            }
            case "0.5 km stripe A": {
                return "a";
            }
            case "0.5 km stripe B": {
                return "b";
            }
            case "0.5 km TDI": {
                return "c";
            }
            case "Tie Points": {
                return "t";
            }
        }
        return "";
    }
}

