/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.List;
import javax.swing.text.NumberFormatter;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

class FootprintMerger
extends AbstractElementMerger {
    private static final String NAME_OF_GEODETIC_NC_FILE = "geodetic_tx.nc";
    private static final String NAME_OF_LAT_VARIABLE = "latitude_tx";
    private static final String NAME_OF_LON_VARIABLE = "longitude_tx";
    private final File productDir;
    private final NumberFormatter numberFormatter;
    private StringBuilder footprintBuilder;

    FootprintMerger(File productDir) {
        this.productDir = productDir;
        DecimalFormat format = new DecimalFormat("###0.0000");
        DecimalFormatSymbols newSymbols = new DecimalFormatSymbols();
        newSymbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(newSymbols);
        this.numberFormatter = new NumberFormatter(format);
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        Element posListElement = toDocument.createElement("gml:posList");
        String footprint = this.createFootprint(fromParents);
        this.addTextToNode(posListElement, footprint, toDocument);
        toParent.appendChild(posListElement);
    }

    private String createFootprint(List<Node> fromParents) {
        try {
            int i;
            File file = new File(this.productDir + File.separator + NAME_OF_GEODETIC_NC_FILE);
            if (!file.exists()) {
                return this.createFootprintWithoutNcFile(fromParents);
            }
            NetcdfFile geodeticNcFile = NetcdfFileOpener.open((Object)file);
            if (geodeticNcFile == null) {
                return this.createFootprintWithoutNcFile(fromParents);
            }
            List geodeticVariables = geodeticNcFile.getVariables();
            Variable latVariable = null;
            Variable lonVariable = null;
            for (Variable variable : geodeticVariables) {
                if (variable.getFullName().equals(NAME_OF_LAT_VARIABLE)) {
                    latVariable = variable;
                    continue;
                }
                if (!variable.getFullName().equals(NAME_OF_LON_VARIABLE)) continue;
                lonVariable = variable;
            }
            if (latVariable == null || lonVariable == null) {
                return this.createFootprintWithoutNcFile(fromParents);
            }
            int numTieRows = latVariable.getDimension(0).getLength();
            int numTieColumns = lonVariable.getDimension(1).getLength();
            int[] stride = new int[]{200, 12};
            this.footprintBuilder = new StringBuilder();
            Section leftBorderSection = new Section(new int[]{0, 0}, new int[]{numTieRows, 1}, stride);
            Section lowerBorderSection = new Section(new int[]{numTieRows - 1, 0}, new int[]{1, numTieColumns}, stride);
            Section lowerRightPixelSection = new Section(new int[]{numTieRows - 1, numTieColumns - 1}, new int[]{1, 1});
            Section rightBorderSection = new Section(new int[]{0, numTieColumns - 1}, new int[]{numTieRows, 1}, stride);
            Section upperBorderSection = new Section(new int[]{0, 0}, new int[]{1, numTieColumns}, stride);
            double[] leftBorderLats = (double[])latVariable.read(leftBorderSection).get1DJavaArray(Double.class);
            double[] leftBorderLons = (double[])lonVariable.read(leftBorderSection).get1DJavaArray(Double.class);
            double[] lowerBorderLats = (double[])latVariable.read(lowerBorderSection).get1DJavaArray(Double.class);
            double[] lowerBorderLons = (double[])lonVariable.read(lowerBorderSection).get1DJavaArray(Double.class);
            double lowerRightLat = latVariable.read(lowerRightPixelSection).getDouble(0);
            double lowerRightLon = lonVariable.read(lowerRightPixelSection).getDouble(0);
            double[] rightBorderLats = (double[])latVariable.read(rightBorderSection).get1DJavaArray(Double.class);
            double[] rightBorderLons = (double[])lonVariable.read(rightBorderSection).get1DJavaArray(Double.class);
            double[] upperBorderLats = (double[])latVariable.read(upperBorderSection).get1DJavaArray(Double.class);
            double[] upperBorderLons = (double[])lonVariable.read(upperBorderSection).get1DJavaArray(Double.class);
            int numX = lowerBorderLats.length;
            int numY = leftBorderLats.length;
            for (i = 0; i < numY; ++i) {
                this.append(leftBorderLats[i], leftBorderLons[i]);
            }
            if (!this.areEqual(leftBorderLats[numY - 1], lowerBorderLats[0])) {
                this.append(lowerBorderLats[0]);
            }
            if (!this.areEqual(leftBorderLons[numY - 1], lowerBorderLons[0])) {
                this.append(lowerBorderLons[0]);
            }
            for (i = 1; i < numX; ++i) {
                this.append(lowerBorderLats[i], lowerBorderLons[i]);
            }
            if (!this.areEqual(lowerBorderLats[numX - 1], lowerRightLat)) {
                this.append(lowerRightLat);
            }
            if (!this.areEqual(lowerBorderLons[numX - 1], lowerRightLon)) {
                this.append(lowerRightLon);
            }
            if (!this.areEqual(rightBorderLats[numY - 1], lowerRightLat)) {
                this.append(rightBorderLats[numY - 1]);
            }
            if (!this.areEqual(rightBorderLons[numY - 1], lowerRightLon)) {
                this.append(rightBorderLons[numY - 1]);
            }
            for (i = numY - 2; i >= 0; --i) {
                this.append(rightBorderLats[i], rightBorderLons[i]);
            }
            if (!this.areEqual(upperBorderLats[numX - 1], rightBorderLats[0])) {
                this.append(upperBorderLats[numX - 1]);
            }
            if (!this.areEqual(upperBorderLons[numX - 1], rightBorderLons[0])) {
                this.append(upperBorderLons[numX - 1]);
            }
            for (i = numX - 2; i > 0; --i) {
                this.append(upperBorderLats[i], upperBorderLons[i]);
            }
            this.footprintBuilder.append(this.format(upperBorderLats[0])).append(" ").append(this.format(upperBorderLons[0]));
            return this.footprintBuilder.toString();
        }
        catch (IOException | ParseException | InvalidRangeException e) {
            return this.createFootprintWithoutNcFile(fromParents);
        }
    }

    private void append(double d) throws ParseException {
        this.footprintBuilder.append(this.format(d)).append(" ");
    }

    private void append(double d1, double d2) throws ParseException {
        this.footprintBuilder.append(this.format(d1)).append(" ").append(this.format(d2)).append(" ");
    }

    private String format(double d) throws ParseException {
        return this.numberFormatter.valueToString(d);
    }

    private boolean areEqual(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-4;
    }

    private String createFootprintWithoutNcFile(List<Node> fromParents) {
        this.footprintBuilder = new StringBuilder();
        block0: for (int i = 0; i < fromParents.size(); ++i) {
            NodeList childNodes = fromParents.get(i).getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                if (!childNodes.item(j).getNodeName().equals("gml:posList")) continue;
                this.footprintBuilder.append(childNodes.item(j).getTextContent());
                if (i >= fromParents.size() - 1) continue block0;
                this.footprintBuilder.append(" ");
                continue block0;
            }
        }
        return this.footprintBuilder.toString();
    }
}

