/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.esa.snap.core.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DataObjectMerger
extends AbstractElementMerger {
    private final String fileLocation;

    DataObjectMerger(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        String fileName = this.getFileName(fromParents, toParent);
        File file = this.getFile(fileName, toParent);
        long size = file.length();
        Element byteStreamElement = toDocument.createElement("byteStream");
        toParent.appendChild(byteStreamElement);
        byteStreamElement.setAttribute("mimeType", "application/x-netcdf");
        byteStreamElement.setAttribute("size", String.valueOf(size));
        Element fileLocationElement = toDocument.createElement("fileLocation");
        byteStreamElement.appendChild(fileLocationElement);
        fileLocationElement.setAttribute("locatorType", "URL");
        fileLocationElement.setAttribute("href", fileName);
        Element checksumElement = toDocument.createElement("checksum");
        byteStreamElement.appendChild(checksumElement);
        checksumElement.setAttribute("checksumName", "MD5");
        String checksum = DataObjectMerger.getChecksum(file);
        if (checksum.equals("")) {
            throw new PDUStitchingException("Could not create checksum for file " + fileName);
        }
        this.addTextToNode(checksumElement, checksum, toDocument);
    }

    private File getFile(String fileName, Element toParent) throws PDUStitchingException {
        if (StringUtils.isNullOrEmpty((String)fileName)) {
            throw new PDUStitchingException("No href attribute given for dataObject with ID " + toParent.getAttribute("ID"));
        }
        File file = new File(this.fileLocation, fileName);
        if (!file.exists()) {
            throw new PDUStitchingException("Invalid href attribute given for dataObject with ID " + toParent.getAttribute("ID"));
        }
        return file;
    }

    private String getFileName(List<Node> fromParents, Element toParent) throws PDUStitchingException {
        String fileName = "";
        block0: for (int i = 0; i < fromParents.size(); ++i) {
            NodeList dataObjectChildNodes = fromParents.get(i).getChildNodes();
            for (int l = 0; l < dataObjectChildNodes.getLength(); ++l) {
                if (!dataObjectChildNodes.item(l).getNodeName().equals("byteStream")) continue;
                NodeList byteStreamChildNodes = dataObjectChildNodes.item(l).getChildNodes();
                for (int k = 0; k < byteStreamChildNodes.getLength(); ++k) {
                    if (!byteStreamChildNodes.item(k).getNodeName().equals("fileLocation")) continue;
                    NamedNodeMap fileLocationAttributes = byteStreamChildNodes.item(k).getAttributes();
                    Node hrefAttribute = fileLocationAttributes.getNamedItem("href");
                    if (hrefAttribute != null) {
                        if (i == 0) {
                            fileName = hrefAttribute.getNodeValue();
                            continue block0;
                        }
                        if (fileName.equals(hrefAttribute.getNodeValue())) continue block0;
                        throw new PDUStitchingException("Different href attributes given for dataObject with ID " + toParent.getAttribute("ID"));
                    }
                    throw new PDUStitchingException("No href attribute given for dataObject with ID " + toParent.getAttribute("ID"));
                }
                continue block0;
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getChecksum(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileChannel channel = inputStream.getChannel();
            ByteBuffer buff = ByteBuffer.allocate(2048);
            while (channel.read(buff) != -1) {
                buff.flip();
                md.update(buff);
                buff.clear();
            }
            byte[] digest = md.digest();
            StringBuilder digestResult = new StringBuilder();
            for (byte aDigest : digest) {
                digestResult.append(Integer.toString((aDigest & 0xFF) + 256, 16).substring(1));
            }
            String string = digestResult.toString();
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            String string = "";
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

