/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.manifest;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.s3tbx.slstr.pdu.stitching.manifest.AbstractElementMerger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ClassificationSummaryMerger
extends AbstractElementMerger {
    private final ImageSize[][] imageSizes;

    ClassificationSummaryMerger(ImageSize[][] imageSizes) {
        this.imageSizes = imageSizes;
    }

    @Override
    public void mergeNodes(List<Node> fromParents, Element toParent, Document toDocument) throws PDUStitchingException {
        int i;
        double[] weights = this.getWeights(fromParents);
        Map<String, Double>[] percentagesPerPDU = this.getPercentagesFromParents(fromParents);
        ArrayList<String> elementNames = new ArrayList<String>();
        ArrayList<Double> percentageValues = new ArrayList<Double>();
        for (i = 0; i < fromParents.size(); ++i) {
            for (Map.Entry<String, Double> percentage : percentagesPerPDU[i].entrySet()) {
                String elementName = percentage.getKey();
                int index = elementNames.indexOf(elementName);
                if (index >= 0) {
                    percentageValues.set(index, (Double)percentageValues.get(index) + weights[i] * percentage.getValue());
                    continue;
                }
                elementNames.add(elementName);
                percentageValues.add(weights[i] * percentage.getValue());
            }
        }
        for (i = 0; i < elementNames.size(); ++i) {
            Element newElement = toDocument.createElement((String)elementNames.get(i));
            newElement.setAttribute("percentage", ((Double)percentageValues.get(i)).toString());
            toParent.appendChild(newElement);
        }
    }

    private Map<String, Double>[] getPercentagesFromParents(List<Node> fromParents) throws PDUStitchingException {
        Map[] percentages = new Map[fromParents.size()];
        for (int i = 0; i < fromParents.size(); ++i) {
            percentages[i] = new LinkedHashMap();
            NodeList childNodes = fromParents.get(i).getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node percentageAttribute;
                Node childNode = childNodes.item(j);
                if (!childNode.hasAttributes() || (percentageAttribute = childNode.getAttributes().getNamedItem("percentage")) == null) continue;
                percentages[i].put(childNode.getNodeName(), Double.parseDouble(percentageAttribute.getNodeValue()));
            }
        }
        return percentages;
    }

    private double[] getWeights(List<Node> fromParents) throws PDUStitchingException {
        int[] numberOfPixels = new int[fromParents.size()];
        int totalNumberOfPixels = 0;
        block0: for (int i = 0; i < fromParents.size(); ++i) {
            Node gridNode = fromParents.get(i).getAttributes().getNamedItem("grid");
            if (gridNode == null) {
                throw new PDUStitchingException("Grid node expected in classification summary");
            }
            String grid = gridNode.getNodeValue();
            String id = ClassificationSummaryMerger.getId(grid);
            for (ImageSize imageSize : this.imageSizes[i]) {
                if (!imageSize.getIdentifier().equals(id)) continue;
                numberOfPixels[i] = imageSize.getColumns() * imageSize.getRows();
                totalNumberOfPixels += numberOfPixels[i];
                continue block0;
            }
        }
        double[] weights = new double[fromParents.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = (double)numberOfPixels[i] / (double)totalNumberOfPixels;
        }
        return weights;
    }

    private static String getId(String gridName) {
        switch (gridName) {
            case "1 km": {
                return "in";
            }
            case "0.5 km stripe A": {
                return "an";
            }
            case "0.5 km stripe B": {
                return "bn";
            }
            case "0.5 km TDI": {
                return "cn";
            }
        }
        return "";
    }
}

