/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OrbitReferenceChecker {
    public static void validateOrbitReference(File[] manifestFiles) throws IOException {
        String msg = "Cannot create document from manifest XML file.";
        Document[] manifests = new Document[manifestFiles.length];
        try {
            for (int i = 0; i < manifestFiles.length; ++i) {
                manifests[i] = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(manifestFiles[i]);
            }
            OrbitReferenceChecker.validateOrbitReference(manifests);
        }
        catch (ParserConfigurationException | PDUStitchingException | SAXException e) {
            throw new IOException("Cannot create document from manifest XML file.: " + e.getMessage());
        }
    }

    public static void validateOrbitReference(Document[] manifests) throws PDUStitchingException {
        String[] tagNames;
        if (manifests.length < 2) {
            return;
        }
        for (String tagName : tagNames = new String[]{"sentinel-safe:orbitNumber", "sentinel-safe:relativeOrbitNumber", "sentinel-safe:passNumber", "sentinel-safe:relativePassNumber", "sentinel-safe:cycleNumber", "sentinel-safe:phaseIdentifier", "sentinel-safe:epoch", "sentinel-safe:x", "sentinel-safe:y", "sentinel-safe:z"}) {
            NodeList referenceNodes = manifests[0].getElementsByTagName(tagName);
            for (int j = 1; j < manifests.length; ++j) {
                NodeList testNodes = manifests[j].getElementsByTagName(tagName);
                if (referenceNodes.getLength() != testNodes.getLength()) {
                    throw new PDUStitchingException("Invalid orbit reference due to different element " + tagName);
                }
                for (int k = 0; k < referenceNodes.getLength(); ++k) {
                    referenceNodes.item(k).normalize();
                    testNodes.item(k).normalize();
                    if (referenceNodes.item(k).isEqualNode(testNodes.item(k))) continue;
                    throw new PDUStitchingException("Invalid orbit reference due to different element " + tagName);
                }
            }
        }
    }
}

