/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import com.bc.ceres.binding.converters.DateFormatConverter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.slstr.pdu.stitching.ImageSize;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingException;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

class NcFileStitcher {
    private static final String PRODUCT_NAME = "product_name";
    private static final String CREATION_TIME = "creation_time";

    NcFileStitcher() {
    }

    static File stitchNcFiles(String fileName, File targetDirectory, Date creationDate, File[] ncFiles, ImageSize targetImageSize, ImageSize[] imageSizes) throws IOException, PDUStitchingException {
        NetcdfFile[] inputFiles = new NetcdfFile[ncFiles.length];
        ArrayList[] globalAttributes = new ArrayList[ncFiles.length];
        List[] dimensions = new List[ncFiles.length];
        List[] variables = new List[ncFiles.length];
        for (int i = 0; i < ncFiles.length; ++i) {
            inputFiles[i] = NetcdfFileOpener.open((Object)ncFiles[i]);
            globalAttributes[i] = inputFiles[i].getGlobalAttributes();
            dimensions[i] = inputFiles[i].getDimensions();
            variables[i] = inputFiles[i].getVariables();
        }
        File file = new File(targetDirectory, fileName);
        NFileWriteable netcdfWriteable = NWritableFactory.create((String)file.getAbsolutePath(), (String)"netcdf4");
        NcFileStitcher.setGlobalAttributes(netcdfWriteable, globalAttributes, targetDirectory.getName(), creationDate);
        NcFileStitcher.setDimensions(netcdfWriteable, dimensions, targetImageSize, variables);
        Map<String, Array> variableToArrayMap = NcFileStitcher.defineVariables(netcdfWriteable, variables, targetImageSize, imageSizes);
        netcdfWriteable.create();
        for (String variableName : variableToArrayMap.keySet()) {
            netcdfWriteable.findVariable(variableName).writeFully(variableToArrayMap.get(variableName));
        }
        netcdfWriteable.close();
        for (NetcdfFile inputFile : inputFiles) {
            inputFile.close();
        }
        return file;
    }

    private static Map<String, Array> defineVariables(NFileWriteable netcdfWriteable, List<Variable>[] variableLists, ImageSize targetImageSize, ImageSize[] imageSizes) throws PDUStitchingException, IOException {
        HashMap<String, Array> variableToArray = new HashMap<String, Array>();
        ArrayList<String> namesOfAddedVariables = new ArrayList<String>();
        for (int i = 0; i < variableLists.length; ++i) {
            List<Variable> variables = variableLists[i];
            for (Variable variable : variables) {
                String variableName = variable.getFullName();
                if (namesOfAddedVariables.contains(variableName) || variable.getDimensions().size() <= 0) continue;
                NcFileStitcher.checkWhetherVariableHasSameDimensionsAcrossFiles(i, variable, variableLists);
                NcFileStitcher.addVariableToWritable(netcdfWriteable, variable);
                NVariable nVariable = netcdfWriteable.findVariable(variableName);
                int indexOfRowDimension = NcFileStitcher.getIndexOfRowDimension(variable.getDimensions());
                if (indexOfRowDimension < 0) {
                    variableToArray.put(variableName, NcFileStitcher.getValidArrayFromVariable(variable));
                } else {
                    Array nVariableArray = NcFileStitcher.createStitchedArray(variable, targetImageSize, imageSizes, indexOfRowDimension, variableLists);
                    variableToArray.put(variableName, nVariableArray);
                }
                NcFileStitcher.addVariableAttributes(nVariable, variable, i, variableLists);
                namesOfAddedVariables.add(variableName);
            }
        }
        return variableToArray;
    }

    private static Array getValidArrayFromVariable(Variable variable) throws IOException {
        Array array = variable.read();
        if (variable.getDataType().isString()) {
            IndexIterator indexIterator = array.getIndexIterator();
            while (indexIterator.hasNext()) {
                if (indexIterator.next() != null) continue;
                indexIterator.setObjectCurrent((Object)"");
            }
        }
        return array;
    }

    private static void addVariableToWritable(NFileWriteable netcdfWriteable, Variable variable) throws IOException {
        if (variable.getDataType().isString()) {
            netcdfWriteable.addVariable(variable.getFullName(), variable.getDataType(), variable.isUnsigned(), null, variable.getDimensionsString(), 0);
        } else {
            netcdfWriteable.addVariable(variable.getFullName(), variable.getDataType(), variable.isUnsigned(), null, variable.getDimensionsString());
        }
    }

    private static Array createStitchedArray(Variable variable, ImageSize targetImageSize, ImageSize[] imageSizes, int indexOfRowDimension, List<Variable>[] variableLists) throws IOException {
        String variableName = variable.getFullName();
        int[] sectionSizes = new int[variableLists.length];
        int[][] sourceOffsets = new int[variableLists.length][];
        Variable[] fileVariables = new Variable[variableLists.length];
        for (int i = 0; i < variableLists.length; ++i) {
            Variable fileVariable = NcFileStitcher.getVariableFromList(variableName, variableLists[i]);
            if (fileVariable == null) continue;
            fileVariables[i] = fileVariable;
            sectionSizes[i] = NcFileStitcher.determineSectionSize(indexOfRowDimension, fileVariable);
            sourceOffsets[i] = NcFileStitcher.determineSourceOffsets(sectionSizes[i], fileVariable);
        }
        int[] rowOffsets = new int[imageSizes.length];
        int[] numberOfRows = new int[imageSizes.length];
        for (int j = 0; j < imageSizes.length; ++j) {
            rowOffsets[j] = imageSizes[j].getStartOffset() - targetImageSize.getStartOffset();
            numberOfRows[j] = imageSizes[j].getRows();
        }
        int[][] destinationOffsets = NcFileStitcher.determineDestinationOffsets(rowOffsets, numberOfRows, sectionSizes, sourceOffsets);
        int[] nVariableShape = new int[variable.getDimensions().size()];
        for (int j = 0; j < nVariableShape.length; ++j) {
            nVariableShape[j] = ((Dimension)variable.getDimensions().get(j)).getFullName().equals("rows") ? targetImageSize.getRows() : ((Dimension)variable.getDimensions().get(j)).getLength();
        }
        Array nVariableArray = Array.factory((DataType)variable.getDataType(), (int[])nVariableShape);
        for (int j = 0; j < variableLists.length; ++j) {
            Variable fileVariable = fileVariables[j];
            if (fileVariable == null) continue;
            Array fileArray = fileVariable.read();
            for (int l = 0; l < sourceOffsets[j].length; ++l) {
                Array.arraycopy((Array)fileArray, (int)sourceOffsets[j][l], (Array)nVariableArray, (int)destinationOffsets[j][l], (int)sectionSizes[j]);
            }
        }
        return nVariableArray;
    }

    private static void addVariableAttributes(NVariable nVariable, Variable variable, int variableIndex, List<Variable>[] variableLists) throws IOException {
        String variableName = variable.getFullName();
        List variableAttributes = variable.getAttributes();
        if (variableIndex < variableLists.length) {
            for (Attribute variableAttribute : variableAttributes) {
                for (int k = variableIndex; k < variableLists.length; ++k) {
                    Variable otherVariable = NcFileStitcher.getVariableFromList(variableName, variableLists[k]);
                    if (otherVariable == null) continue;
                    List otherVariableAttributes = otherVariable.getAttributes();
                    Attribute otherAttribute = NcFileStitcher.getAttributeFromList(variableAttribute.getFullName(), otherVariableAttributes);
                    if (otherAttribute == null || NcFileStitcher.areAttributeValuesEqual(variableAttribute, otherAttribute)) continue;
                    NcFileStitcher.addAttributeToNVariable(nVariable, otherAttribute, k);
                }
                NcFileStitcher.addAttributeToNVariable(nVariable, variableAttribute);
            }
        }
    }

    private static void checkWhetherVariableHasSameDimensionsAcrossFiles(int listIndex, Variable variable, List<Variable>[] variableLists) throws PDUStitchingException {
        String variableName = variable.getFullName();
        for (int j = listIndex; j < variableLists.length; ++j) {
            Variable otherVariable = NcFileStitcher.getVariableFromList(variableName, variableLists[j]);
            if (otherVariable == null || otherVariable.getDimensionsString().equals(variable.getDimensionsString())) continue;
            throw new PDUStitchingException("Variable " + variableName + " has different dimensions" + "across input files");
        }
    }

    private static int getIndexOfRowDimension(List<Dimension> variableDimensions) {
        int indexOfRowDimension = -1;
        for (int j = 0; j < variableDimensions.size(); ++j) {
            Dimension variableDimension = variableDimensions.get(j);
            if (!variableDimension.getFullName().equals("rows")) continue;
            indexOfRowDimension = j;
            break;
        }
        return indexOfRowDimension;
    }

    private static void addAttributeToNVariable(NVariable nVariable, Attribute referenceAttribute, int index) throws IOException {
        NcFileStitcher.addAttributeToNVariable(nVariable, referenceAttribute.getFullName() + "_" + index, referenceAttribute);
    }

    private static void addAttributeToNVariable(NVariable nVariable, Attribute referenceAttribute) throws IOException {
        NcFileStitcher.addAttributeToNVariable(nVariable, referenceAttribute.getFullName(), referenceAttribute);
    }

    private static void addAttributeToNVariable(NVariable nVariable, String name, Attribute referenceAttribute) throws IOException {
        if (referenceAttribute.isArray()) {
            nVariable.addAttribute(name, referenceAttribute.getValues());
        } else if (referenceAttribute.isString()) {
            nVariable.addAttribute(name, referenceAttribute.getStringValue());
        } else {
            nVariable.addAttribute(name, referenceAttribute.getNumericValue(), referenceAttribute.isUnsigned());
        }
    }

    private static Dimension getDimensionFromList(String name, List<Dimension> dimensionList) {
        for (Dimension dimension : dimensionList) {
            if (!dimension.getFullName().equals(name)) continue;
            return dimension;
        }
        return null;
    }

    private static Attribute getAttributeFromList(String name, List<Attribute> attributeList) {
        for (Attribute attribute : attributeList) {
            if (!attribute.getFullName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    private static Variable getVariableFromList(String name, List<Variable> variableList) {
        for (Variable aVariableList : variableList) {
            if (!aVariableList.getFullName().equals(name)) continue;
            return aVariableList;
        }
        return null;
    }

    static int[][] determineDestinationOffsets(int[] rowOffsets, int[] numberOfRows, int[] sectionSizes, int[][] sourceOffsets) {
        int[][] destinationOffsets = new int[sectionSizes.length][];
        int allSectionsSize = 0;
        for (int sectionSize : sectionSizes) {
            allSectionsSize += sectionSize;
        }
        for (int i = 0; i < sectionSizes.length; ++i) {
            int fileOffset = rowOffsets[i] * (sectionSizes[i] / numberOfRows[i]);
            destinationOffsets[i] = new int[sourceOffsets[i].length];
            for (int j = 0; j < sourceOffsets[i].length; ++j) {
                destinationOffsets[i][j] = fileOffset + j * allSectionsSize;
            }
        }
        return destinationOffsets;
    }

    static int[] determineSourceOffsets(int sectionSize, Variable variable) {
        int totalSize = 1;
        for (int i = 0; i < variable.getDimensions().size(); ++i) {
            totalSize *= variable.getDimension(i).getLength();
        }
        int numberOfSections = totalSize / sectionSize;
        int[] sourceOffsets = new int[numberOfSections];
        for (int i = 0; i < numberOfSections; ++i) {
            sourceOffsets[i] = i * sectionSize;
        }
        return sourceOffsets;
    }

    static int determineSectionSize(int indexOfRowDimension, Variable variable) {
        int size = 1;
        for (int i = indexOfRowDimension; i < variable.getDimensions().size(); ++i) {
            size *= variable.getDimension(i).getLength();
        }
        return size;
    }

    static void setDimensions(NFileWriteable nFileWriteable, List<Dimension>[] dimensionLists, ImageSize targetImageSize, List<Variable>[] variableLists) throws PDUStitchingException, IOException {
        ArrayList<String> namesOfAddedDimensions = new ArrayList<String>();
        for (int i = 0; i < dimensionLists.length; ++i) {
            List<Dimension> dimensions = dimensionLists[i];
            for (Dimension dimension : dimensions) {
                String dimensionName = dimension.getFullName();
                if (namesOfAddedDimensions.contains(dimensionName)) continue;
                switch (dimensionName) {
                    case "rows": {
                        nFileWriteable.addDimension("rows", targetImageSize.getRows());
                        break;
                    }
                    case "columns": {
                        nFileWriteable.addDimension("columns", targetImageSize.getColumns());
                        break;
                    }
                    default: {
                        NcFileStitcher.checkWhetherEquallyNamedVariablesContainEqualValues(dimensionName, i, variableLists);
                        NcFileStitcher.checkWhetherDimensionLengthIsEqualAcrossAllEquallyNamedDimensions(dimension, i, dimensionLists);
                        nFileWriteable.addDimension(dimensionName, dimension.getLength());
                    }
                }
                namesOfAddedDimensions.add(dimensionName);
            }
        }
    }

    private static void checkWhetherEquallyNamedVariablesContainEqualValues(String dimensionName, int dimensionIndex, List<Variable>[] variableLists) throws IOException, PDUStitchingException {
        Array referenceVariableArray = null;
        for (int a = dimensionIndex; a < variableLists.length; ++a) {
            Variable variable = NcFileStitcher.getVariableFromList(dimensionName, variableLists[a]);
            if (variable == null) continue;
            Array variableArray = variable.read();
            if (referenceVariableArray != null && !NcFileStitcher.areArraysEqual(variableArray, referenceVariableArray)) {
                throw new PDUStitchingException("Values for " + variable.getFullName() + " are different across input files");
            }
            referenceVariableArray = variableArray;
        }
    }

    private static void checkWhetherDimensionLengthIsEqualAcrossAllEquallyNamedDimensions(Dimension dimension, int dimensionIndex, List<Dimension>[] dimensionLists) throws PDUStitchingException {
        int dimensionLength = dimension.getLength();
        String dimensionName = dimension.getFullName();
        for (int j = dimensionIndex; j < dimensionLists.length; ++j) {
            Dimension otherDimension = NcFileStitcher.getDimensionFromList(dimensionName, dimensionLists[j]);
            if (otherDimension == null || dimensionLength == otherDimension.getLength()) continue;
            throw new PDUStitchingException("Dimension " + dimensionName + " has different lengths across input files");
        }
    }

    static void setGlobalAttributes(NFileWriteable nFileWriteable, List<Attribute>[] globalAttributeLists, String parentDirectoryName, Date creationDate) throws IOException {
        DateFormatConverter globalAttributesDateFormatConverter = new DateFormatConverter((DateFormat)new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'"));
        ArrayList<String> namesOfAddedAttributes = new ArrayList<String>();
        for (int i = 0; i < globalAttributeLists.length; ++i) {
            List<Attribute> globalAttributes = globalAttributeLists[i];
            for (Attribute globalAttribute : globalAttributes) {
                String globalAttributeName = globalAttribute.getFullName();
                if (!namesOfAddedAttributes.contains(globalAttributeName)) {
                    Object value;
                    Attribute otherGlobalAttribute;
                    int j;
                    if (globalAttributeName.equals(PRODUCT_NAME)) {
                        nFileWriteable.addGlobalAttribute(PRODUCT_NAME, parentDirectoryName);
                    } else if (globalAttributeName.equals(CREATION_TIME)) {
                        nFileWriteable.addGlobalAttribute(CREATION_TIME, globalAttributesDateFormatConverter.format(creationDate));
                    } else if (globalAttribute.isArray()) {
                        Array values = globalAttribute.getValues();
                        for (j = i; j < globalAttributeLists.length; ++j) {
                            otherGlobalAttribute = NcFileStitcher.getAttributeFromList(globalAttributeName, globalAttributeLists[j]);
                            if (otherGlobalAttribute == null || values == otherGlobalAttribute.getValues()) continue;
                            nFileWriteable.addGlobalAttribute(globalAttributeName + "_" + j, otherGlobalAttribute.getValues().toString());
                            break;
                        }
                        nFileWriteable.addGlobalAttribute(globalAttributeName, values.toString());
                    } else if (globalAttribute.getDataType().isNumeric()) {
                        value = globalAttribute.getNumericValue();
                        for (j = i; j < globalAttributeLists.length; ++j) {
                            otherGlobalAttribute = NcFileStitcher.getAttributeFromList(globalAttributeName, globalAttributeLists[j]);
                            if (otherGlobalAttribute == null || value.equals(otherGlobalAttribute.getNumericValue())) continue;
                            nFileWriteable.addGlobalAttribute(globalAttributeName + "_" + j, otherGlobalAttribute.getNumericValue().toString());
                            break;
                        }
                        nFileWriteable.addGlobalAttribute(globalAttributeName, value.toString());
                    } else {
                        value = globalAttribute.getStringValue();
                        for (j = i; j < globalAttributeLists.length; ++j) {
                            otherGlobalAttribute = NcFileStitcher.getAttributeFromList(globalAttributeName, globalAttributeLists[j]);
                            if (otherGlobalAttribute == null || ((String)value).equals(otherGlobalAttribute.getStringValue())) continue;
                            nFileWriteable.addGlobalAttribute(globalAttributeName + "_" + j, otherGlobalAttribute.getStringValue());
                            break;
                        }
                        nFileWriteable.addGlobalAttribute(globalAttributeName, (String)value);
                    }
                }
                namesOfAddedAttributes.add(globalAttributeName);
            }
        }
    }

    private static boolean areAttributeValuesEqual(Attribute attribute1, Attribute attribute2) {
        if (attribute1.isArray()) {
            Array values1 = attribute1.getValues();
            Array values2 = attribute2.getValues();
            return NcFileStitcher.areArraysEqual(values1, values2);
        }
        if (attribute1.isString()) {
            String value1 = attribute1.getStringValue();
            String value2 = attribute2.getStringValue();
            return value1.equals(value2);
        }
        Number numericValue1 = attribute1.getNumericValue();
        Number numericValue2 = attribute2.getNumericValue();
        return numericValue1.equals(numericValue2);
    }

    private static boolean areArraysEqual(Array array1, Array array2) {
        int i = 0;
        while ((long)i < array1.getSize()) {
            if (!array1.getObject(i).equals(array2.getObject(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

