/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathFactory;
import org.esa.s3tbx.dataio.util.XPathHelper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathHelperTest {
    private static XPathHelper xPathHelper;
    private static Document xmlDoc;

    @BeforeClass
    public static void beforeClass() throws ParserConfigurationException, IOException, SAXException {
        xPathHelper = new XPathHelper(XPathFactory.newInstance().newXPath());
        String xmlString = "<xml>  <firstTag>    <innerTag>    <valueTag>A</valueTag>    <valueTag>B</valueTag>    <valueTag>A</valueTag>    </innerTag>  </firstTag>  <secondTag>    <valueTag>C</valueTag>  </secondTag></xml>";
        xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
    }

    @Test
    public void testGetString() throws Exception {
        Assert.assertEquals((Object)"C", (Object)xPathHelper.getString("/xml/secondTag/valueTag", (Node)xmlDoc));
    }

    @Test
    public void testGetNodeList() throws Exception {
        NodeList nodeList = xPathHelper.getNodeList("/xml/firstTag/innerTag/valueTag[.='A']", (Node)xmlDoc);
        Assert.assertEquals((long)2L, (long)nodeList.getLength());
        Node valueTagOne = nodeList.item(0);
        Assert.assertEquals((Object)"valueTag", (Object)valueTagOne.getNodeName());
        Assert.assertEquals((Object)"A", (Object)valueTagOne.getTextContent());
        Node valueTagTwo = nodeList.item(1);
        Assert.assertEquals((Object)"valueTag", (Object)valueTagTwo.getNodeName());
        Assert.assertEquals((Object)"A", (Object)valueTagTwo.getTextContent());
    }

    @Test
    public void testGetNode() throws Exception {
        Node node = xPathHelper.getNode("/xml/secondTag/valueTag", (Node)xmlDoc);
        Assert.assertEquals((Object)"C", (Object)node.getTextContent());
    }
}

