/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.awt.Color;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.s3.util.ColorProvider;
import org.junit.Before;
import org.junit.Test;

public class ColorProviderTest {
    private ColorProvider colorProvider;
    private Color firstDefaultColour;

    @Before
    public void setUp() {
        this.colorProvider = new ColorProvider();
        this.firstDefaultColour = new Color(0, 0, 255);
    }

    @Test
    public void testGetMaskForColor_coastline() throws Exception {
        Color coastlineColor = new Color(255, 0, 0);
        Color coastlineColor1 = this.colorProvider.getMaskColor("rtwftgcoastlinerttzg");
        Color coastlineColor2 = this.colorProvider.getMaskColor("csdfgCOASTLINEctfsg");
        Color coastlineColor3 = this.colorProvider.getMaskColor("csdfgCoAsTLiNectfsg");
        Color coastlineColor4 = this.colorProvider.getMaskColor("csdfgCoAsltInEctfsg");
        TestCase.assertEquals((Object)coastlineColor, (Object)coastlineColor1);
        TestCase.assertEquals((Object)coastlineColor, (Object)coastlineColor2);
        TestCase.assertEquals((Object)coastlineColor, (Object)coastlineColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)coastlineColor4);
    }

    @Test
    public void testGetMaskForColor_land() throws Exception {
        Color landColor = new Color(0, 127, 63);
        Color landColor1 = this.colorProvider.getMaskColor("yawsdelandaesd");
        Color landColor2 = this.colorProvider.getMaskColor("eswdLANDcdsfrg");
        Color landColor3 = this.colorProvider.getMaskColor("eswdLaNdcdsfrg");
        Color landColor4 = this.colorProvider.getMaskColor("eswdLnadcdsfrg");
        TestCase.assertEquals((Object)landColor, (Object)landColor1);
        TestCase.assertEquals((Object)landColor, (Object)landColor2);
        TestCase.assertEquals((Object)landColor, (Object)landColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)landColor4);
    }

    @Test
    public void testGetMaskForColor_water() throws Exception {
        Color waterColor = new Color(0, 63, 255);
        Color waterColor1 = this.colorProvider.getMaskColor("dfgbnzwaterkj");
        Color waterColor2 = this.colorProvider.getMaskColor("nfujiWATERcrtvf");
        Color waterColor3 = this.colorProvider.getMaskColor("nfujiWaTeRcrtvf");
        Color waterColor4 = this.colorProvider.getMaskColor("nfujiWeTaRcrtvf");
        TestCase.assertEquals((Object)waterColor, (Object)waterColor1);
        TestCase.assertEquals((Object)waterColor, (Object)waterColor2);
        TestCase.assertEquals((Object)waterColor, (Object)waterColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)waterColor4);
    }

    @Test
    public void testGetMaskForColor_lake() throws Exception {
        Color lakeColor = new Color(0, 127, 255);
        Color lakeColor1 = this.colorProvider.getMaskColor("dfgbnzlakekj");
        Color lakeColor2 = this.colorProvider.getMaskColor("nfujiLAKEcrtvf");
        Color lakeColor3 = this.colorProvider.getMaskColor("nfujiLaKecrtvf");
        Color lakeColor4 = this.colorProvider.getMaskColor("nfujilEKaRcrtvf");
        TestCase.assertEquals((Object)lakeColor, (Object)lakeColor1);
        TestCase.assertEquals((Object)lakeColor, (Object)lakeColor2);
        TestCase.assertEquals((Object)lakeColor, (Object)lakeColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)lakeColor4);
    }

    @Test
    public void testGetMaskForColor_ocean() throws Exception {
        Color oceanColor = new Color(0, 0, 191);
        Color oceanColor1 = this.colorProvider.getMaskColor("dfgbnzoceankj");
        Color oceanColor2 = this.colorProvider.getMaskColor("nfujiOCEANcrtvf");
        Color oceanColor3 = this.colorProvider.getMaskColor("nfujiOceaNcrtvf");
        Color oceanColor4 = this.colorProvider.getMaskColor("nfujiOCaeNcrtvf");
        TestCase.assertEquals((Object)oceanColor, (Object)oceanColor1);
        TestCase.assertEquals((Object)oceanColor, (Object)oceanColor2);
        TestCase.assertEquals((Object)oceanColor, (Object)oceanColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)oceanColor4);
    }

    @Test
    public void testGetMaskForColor_snow() throws Exception {
        Color snowColor = new Color(255, 255, 255);
        Color snowColor1 = this.colorProvider.getMaskColor("dfgbnzsnownkj");
        Color snowColor2 = this.colorProvider.getMaskColor("nfujiSNOWcrtvf");
        Color snowColor3 = this.colorProvider.getMaskColor("nfujiSnowcrtvf");
        Color snowColor4 = this.colorProvider.getMaskColor("nfujiSonWcrtvf");
        TestCase.assertEquals((Object)snowColor, (Object)snowColor1);
        TestCase.assertEquals((Object)snowColor, (Object)snowColor2);
        TestCase.assertEquals((Object)snowColor, (Object)snowColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)snowColor4);
    }

    @Test
    public void testGetMaskForColor_ice() throws Exception {
        Color iceColor = new Color(191, 255, 255);
        Color iceColor1 = this.colorProvider.getMaskColor("dfgbnicenkj");
        Color iceColor2 = this.colorProvider.getMaskColor("nfujiICEcrtvf");
        Color iceColor3 = this.colorProvider.getMaskColor("nfujiicEcrtvf");
        Color iceColor4 = this.colorProvider.getMaskColor("nfujiEcIcrtvf");
        TestCase.assertEquals((Object)iceColor, (Object)iceColor1);
        TestCase.assertEquals((Object)iceColor, (Object)iceColor2);
        TestCase.assertEquals((Object)iceColor, (Object)iceColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)iceColor4);
    }

    @Test
    public void testGetMaskForColor_cloud() throws Exception {
        Color cloudColor = new Color(191, 191, 191);
        Color cloudColor1 = this.colorProvider.getMaskColor("dfgbnzcloudnkj");
        Color cloudColor2 = this.colorProvider.getMaskColor("nfujiCLOUDcrtvf");
        Color cloudColor3 = this.colorProvider.getMaskColor("nfujiClOudcrtvf");
        Color cloudColor4 = this.colorProvider.getMaskColor("nfujiCluOdcrtvf");
        TestCase.assertEquals((Object)cloudColor, (Object)cloudColor1);
        TestCase.assertEquals((Object)cloudColor, (Object)cloudColor2);
        TestCase.assertEquals((Object)cloudColor, (Object)cloudColor3);
        TestCase.assertEquals((Object)this.firstDefaultColour, (Object)cloudColor4);
    }

    @Test
    public void testGetMaskForColor() {
        TestCase.assertEquals((Object)new Color(0, 0, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 255, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 255, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 0, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 255, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 0, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 127, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 127, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 255, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 0, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 0, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 0, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 127, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 127, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 127, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 255, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 255, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 255, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 0, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 127, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 127, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 127, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 255, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 0, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 63, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 63, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 63, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 63, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 127, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 191, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 191, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 191, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 191, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 191, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 255, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(0, 255, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 0, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 0, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 0, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 0, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 0, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 63, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 63, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 63, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 63, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 63, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 127, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 127, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 127, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 127, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 127, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 191, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 191, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 191, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 191, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 191, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 255, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 255, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 255, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 255, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(63, 255, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 0, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 0, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 63, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 63, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 63, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 63, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 63, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 127, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 127, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 191, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 191, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 191, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 191, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 191, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 255, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(127, 255, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 0, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 0, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 0, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 0, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 0, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 63, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 63, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 63, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 63, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 63, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 127, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 127, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 127, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 127, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 127, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 191, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 191, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 191, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 191, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 255, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 255, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 255, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(191, 255, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 0, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 0, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 63, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 63, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 63, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 63, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 63, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 127, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 127, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 191, 0), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 191, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 191, 127), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 191, 191), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 191, 255), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 255, 63), (Object)this.colorProvider.getMaskColor("dummy"));
        TestCase.assertEquals((Object)new Color(255, 255, 191), (Object)this.colorProvider.getMaskColor("dummy"));
    }
}

