/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.s3tbx.dataio.s3.synergy.CameraImageMosaic;
import org.junit.Assert;
import org.junit.Test;

public class CameraImageMosaicTest {
    @Test
    public void testCreateMosaicImage() throws Exception {
        RenderedOp image1 = this.createRenderedImage(1);
        RenderedOp image2 = this.createRenderedImage(2);
        RenderedOp image3 = this.createRenderedImage(3);
        RenderedOp image4 = this.createRenderedImage(4);
        RenderedOp image5 = this.createRenderedImage(5);
        RenderedImage mosaicImage = CameraImageMosaic.create((RenderedImage[])new RenderedImage[]{image1, image2, image3, image4, image5});
        Assert.assertNotNull((Object)mosaicImage);
        Assert.assertEquals((long)50L, (long)mosaicImage.getWidth());
        Assert.assertEquals((long)100L, (long)mosaicImage.getHeight());
        Raster data = mosaicImage.getData();
        for (int x = 0; x < mosaicImage.getWidth(); ++x) {
            Assert.assertEquals((long)(x / 10 + 1), (long)data.getSample(x, 0, 0));
        }
    }

    private RenderedOp createRenderedImage(int sampleValue) {
        return ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(100.0f), (Number[])new Integer[]{sampleValue}, null);
    }

    @Test
    public void testCreateMosaicMultiLevelImage() throws Exception {
        DefaultMultiLevelImage image1 = this.createMultiLevelImage(1, 2);
        DefaultMultiLevelImage image2 = this.createMultiLevelImage(2, 2);
        DefaultMultiLevelImage image3 = this.createMultiLevelImage(3, 2);
        DefaultMultiLevelImage image4 = this.createMultiLevelImage(4, 2);
        DefaultMultiLevelImage image5 = this.createMultiLevelImage(5, 2);
        MultiLevelImage mosaicImage = CameraImageMosaic.create((MultiLevelImage[])new MultiLevelImage[]{image1, image2, image3, image4, image5});
        Assert.assertNotNull((Object)mosaicImage);
        Assert.assertEquals((long)50L, (long)mosaicImage.getWidth());
        Assert.assertEquals((long)100L, (long)mosaicImage.getHeight());
        Assert.assertEquals((long)2L, (long)mosaicImage.getModel().getLevelCount());
        Raster dataL0 = mosaicImage.getImage(0).getData();
        for (int x = 0; x < mosaicImage.getImage(0).getWidth(); ++x) {
            Assert.assertEquals((long)(x / 10 + 1), (long)dataL0.getSample(x, 0, 0));
        }
        Raster dataL1 = mosaicImage.getImage(1).getData();
        for (int x = 0; x < mosaicImage.getImage(1).getWidth(); ++x) {
            Assert.assertEquals((long)(x / 5 + 1), (long)dataL1.getSample(x, 0, 0));
        }
    }

    private DefaultMultiLevelImage createMultiLevelImage(int sampleValue, int levelCount) {
        return new DefaultMultiLevelImage((MultiLevelSource)new DefaultMultiLevelSource((RenderedImage)this.createRenderedImage(sampleValue), levelCount));
    }
}

