/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.awt.geom.AffineTransform;
import junit.framework.Assert;
import org.esa.s3tbx.dataio.s3.slstr.SlstrTiePointGeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Before;
import org.junit.Test;

public class SlstrTiePointGeoCodingTest {
    private TiePointGrid lat;
    private TiePointGrid lon;
    private TiePointGeoCoding referenceGeoCoding;

    @Before
    public void setUp() {
        this.lat = new TiePointGrid("lat", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 9.0f, 1.0f, 9.0f});
        this.lon = new TiePointGrid("lon", 2, 2, 0.0, 0.0, 16.0, 16.0, new float[]{1.0f, 1.0f, 9.0f, 9.0f});
        this.referenceGeoCoding = new TiePointGeoCoding(this.lat, this.lon);
    }

    @Test
    public void testGetGeoPos_IdentityTransform() throws Exception {
        PixelPos pixelPos = new PixelPos(6.0, 6.0);
        GeoPos referenceGeoPos = new GeoPos();
        this.referenceGeoCoding.getGeoPos(pixelPos, referenceGeoPos);
        SlstrTiePointGeoCoding slstrTiePointGeoCoding = new SlstrTiePointGeoCoding(this.lat, this.lon, new AffineTransform2D(new AffineTransform()));
        GeoPos slstrGeoPos = new GeoPos();
        slstrTiePointGeoCoding.getGeoPos(pixelPos, slstrGeoPos);
        Assert.assertEquals((double)referenceGeoPos.getLat(), (double)slstrGeoPos.getLat(), (double)1.0E-8);
        Assert.assertEquals((double)referenceGeoPos.getLon(), (double)slstrGeoPos.getLon(), (double)1.0E-8);
    }

    @Test
    public void testGetPixelPos_IdentityTransform() throws Exception {
        GeoPos geoPos = new GeoPos(6.0, 6.0);
        PixelPos referencePixelPos = new PixelPos();
        this.referenceGeoCoding.getPixelPos(geoPos, referencePixelPos);
        SlstrTiePointGeoCoding slstrTiePointGeoCoding = new SlstrTiePointGeoCoding(this.lat, this.lon, new AffineTransform2D(new AffineTransform()));
        PixelPos slstrPixelPos = new PixelPos();
        slstrTiePointGeoCoding.getPixelPos(geoPos, slstrPixelPos);
        Assert.assertEquals((double)referencePixelPos.getX(), (double)slstrPixelPos.getX(), (double)1.0E-8);
        Assert.assertEquals((double)referencePixelPos.getY(), (double)slstrPixelPos.getY(), (double)1.0E-8);
    }

    @Test
    public void testGetGeoPos_Transform() throws Exception {
        PixelPos pixelPos1 = new PixelPos(4.0, 7.0);
        PixelPos pixelPos2 = new PixelPos(6.0, 6.0);
        PixelPos pixelPos3 = new PixelPos(7.0, 4.0);
        GeoPos referenceGeoPos1 = new GeoPos();
        GeoPos referenceGeoPos2 = new GeoPos();
        GeoPos referenceGeoPos3 = new GeoPos();
        this.referenceGeoCoding.getGeoPos(pixelPos1, referenceGeoPos1);
        this.referenceGeoCoding.getGeoPos(pixelPos2, referenceGeoPos2);
        this.referenceGeoCoding.getGeoPos(pixelPos3, referenceGeoPos3);
        AffineTransform transform = new AffineTransform();
        transform.scale(2.0, 2.0);
        transform.translate(1.0, 1.0);
        SlstrTiePointGeoCoding slstrTiePointGeoCoding = new SlstrTiePointGeoCoding(this.lat, this.lon, new AffineTransform2D(transform));
        GeoPos slstrGeoPos1 = new GeoPos();
        GeoPos slstrGeoPos2 = new GeoPos();
        GeoPos slstrGeoPos3 = new GeoPos();
        slstrTiePointGeoCoding.getGeoPos(pixelPos1, slstrGeoPos1);
        slstrTiePointGeoCoding.getGeoPos(pixelPos2, slstrGeoPos2);
        slstrTiePointGeoCoding.getGeoPos(pixelPos3, slstrGeoPos3);
        Assert.assertEquals((double)(referenceGeoPos1.getLat() * 2.0), (double)slstrGeoPos1.getLat(), (double)1.0E-8);
        Assert.assertEquals((double)(referenceGeoPos1.getLon() * 2.0), (double)slstrGeoPos1.getLon(), (double)1.0E-8);
        Assert.assertEquals((double)(referenceGeoPos2.getLat() * 2.0), (double)slstrGeoPos2.getLat(), (double)1.0E-8);
        Assert.assertEquals((double)(referenceGeoPos2.getLon() * 2.0), (double)slstrGeoPos2.getLon(), (double)1.0E-8);
        Assert.assertEquals((double)(referenceGeoPos3.getLat() * 2.0), (double)slstrGeoPos3.getLat(), (double)1.0E-8);
        Assert.assertEquals((double)(referenceGeoPos3.getLon() * 2.0), (double)slstrGeoPos3.getLon(), (double)1.0E-8);
    }

    @Test
    public void testGetPixelPos_Transform() throws Exception {
        GeoPos geoPos1 = new GeoPos(4.0, 7.0);
        GeoPos geoPos2 = new GeoPos(6.0, 6.0);
        GeoPos geoPos3 = new GeoPos(7.0, 4.0);
        PixelPos referencePixelPos1 = new PixelPos();
        PixelPos referencePixelPos2 = new PixelPos();
        PixelPos referencePixelPos3 = new PixelPos();
        this.referenceGeoCoding.getPixelPos(geoPos1, referencePixelPos1);
        this.referenceGeoCoding.getPixelPos(geoPos2, referencePixelPos2);
        this.referenceGeoCoding.getPixelPos(geoPos3, referencePixelPos3);
        AffineTransform transform = new AffineTransform();
        transform.scale(2.0, 2.0);
        transform.translate(1.0, 1.0);
        SlstrTiePointGeoCoding slstrTiePointGeoCoding = new SlstrTiePointGeoCoding(this.lat, this.lon, new AffineTransform2D(transform));
        PixelPos slstrPixelPos1 = new PixelPos();
        PixelPos slstrPixelPos2 = new PixelPos();
        PixelPos slstrPixelPos3 = new PixelPos();
        slstrTiePointGeoCoding.getPixelPos(geoPos1, slstrPixelPos1);
        slstrTiePointGeoCoding.getPixelPos(geoPos2, slstrPixelPos2);
        slstrTiePointGeoCoding.getPixelPos(geoPos3, slstrPixelPos3);
        Assert.assertEquals((double)(referencePixelPos1.getX() / 2.0 - 1.0), (double)slstrPixelPos1.getX(), (double)1.0E-8);
        Assert.assertEquals((double)(referencePixelPos1.getY() / 2.0 - 1.0), (double)slstrPixelPos1.getY(), (double)1.0E-8);
        Assert.assertEquals((double)(referencePixelPos2.getX() / 2.0 - 1.0), (double)slstrPixelPos2.getX(), (double)1.0E-8);
        Assert.assertEquals((double)(referencePixelPos2.getY() / 2.0 - 1.0), (double)slstrPixelPos2.getY(), (double)1.0E-8);
        Assert.assertEquals((double)(referencePixelPos3.getX() / 2.0 - 1.0), (double)slstrPixelPos3.getX(), (double)1.0E-8);
        Assert.assertEquals((double)(referencePixelPos3.getY() / 2.0 - 1.0), (double)slstrPixelPos3.getY(), (double)1.0E-8);
    }
}

