/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.awt.geom.Point2D;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.s3.slstr.SlstrGeoCodingSceneTransformProvider;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.operation.TransformException;

public class SlstrGeoCodingSceneTransformProviderTest {
    private SlstrGeoCodingSceneTransformProvider sceneTransformProvider;

    @Before
    public void setUp() {
        TiePointGrid sceneLatGrid = new TiePointGrid("sceneLat", 2, 2, 0.0, 0.0, 4.0, 4.0, new float[]{52.0f, 52.0f, 50.0f, 50.0f});
        TiePointGrid sceneLonGrid = new TiePointGrid("sceneLon", 2, 2, 0.0, 0.0, 4.0, 4.0, new float[]{4.0f, 6.0f, 4.0f, 6.0f});
        TiePointGeoCoding sceneGeoCoding = new TiePointGeoCoding(sceneLatGrid, sceneLonGrid);
        TiePointGrid modelLatGrid = new TiePointGrid("modelLat", 2, 2, 0.0, 0.0, 4.0, 4.0, new float[]{51.0f, 51.0f, 49.0f, 49.0f});
        TiePointGrid modelLonGrid = new TiePointGrid("modelLon", 2, 2, 0.0, 0.0, 4.0, 4.0, new float[]{5.0f, 7.0f, 5.0f, 7.0f});
        TiePointGeoCoding modelGeoCoding = new TiePointGeoCoding(modelLatGrid, modelLonGrid);
        this.sceneTransformProvider = new SlstrGeoCodingSceneTransformProvider((GeoCoding)sceneGeoCoding, (GeoCoding)modelGeoCoding);
    }

    @Test
    public void testGetSceneToModelTransform() throws TransformException {
        Point2D.Double[] ptSrcs = new Point2D.Double[]{new Point2D.Double(2.0, 2.0), new Point2D.Double(3.5, 2.5)};
        Point2D.Double[] expected = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(1.5, 0.5)};
        for (int i = 0; i < 2; ++i) {
            Point2D.Double ptDst = new Point2D.Double();
            Point2D result = this.sceneTransformProvider.getSceneToModelTransform().transform((Point2D)ptSrcs[i], (Point2D)ptDst);
            TestCase.assertNotNull((Object)result);
            Assert.assertEquals((double)ptDst.getX(), (double)result.getX(), (double)1.0E-8);
            Assert.assertEquals((double)ptDst.getY(), (double)result.getY(), (double)1.0E-8);
            Assert.assertEquals((double)expected[i].getX(), (double)ptDst.getX(), (double)1.0E-8);
            Assert.assertEquals((double)expected[i].getY(), (double)ptDst.getY(), (double)1.0E-8);
        }
    }

    @Test
    public void testGetModelToSceneTransform() throws TransformException {
        Point2D.Double[] ptSrcs = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(1.5, 0.5)};
        Point2D.Double[] expected = new Point2D.Double[]{new Point2D.Double(2.0, 2.0), new Point2D.Double(3.5, 2.5)};
        for (int i = 0; i < 2; ++i) {
            Point2D.Double ptDst = new Point2D.Double();
            Point2D result = this.sceneTransformProvider.getModelToSceneTransform().transform((Point2D)ptSrcs[i], (Point2D)ptDst);
            TestCase.assertNotNull((Object)result);
            Assert.assertEquals((double)ptDst.getX(), (double)result.getX(), (double)1.0E-8);
            Assert.assertEquals((double)ptDst.getY(), (double)result.getY(), (double)1.0E-8);
            Assert.assertEquals((double)expected[i].getX(), (double)ptDst.getX(), (double)1.0E-8);
            Assert.assertEquals((double)expected[i].getY(), (double)ptDst.getY(), (double)1.0E-8);
        }
    }
}

