/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.aatsr;

import org.esa.s3tbx.dataio.s3.aatsr.AatsrS3NetcdfReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.SampleCoding;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class AatsrS3NetcdfReaderTest {
    private AatsrS3NetcdfReader reader;
    private Product product;
    private boolean synthetic;
    private Variable variable;

    @Before
    public void setUp() throws Exception {
        this.reader = new AatsrS3NetcdfReader();
        this.product = new Product("p", "t", 44, 22);
        this.synthetic = true;
        this.variable = (Variable)Mockito.mock(Variable.class);
    }

    @Test
    public void addVariableAsBand_DataType_CHAR() throws Exception {
        Mockito.when((Object)this.variable.getDataType()).thenReturn((Object)DataType.CHAR);
        Mockito.when((Object)this.variable.getDescription()).thenReturn((Object)"v-description");
        Mockito.when((Object)this.variable.getUnitsString()).thenReturn((Object)"v-unit");
        Mockito.when((Object)this.variable.findAttribute("scaling_factor")).thenReturn((Object)this.attr("scaling_factor", 1.23));
        Mockito.when((Object)this.variable.findAttribute("add_offset")).thenReturn((Object)this.attr("add_offset", 2.34));
        Mockito.when((Object)this.variable.findAttribute("_FillValue")).thenReturn((Object)this.attr("_FillValue", 3));
        Mockito.when((Object)this.variable.findAttribute("flag_values")).thenReturn((Object)this.attr("flag_values", this.arr(new byte[]{1, 2, 4})));
        Mockito.when((Object)this.variable.findAttribute("flag_meanings")).thenReturn((Object)this.attr("flag_meanings", "a b c"));
        this.reader.addVariableAsBand(this.product, this.variable, "v-name", this.synthetic);
        Band band = this.product.getBand("v-name");
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)"v-description", (Object)band.getDescription());
        Assert.assertEquals((Object)"v-unit", (Object)band.getUnit());
        Assert.assertEquals((Object)"1.23", (Object)String.valueOf(band.getScalingFactor()));
        Assert.assertEquals((Object)"2.34", (Object)String.valueOf(band.getScalingOffset()));
        Assert.assertEquals((Object)this.synthetic, (Object)band.isSynthetic());
        Assert.assertEquals((Object)true, (Object)band.isNoDataValueUsed());
        Assert.assertEquals((Object)true, (Object)band.isNoDataValueSet());
        Assert.assertEquals((Object)"3.0", (Object)String.valueOf(band.getNoDataValue()));
        SampleCoding sampleCoding = band.getSampleCoding();
        Assert.assertEquals((Object)"v-name", (Object)sampleCoding.getName());
        Assert.assertEquals(null, (Object)sampleCoding.getDescription());
        Assert.assertEquals((long)3L, (long)sampleCoding.getNumAttributes());
        Assert.assertEquals((Object)"a", (Object)sampleCoding.getAttributeAt(0).getName());
        Assert.assertEquals((long)1L, (long)sampleCoding.getAttributeAt(0).getData().getElemInt());
        Assert.assertEquals((Object)"b", (Object)sampleCoding.getAttributeAt(1).getName());
        Assert.assertEquals((long)2L, (long)sampleCoding.getAttributeAt(1).getData().getElemInt());
        Assert.assertEquals((Object)"c", (Object)sampleCoding.getAttributeAt(2).getName());
        Assert.assertEquals((long)4L, (long)sampleCoding.getAttributeAt(2).getData().getElemInt());
    }

    @Test
    public void testAddVariableAsBand_DataType_Byte() {
        Mockito.when((Object)this.variable.getDataType()).thenReturn((Object)DataType.BYTE);
        this.reader.addVariableAsBand(this.product, this.variable, "byte-name", this.synthetic);
        Band band = this.product.getBand("byte-name");
        Assert.assertNotNull((Object)band);
    }

    private Array arr(Object javaArray) {
        return Array.factory((Object)javaArray);
    }

    private Attribute attr(String name, String val) {
        return new Attribute(name, val);
    }

    private Attribute attr(String name, Number val) {
        return new Attribute(name, val);
    }

    private Attribute attr(String name, Array arr) {
        return new Attribute(name, arr);
    }
}

